/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.wmt.WMTGeoResource;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTServiceInfo;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASourceManager;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSourceFactory;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WMTService
extends IService {
    public static String ID = "wmt://localhost/wmt/";
    public static String KEY_PROPERTY_ZOOM_LEVEL_SELECTION_AUTOMATIC = "PROPERTY_ZOOM_LEVEL_SELECTION_AUTOMATIC";
    public static String KEY_PROPERTY_ZOOM_LEVEL_VALUE = "PROPERTY_ZOOM_LEVEL_VALUE";
    private volatile List<IGeoResource> members;
    private Map<String, Serializable> params;
    private URL url;
    Exception message = null;

    public WMTService(Map<String, Serializable> params) {
        this.params = params;
        if (params != null && params.containsKey("net.refractions.udig.catalog.internal.wmt.url")) {
            if (params.get("net.refractions.udig.catalog.internal.wmt.url") instanceof URL) {
                this.url = (URL)params.get("net.refractions.udig.catalog.internal.wmt.url");
            } else {
                try {
                    this.url = new URL(null, (String)((Object)params.get("net.refractions.udig.catalog.internal.wmt.url")), CorePlugin.RELAXED_HANDLER);
                }
                catch (MalformedURLException exc) {
                    WMTPlugin.log("[WMTService] Could not create url: " + params.get("net.refractions.udig.catalog.internal.wmt.url"), exc);
                    this.url = null;
                }
            }
        }
    }

    public String getName() {
        try {
            List<IGeoResource> resources = this.resources(null);
            if (resources.size() > 0) {
                WMTGeoResource wmtResource = (WMTGeoResource)resources.get(0);
                return wmtResource.getSource().getName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        return (T)super.resolve(adaptee, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            WMTService wMTService = this;
            synchronized (wMTService) {
                if (this.info == null) {
                    this.info = new WMTServiceInfo(this, monitor);
                }
            }
        }
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            WMTService wMTService = this;
            synchronized (wMTService) {
                if (this.members == null) {
                    try {
                        if (!WMTSourceFactory.getClassFromUrl(this.getIdentifier()).equals(NASASource.class.getCanonicalName())) {
                            return Collections.singletonList(new WMTGeoResource(this, "blank"));
                        }
                        this.members = new LinkedList<IGeoResource>();
                        NASASourceManager sourceManager = NASASourceManager.getInstance();
                        sourceManager.buildGeoResources(this, this.members);
                    }
                    catch (Exception exc) {
                        this.message = exc;
                    }
                }
            }
        }
        return this.members;
    }

    public List<IGeoResource> emptyResourcesList(IProgressMonitor monitor) throws IOException {
        this.members = new LinkedList<IGeoResource>();
        return this.members;
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return super.canResolve(adaptee);
    }

    public IResolve.Status getStatus() {
        if (this.members == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.message;
    }

    public URL getIdentifier() {
        return this.url;
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
    }
}

