/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.wmt.WMTGeoResourceInfo;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSourceFactory;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WMTGeoResource
extends IGeoResource {
    public static final String DEFAULT_ID = "blank";
    private WMTService wmtService;
    private String resourceId;
    private WMTSource source;
    private Throwable msg;

    public WMTGeoResource(WMTService service, String resourceId) {
        String sourceInitData;
        this.service = service;
        this.wmtService = service;
        this.resourceId = resourceId.equals(DEFAULT_ID) ? ((sourceInitData = this.getSourceInitDataFromUrl(this.wmtService.getIdentifier())) != null ? sourceInitData : resourceId) : resourceId;
        this.source = null;
    }

    private String getSourceInitDataFromUrl(URL url) {
        String className = WMTSourceFactory.getClassFromUrl(url);
        String styleId = url.toString().replace(WMTService.ID, "").replace(className, "");
        if (!styleId.isEmpty()) {
            return styleId.replaceFirst("/", "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMTSource getSource() {
        if (this.source == null) {
            WMTGeoResource wMTGeoResource = this;
            synchronized (wMTGeoResource) {
                if (this.source == null) {
                    try {
                        this.source = WMTSourceFactory.createSource(this.wmtService, this.wmtService.getIdentifier(), this.resourceId);
                    }
                    catch (Throwable t) {
                        WMTPlugin.log("[WMTSource] Creating source failed: wmtService.getIdentifier() + #" + this.resourceId, t);
                        this.source = null;
                        this.msg = t;
                    }
                }
            }
        }
        return this.source;
    }

    public String getTitle() {
        return this.getSource().getName();
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(WMTSource.class) || super.canResolve(adaptee));
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(WMTSource.class)) {
            return adaptee.cast(this.getSource());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            WMTGeoResource wMTGeoResource = this;
            synchronized (wMTGeoResource) {
                if (this.info == null) {
                    this.info = new WMTGeoResourceInfo(this, monitor);
                }
            }
        }
        return this.info;
    }

    public IResolve.Status getStatus() {
        if (this.msg != null) {
            return IResolve.Status.BROKEN;
        }
        if (this.source == null) {
            return IResolve.Status.NOTCONNECTED;
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        try {
            return new URL(null, String.valueOf(this.service.getIdentifier().toString()) + "#" + this.resourceId, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            WMTPlugin.log("[WMTGeoResource.getIdentifier] Construction the id failed: " + this.resourceId, e);
            return this.service.getIdentifier();
        }
    }
}

