/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.mapquest.apiwrapper;

import com.mapquest.DisplayState;
import com.mapquest.Exec;
import com.mapquest.LatLng;
import com.mapquest.MQObject;
import com.mapquest.MapState;
import com.mapquest.Session;
import java.text.DecimalFormat;

public class MQAPIWrapper {
    static final String MQ_MAP_SERVER_NAME = "map.free.mapquest.com";
    static final String MQ_MAP_SERVER_PATH = "mq";
    static final int MQ_MAP_SERVER_PORT = 80;
    private Exec mapClient = new Exec();
    private static final DecimalFormat formatter = new DecimalFormat("##0.#################");

    public MQAPIWrapper() {
        this.mapClient.setServerName(MQ_MAP_SERVER_NAME);
        this.mapClient.setServerPath(MQ_MAP_SERVER_PATH);
        this.mapClient.setServerPort(80);
        this.mapClient.setClientId("your-client-id");
        this.mapClient.setPassword("your-password");
    }

    public String getUrl(int scale, double x, double y, int width, int height) throws Exception {
        MapState mapState = new MapState();
        mapState.setWidthPixels(width);
        mapState.setHeightPixels(height);
        mapState.setMapScale(scale);
        mapState.setCenter(new LatLng(y, x));
        Session mqSession = new Session();
        mqSession.addOne((MQObject)mapState);
        return this.getCorrectUrl(this.mapClient.getMapDirectURLEx(mqSession, new DisplayState()), x, y);
    }

    private String getCorrectUrl(String mqUrl, double x, double y) {
        try {
            int index3rdComma = mqUrl.indexOf(44, mqUrl.indexOf(44, mqUrl.indexOf(44) + 1) + 1);
            int index5thComma = mqUrl.indexOf(44, mqUrl.indexOf(44, index3rdComma + 1) + 1);
            return String.valueOf(mqUrl.substring(0, index3rdComma + 1)) + this.parseDouble(y) + "," + this.parseDouble(x) + mqUrl.substring(index5thComma, mqUrl.length());
        }
        catch (Exception exception) {
            return mqUrl;
        }
    }

    private String parseDouble(double value) {
        return formatter.format(value).replace(',', '.');
    }
}

