/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.gridcoverage.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collections;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.rasterings.GridCoverageLoader;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.render.gridcoverage.basic.internal.Messages;
import net.refractions.udig.render.internal.gridcoverage.basic.GridCoverageRenderState;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class MemoryGridCoverageRenderer
extends RendererImpl {
    private GridCoverageRenderer renderer;

    public synchronized void render(Graphics2D graphics, IProgressMonitor monitor) throws RenderException {
        block13: {
            try {
                IRenderContext currentContext = this.getContext();
                currentContext.setStatus(1);
                currentContext.setStatusMessage(Messages.BasicGridCoverageRenderer_rendering_status);
                ReferencedEnvelope envelope = this.getRenderBounds();
                if (envelope == null || envelope.isNull()) {
                    envelope = this.context.getImageBounds();
                }
                Point upperLeft = currentContext.worldToPixel(new Coordinate(envelope.getMinX(), envelope.getMinY()));
                Point bottomRight = currentContext.worldToPixel(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
                Rectangle screenSize = new Rectangle(upperLeft);
                screenSize.add(bottomRight);
                IMapDisplay mapDisplay = currentContext.getMapDisplay();
                CoordinateReferenceSystem destinationCRS = currentContext.getCRS();
                IGeoResource geoResource = currentContext.getGeoResource();
                ReferencedEnvelope bounds = currentContext.getImageBounds();
                bounds = bounds.transform(destinationCRS, true);
                GridEnvelope2D range = new GridEnvelope2D(0, 0, mapDisplay.getWidth(), mapDisplay.getHeight());
                MathTransform2D displayToLayer = currentContext.worldToScreenMathTransform().inverse();
                ReferencingFactoryFinder.getMathTransformFactory(null).createConcatenatedTransform((MathTransform)displayToLayer, currentContext.getLayer().mapToLayerTransform());
                GridGeometry2D geom = new GridGeometry2D((GridEnvelope)range, (MathTransform)displayToLayer, destinationCRS);
                currentContext.setStatus(5);
                this.setState(32);
                GridCoverageLoader loader = (GridCoverageLoader)geoResource.resolve(GridCoverageLoader.class, monitor);
                if (loader == null) {
                    return;
                }
                try {
                    GridCoverage2D coverage = (GridCoverage2D)loader.load((GeneralGridGeometry)geom, monitor);
                    if (coverage == null) break block13;
                    RenderingHints hints = new RenderingHints(Collections.EMPTY_MAP);
                    hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                    hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
                    hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                    hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
                    hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, new InterpolationNearest()));
                    graphics.addRenderingHints(hints);
                    TileCache tempCache = currentContext.getTileCache();
                    hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, tempCache));
                    if (CRS.getHorizontalCRS((CoordinateReferenceSystem)destinationCRS) == null) {
                        destinationCRS = coverage.getCoordinateReferenceSystem2D();
                    }
                    try {
                        Style style = this.grabStyle();
                        Rule rule = SLDs.getRasterSymbolizerRule((Style)style);
                        double currentScale = currentContext.getViewportModel().getScaleDenominator();
                        double minScale = rule.getMinScaleDenominator();
                        double maxScale = rule.getMaxScaleDenominator();
                        if (minScale <= currentScale && currentScale <= maxScale) {
                            GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, (Envelope)envelope, screenSize, null, hints);
                            RasterSymbolizer rasterSymbolizer = SLD.rasterSymbolizer((Style)style);
                            String maskColor = this.getContext().getLayer().getStyleBlackboard().getString("raster-color-mask");
                            if (maskColor instanceof String) {
                                String[] colorSplit = maskColor.split(":");
                                Color color = new Color(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]));
                                RenderedImage image = coverage.getRenderedImage();
                                ImageWorker iw = new ImageWorker(image);
                                iw.makeColorTransparent(color);
                                image = iw.getRenderedImage();
                                GridCoverageFactory gcF = CoverageFactoryFinder.getGridCoverageFactory(null);
                                coverage = gcF.create((CharSequence)coverage.getName(), image, coverage.getCoordinateReferenceSystem(), coverage.getGridGeometry().getGridToCRS(), coverage.getSampleDimensions(), null, null);
                            }
                            paint.paint(graphics, coverage, rasterSymbolizer);
                            this.setState(4);
                        }
                    }
                    catch (Exception exception) {
                        GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, (Envelope)envelope, screenSize, null, hints);
                        RasterSymbolizer rasterSymbolizer = CommonFactoryFinder.getStyleFactory(null).createRasterSymbolizer();
                        paint.paint(graphics, coverage, rasterSymbolizer);
                        this.setState(4);
                    }
                }
                catch (Exception e1) {
                    throw new RenderException((Throwable)e1);
                }
            }
            finally {
                this.getContext().setStatus(0);
                this.getContext().setStatusMessage(null);
            }
        }
    }

    private Style grabStyle() {
        StyleBlackboard styleBlackboard = (StyleBlackboard)this.getContext().getLayer().getStyleBlackboard();
        Style style = (Style)styleBlackboard.lookup(Style.class);
        return style;
    }

    public void doRender(GridCoverageRenderer renderer, Graphics2D graphics, GridCoverageRenderState state) {
        double scale = state.context.getViewportModel().getScaleDenominator();
        if (scale < state.minScale || scale > state.maxScale) {
            return;
        }
        state.context.setStatus(1);
        state.context.setStatusMessage(Messages.BasicGridCoverageRenderer_rendering_status);
        Composite oldComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, state.opacity));
        Rectangle displayArea = state.displayArea;
        AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)state.bounds, (Rectangle)displayArea);
        AffineTransform tempTransform = graphics.getTransform();
        AffineTransform atg = new AffineTransform(tempTransform);
        atg.concatenate(at);
        graphics.setTransform(atg);
        try {
            GridCoverage coverage = (GridCoverage)this.getContext().getGeoResource().resolve(GridCoverage.class, null);
            StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
            RasterSymbolizer rasterSymbolizer = factory.createRasterSymbolizer();
            renderer.paint(graphics, (GridCoverage2D)coverage, rasterSymbolizer);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (FactoryException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (NoninvertibleTransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        graphics.setComposite(oldComposite);
        graphics.setTransform(tempTransform);
        if (state.context.getStatus() == 1) {
            state.context.setStatus(0);
            state.context.setStatusMessage(null);
        }
    }

    public static GridCoverageRenderState getRenderState(IRenderContext context) {
        StyleBlackboard styleBlackboard = (StyleBlackboard)context.getLayer().getStyleBlackboard();
        Style style = (Style)styleBlackboard.lookup(Style.class);
        double minScale = Double.MIN_VALUE;
        double maxScale = Double.MAX_VALUE;
        float opacity = 1.0f;
        if (style != null) {
            try {
                FeatureTypeStyle featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(0);
                Rule rule = (Rule)featureStyle.rules().get(0);
                minScale = rule.getMinScaleDenominator();
                maxScale = rule.getMaxScaleDenominator();
                if (rule.getSymbolizers()[0] instanceof RasterSymbolizer) {
                    RasterSymbolizer rs = (RasterSymbolizer)rule.getSymbolizers()[0];
                    opacity = MemoryGridCoverageRenderer.getOpacity(rs);
                }
            }
            catch (Exception e) {
                ProjectPlugin.getPlugin().log((Object)e);
            }
        } else {
            opacity = 1.0f;
            minScale = 0.0;
            maxScale = Double.MAX_VALUE;
        }
        Rectangle displayArea = new Rectangle(context.getMapDisplay().getWidth(), context.getMapDisplay().getHeight());
        return new GridCoverageRenderState(context, context.getImageBounds(), displayArea, opacity, minScale, maxScale);
    }

    private static float getOpacity(RasterSymbolizer sym) {
        float alpha = 1.0f;
        Expression exp = sym.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Object obj = exp.evaluate(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private GridCoverageRenderState prepareRender(IProgressMonitor monitor) throws IOException {
        try {
            CoordinateReferenceSystem contextCRS = this.getContext().getCRS();
            Rectangle rectangle = new Rectangle(this.getContext().getMapDisplay().getDisplaySize());
            ReferencedEnvelope bounds = this.getRenderBounds();
            if (bounds == null) {
                ReferencedEnvelope all;
                bounds = this.getContext().getImageBounds();
                if (bounds instanceof ReferencedEnvelope) {
                    all = bounds;
                    if (!contextCRS.equals(all.getCoordinateReferenceSystem())) {
                        bounds = all.transform(contextCRS, true, 10);
                    }
                } else {
                    all = new ReferencedEnvelope((Envelope)bounds, this.getContext().getViewportModel().getCRS());
                    bounds = all.transform(contextCRS, true, 10);
                }
            }
            AffineTransform world2screen = null;
            this.renderer = new GridCoverageRenderer(contextCRS, (Envelope)bounds, rectangle, world2screen);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (NoninvertibleTransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (FactoryException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return MemoryGridCoverageRenderer.getRenderState(this.getContext());
    }

    public void stopRendering() {
        this.setState(1);
    }

    public void dispose() {
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        this.render(this.getContext().getImage().createGraphics(), monitor);
    }
}

