/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.gridcoverage.basic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.core.MinMaxScaleCalculator;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.render.internal.gridcoverage.basic.MemoryGridCoverageMetricsFactory;
import net.refractions.udig.render.internal.gridcoverage.basic.MemoryGridCoverageRenderer;
import net.refractions.udig.ui.graphics.SLDs;
import org.geotools.styling.Style;
import org.geotools.util.Range;

public class MemoryGridCoverageMetrics
extends AbstractRenderMetrics {
    private static List<String> listExpectedStyleIds() {
        ArrayList<String> styleIds = new ArrayList<String>();
        styleIds.add("net.refractions.udig.style.sld");
        styleIds.add("net.refractions.udig.style.cache");
        return styleIds;
    }

    public MemoryGridCoverageMetrics(IRenderContext context2, MemoryGridCoverageMetricsFactory factory) {
        super(context2, (IRenderMetricsFactory)factory, MemoryGridCoverageMetrics.listExpectedStyleIds());
        this.resolutionMetric = 0.5;
        ID id = this.context.getGeoResource().getID();
        if (id.isMemory()) {
            this.latencyMetric = 0L;
            this.timeToDrawMetric = 200L;
        } else {
            this.latencyMetric = 100L;
            this.timeToDrawMetric = 200L;
        }
    }

    public MemoryGridCoverageRenderer createRenderer() {
        MemoryGridCoverageRenderer r = new MemoryGridCoverageRenderer();
        r.setContext(this.context);
        return r;
    }

    public IRenderContext getRenderContext() {
        return this.context;
    }

    public IRenderMetricsFactory getRenderMetricsFactory() {
        return this.factory;
    }

    public boolean canAddLayer(ILayer layer) {
        return false;
    }

    public boolean canStyle(String styleID, Object value) {
        if ("net.refractions.udig.style.cache".equals(styleID)) {
            return Boolean.TRUE.equals(value);
        }
        if (value != null && value instanceof Style) {
            Style style = (Style)value;
            return SLDs.rasterSymbolizer((Style)style) != null;
        }
        return false;
    }

    public boolean isOptimized() {
        return false;
    }

    public Set<Range<Double>> getValidScaleRanges() {
        Object value = this.context.getLayer().getStyleBlackboard().get("net.refractions.udig.style.sld");
        if (value == null) {
            return new HashSet<Range<Double>>();
        }
        if (value instanceof Style) {
            Style style = (Style)value;
            return MinMaxScaleCalculator.getValidScaleRanges((Style)style);
        }
        System.out.println("Unexpected " + value.getClass() + " for " + "net.refractions.udig.style.sld" + ":" + value);
        return new HashSet<Range<Double>>();
    }
}

