/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.gridcoverage.tool.info.internal;

import net.refractions.udig.render.gridcoverage.basic.internal.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class ChannelViewer {
    private Group channelGrp;
    private Combo cmbBands;
    private Slider sliderConst;
    private Label lblSlider;
    private String name;
    private SelectionListener sync;
    private ControlDecoration warningDecorator;

    public ChannelViewer(String name, SelectionListener listener) {
        this.name = name;
        this.sync = listener;
    }

    public void setBands(String[] bands) {
        if (this.cmbBands != null) {
            this.cmbBands.removeAll();
            if (bands != null) {
                String[] stringArray = bands;
                int n = bands.length;
                int n2 = 0;
                while (n2 < n) {
                    String band = stringArray[n2];
                    this.cmbBands.add(band);
                    ++n2;
                }
            }
        }
    }

    public void set(int bandIndex, double colorCorrection) {
        this.listen(false);
        try {
            this.cmbBands.select(bandIndex);
            this.sliderConst.setSelection((int)colorCorrection + 255);
            this.lblSlider.setText(String.valueOf((int)colorCorrection));
        }
        finally {
            this.listen(true);
        }
    }

    void listen(boolean listen) {
        if (listen) {
            this.cmbBands.addSelectionListener(this.sync);
            this.sliderConst.addSelectionListener(this.sync);
        } else {
            this.cmbBands.removeSelectionListener(this.sync);
            this.sliderConst.removeSelectionListener(this.sync);
        }
    }

    public void createControl(Composite parent) {
        this.channelGrp = new Group(parent, 16);
        this.channelGrp.setText(this.name);
        this.channelGrp.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        this.channelGrp.setLayout((Layout)layout);
        Label lblBand = new Label((Composite)this.channelGrp, 0);
        lblBand.setText(Messages.ChannelViewer_BandLabel);
        this.cmbBands = new Combo((Composite)this.channelGrp, 12);
        this.cmbBands.setText("-1");
        Image fieldDecorationWarningImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.warningDecorator = new ControlDecoration((Control)this.cmbBands, 0x1020000);
        this.warningDecorator.setMarginWidth(4);
        this.warningDecorator.setImage(fieldDecorationWarningImage);
        this.warningDecorator.setDescriptionText("Warning!");
        this.warningDecorator.hide();
        Composite sliderGrp = new Composite((Composite)this.channelGrp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        sliderGrp.setLayout((Layout)new GridLayout(1, false));
        sliderGrp.setLayoutData((Object)gd);
        Composite grp = new Composite(sliderGrp, 0);
        grp.setLayout((Layout)new GridLayout(4, true));
        gd = new GridData(768);
        grp.setLayoutData((Object)gd);
        this.sliderConst = new Slider(grp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.sliderConst.setLayoutData((Object)gd);
        this.sliderConst.setMinimum(0);
        this.sliderConst.setMaximum(510);
        this.lblSlider = new Label(grp, 0);
        gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 25;
        this.lblSlider.setLayoutData((Object)gd);
        this.lblSlider.setText("0000");
        Label txtLeft = new Label(grp, 16384);
        txtLeft.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        txtLeft.setText("-255");
        Label txtMiddle = new Label(grp, 0x1000000);
        txtMiddle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        txtMiddle.setText("0");
        Label txtRight = new Label(grp, 131072);
        txtRight.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        txtRight.setText("255");
        this.sliderConst.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ChannelViewer.this.lblSlider.setText(String.valueOf(ChannelViewer.this.sliderConst.getSelection() - 255));
            }
        });
        this.sliderConst.setSelection(255);
        this.listen(true);
    }

    public void setError(String error) {
        if (error != null) {
            this.warningDecorator.setDescriptionText(error);
            this.warningDecorator.show();
        } else {
            this.warningDecorator.hide();
        }
    }

    public int getBandIndex() {
        return this.cmbBands.getSelectionIndex();
    }

    public int getColorCorrectionValue() {
        return this.sliderConst.getSelection() - 255;
    }
}

