/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.gridcoverage.tool.info;

import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.render.gridcoverage.tool.info.internal.MosaicInfoView;
import net.refractions.udig.render.internal.gridcoverage.basic.RendererPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MoasicInfoTool
extends AbstractModalTool
implements ModalTool {
    public static final String ID = "net.refractions.udig.render.gridcoverage.tool.info.mosaicInfoTool";
    public static final String CATEGORY_ID = "net.refractions.udig.tool.category.info";
    SelectionBoxCommand draw = new SelectionBoxCommand();

    public MoasicInfoTool() {
        super(3);
    }

    public void mousePressed(MapMouseEvent e) {
        this.draw.setValid(true);
        this.context.sendASyncCommand((Command)this.draw);
        this.feedback(e);
    }

    public void mouseDragged(MapMouseEvent e) {
        this.feedback(e);
    }

    public void feedback(MapMouseEvent e) {
        this.draw.setShape((Shape)new Rectangle(e.x - 3, e.y - 3, 5, 5));
        this.context.getViewportPane().repaint(e.x - 4, e.y - 4, 7, 7);
        super.mouseDragged(e);
    }

    public void mouseReleased(MapMouseEvent e) {
        try {
            try {
                ReferencedEnvelope bbox = this.context.getBoundingBox(e.getPoint(), 5);
                final MosaicInfoView.InfoRequest request = new MosaicInfoView.InfoRequest();
                request.bbox = bbox;
                request.layers = this.context.getMapLayers();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page;
                        MosaicInfoView infoView = (MosaicInfoView)ApplicationGIS.getView((boolean)true, (String)"net.refractions.udig.render.gridcoverage.view.infoView");
                        if (infoView != null && infoView.getSite().getSelectionProvider() != null) {
                            infoView.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
                        }
                        if (!(page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).isPartVisible((IWorkbenchPart)infoView)) {
                            page.bringToTop((IWorkbenchPart)infoView);
                        }
                        infoView = (MosaicInfoView)ApplicationGIS.getView((boolean)false, (String)"net.refractions.udig.render.gridcoverage.view.infoView");
                        infoView.updateInfo(request);
                    }
                });
            }
            catch (Throwable e1) {
                RendererPlugin.log("Could not display information", e1);
                this.draw.setValid(false);
                this.context.getViewportPane().repaint();
            }
        }
        finally {
            this.draw.setValid(false);
            this.context.getViewportPane().repaint();
        }
    }

    public void dispose() {
        super.dispose();
    }
}

