/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.trim.internal;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import eu.udig.tools.geometry.trim.TrimGeometryStrategy;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.mediator.AppGISAdapter;
import eu.udig.tools.internal.mediator.PlatformGISMediator;
import eu.udig.tools.internal.ui.util.DialogUtil;
import java.util.ArrayList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.geotools.data.FeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class TrimFeaturesCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private ILayer selectedLayer;
    private LineString trimmingLine;
    private PrimitiveShape currentShape;
    private FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToTrim;
    private UndoableComposite composite;

    public TrimFeaturesCommand(EditToolHandler handler, ILayer selectedLayer, FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToTrim, LineString trimmingLine) {
        assert (selectedLayer.hasResource(FeatureStore.class)) : "Layer hasn't feature store.";
        this.handler = handler;
        this.selectedLayer = selectedLayer;
        this.featuresToTrim = featuresToTrim;
        this.trimmingLine = trimmingLine;
    }

    public static boolean openQuestion(final String title, final String message) {
        final boolean[] confirm = new boolean[1];
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                confirm[0] = MessageDialog.openQuestion(null, (String)title, (String)message);
            }
        });
        return confirm[0];
    }

    public String getName() {
        return "Trim Features Command";
    }

    public void run(final IProgressMonitor monitor) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditCommandFactory editCommandFactory = AppGISAdapter.getEditCommandFactory();
                FeatureIterator iterator = TrimFeaturesCommand.this.featuresToTrim.features();
                ArrayList<UndoableMapCommand> undoableCommands = new ArrayList<UndoableMapCommand>();
                TrimGeometryStrategy trimOp = new TrimGeometryStrategy(TrimFeaturesCommand.this.trimmingLine);
                String fidNotTrimmed = "";
                try {
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        Geometry original = (Geometry)feature.getDefaultGeometry();
                        if (TrimFeaturesCommand.this.checkTrimPossible(original)) {
                            Geometry trimmed = trimOp.trim(original);
                            UndoableMapCommand command = editCommandFactory.createSetGeomteryCommand(feature, TrimFeaturesCommand.this.selectedLayer, trimmed);
                            undoableCommands.add(command);
                            continue;
                        }
                        fidNotTrimmed = String.valueOf(fidNotTrimmed) + feature.getID() + " ";
                    }
                }
                finally {
                    TrimFeaturesCommand.this.featuresToTrim.close(iterator);
                }
                if (!fidNotTrimmed.equals("")) {
                    DialogUtil.openInformation(Messages.TrimFeaturesCommand_no_features_modified, String.valueOf(Messages.TrimFeaturesCommand_unvalid_intersection) + fidNotTrimmed);
                } else {
                    TrimFeaturesCommand.this.composite = new UndoableComposite(undoableCommands);
                    try {
                        TrimFeaturesCommand.this.composite.run(monitor);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    TrimFeaturesCommand.this.currentShape = TrimFeaturesCommand.this.handler.getCurrentShape();
                    TrimFeaturesCommand.this.handler.setCurrentShape(null);
                    TrimFeaturesCommand.this.handler.setCurrentState(EditState.NONE);
                }
            }
        };
        ViewportPane pane = this.handler.getContext().getViewportPane();
        AppGISAdapter.showWhile(pane, runnable);
    }

    private boolean checkTrimPossible(Geometry original) {
        return this.trimmingLine.intersects(original) && this.trimmingLine.intersection(original).getNumGeometries() == 1;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.composite != null) {
            this.handler.setCurrentState(EditState.CREATING);
            this.handler.setCurrentShape(this.currentShape);
            this.composite.rollback(monitor);
        }
    }
}

