/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.split;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import eu.udig.tools.feature.split.CannotSplitException;
import eu.udig.tools.feature.split.SplitFeatureBuilder;
import eu.udig.tools.feature.split.SplitFeatureBuilderFailException;
import eu.udig.tools.feature.util.GeoToolsUtils;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.LayerUtil;
import eu.udig.tools.internal.ui.util.MapUtil;
import eu.udig.tools.split.ModifyGeometryFeatureCommand;
import eu.udig.tools.split.SplitFeaturesCommandException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.GeometryCreationUtil;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class SplitFeaturesCommand
extends AbstractCommand
implements UndoableMapCommand {
    private static final String className = SplitFeaturesCommand.class.getName();
    private EditToolHandler handler;
    private ILayer selectedLayer;
    private UndoableComposite composite;

    public SplitFeaturesCommand(EditToolHandler handler) {
        ILayer selectedLayer = handler.getContext().getSelectedLayer();
        assert (selectedLayer.getSchema() != null);
        Class geometryBinding = selectedLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        assert (geometryBinding != Point.class);
        assert (geometryBinding != MultiPoint.class);
        assert (selectedLayer.hasResource(FeatureStore.class));
        this.handler = handler;
        this.selectedLayer = selectedLayer;
    }

    public String getName() {
        return "Split Features Command";
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor prepMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)80);
        prepMonitor.beginTask("Splitting features", 1);
        LineString splitter = this.getSplittingLineInMapCRS(this.handler);
        assert (splitter.getUserData() instanceof CoordinateReferenceSystem);
        FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToSplit = this.getFeaturesToSplit(splitter);
        prepMonitor.worked(2);
        ArrayList<UndoableMapCommand> undoableCommands = new ArrayList<UndoableMapCommand>();
        List<UndoableMapCommand> commands = this.buildCommandList(featuresToSplit, splitter);
        undoableCommands.addAll(commands);
        prepMonitor.worked(3);
        prepMonitor.done();
        if (undoableCommands.size() == 0) {
            ProjectPlugin.log((String)"The split did not apply to any feature");
            throw new IllegalArgumentException(Messages.SplitFeaturesCommand_did_not_apply_to_any_feature);
        }
        SubMonitor splitMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        this.composite = new UndoableComposite(undoableCommands);
        this.composite.setMap((IMap)this.getMap());
        this.composite.run((IProgressMonitor)splitMonitor);
        this.repaint();
    }

    private void repaint() {
        this.handler.setCurrentShape(null);
        this.handler.setCurrentState(EditState.NONE);
        ILayer selectedLayer = this.handler.getContext().getSelectedLayer();
        EditBlackboard editBlackboard = this.handler.getEditBlackboard(selectedLayer);
        editBlackboard.clear();
        this.handler.repaint();
    }

    private LineString getSplittingLineInMapCRS(EditToolHandler handler) throws SplitFeaturesCommandException {
        PrimitiveShape currentShape = handler.getCurrentShape();
        LineString lineInLayerCrs = (LineString)GeometryCreationUtil.createGeom(LineString.class, (PrimitiveShape)currentShape, (boolean)false);
        CoordinateReferenceSystem mapCrs = MapUtil.getCRS(handler.getContext().getMap());
        LineString splittingLine = this.reprojectSplitLine(lineInLayerCrs, mapCrs);
        return splittingLine;
    }

    private LineString reprojectSplitLine(LineString lineInLayerCrs, CoordinateReferenceSystem targetCrs) throws SplitFeaturesCommandException {
        try {
            CoordinateReferenceSystem splitLineCrs = (CoordinateReferenceSystem)lineInLayerCrs.getUserData();
            if (splitLineCrs == null) {
                ILayer selectedLayer = this.handler.getContext().getSelectedLayer();
                CoordinateReferenceSystem layerCrs = LayerUtil.getCrs(selectedLayer);
                assert (this.handler.getCurrentShape() != null);
                assert (layerCrs != null);
                splitLineCrs = layerCrs;
            }
            LineString splitlineInMapCRS = (LineString)GeoToolsUtils.reproject((Geometry)lineInLayerCrs, splitLineCrs, targetCrs);
            splitlineInMapCRS.setUserData((Object)targetCrs);
            return splitlineInMapCRS;
        }
        catch (Exception e) {
            e.printStackTrace();
            ProjectPlugin.log((String)"It does not possible transform the split line to the map crs", (Throwable)e);
            throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_cannot_transform_the_splitline_crs);
        }
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeaturesToSplit(LineString splittingLine) throws SplitFeaturesCommandException {
        try {
            Filter extraFilter = this.createSplittingLineFilter(splittingLine);
            FeatureCollection<SimpleFeatureType, SimpleFeature> selection = LayerUtil.getSelectedFeatures(this.selectedLayer, extraFilter);
            return selection;
        }
        catch (Exception e) {
            e.printStackTrace();
            ProjectPlugin.log((String)"The split tool can not retrieve the features to be split", (Throwable)e);
            throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_cannot_retrieve_features_to_be_split);
        }
    }

    private Filter createSplittingLineFilter(LineString splittingLine) throws SplitFeaturesCommandException {
        try {
            Object filter = this.selectedLayer.getFilter();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            CoordinateReferenceSystem layerCrs = LayerUtil.getCrs(this.selectedLayer);
            LineString splitLineGeom = this.reprojectSplitLine(splittingLine, layerCrs);
            SimpleFeatureType schema = this.selectedLayer.getSchema();
            String geomName = schema.getGeometryDescriptor().getLocalName();
            Intersects intersectsFilter = ff.intersects((Expression)ff.property(geomName), (Expression)ff.literal((Object)splitLineGeom));
            filter = Filter.EXCLUDE.equals(filter) ? intersectsFilter : ff.and(filter, (Filter)intersectsFilter);
            return filter;
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            ProjectPlugin.log((String)"The split command found an illegal filter", (Throwable)e);
            throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_fail);
        }
    }

    private List<UndoableMapCommand> buildCommandList(FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToSplit, LineString splitterInMapCrs) throws SplitFeaturesCommandException {
        ProjectPlugin.log((String)(String.valueOf(className) + " - Split original: " + splitterInMapCrs.toText()));
        EditCommandFactory cmdFac = EditCommandFactory.getInstance();
        FeatureIterator featureToSplitIterator = featuresToSplit.features();
        CoordinateReferenceSystem mapCRS = this.handler.getContext().getCRS();
        try {
            List<SimpleFeature> originalFeatureList = this.asList((FeatureIterator<SimpleFeature>)featureToSplitIterator);
            if (originalFeatureList.isEmpty()) {
                throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_did_not_apply_to_any_feature);
            }
            ProjectPlugin.log((String)(String.valueOf(className) + " - Split using CRS: " + mapCRS.toString()));
            SplitFeatureBuilder builder = SplitFeatureBuilder.newInstance(originalFeatureList, splitterInMapCrs, mapCRS);
            try {
                builder.buildSplit();
            }
            catch (CannotSplitException e) {
                throw new SplitFeaturesCommandException(e.getMessage());
            }
            LinkedList<UndoableMapCommand> undoableCommands = new LinkedList<UndoableMapCommand>();
            List<SimpleFeature> featuresThatSufferedSplit = builder.getFeaturesThatSufferedSplit();
            for (SimpleFeature feature : featuresThatSufferedSplit) {
                UndoableMapCommand command = cmdFac.createDeleteFeature(feature, this.selectedLayer);
                undoableCommands.add(command);
                ProjectPlugin.log((String)(String.valueOf(className) + " - Delete original feature: " + ((Geometry)feature.getDefaultGeometry()).toText()));
            }
            List<SimpleFeature> splitResult = builder.getSplitResult();
            for (SimpleFeature feature : splitResult) {
                UndoableMapCommand command = cmdFac.createAddFeatureCommand(feature, this.selectedLayer);
                undoableCommands.add(command);
                ProjectPlugin.log((String)(String.valueOf(className) + " - Split result: " + ((Geometry)feature.getDefaultGeometry()).toText()));
            }
            builder.buildNeighbours();
            List<SimpleFeature> modifiedNeighbour = builder.getNeighbourResult();
            for (SimpleFeature neighbor : modifiedNeighbour) {
                for (SimpleFeature original : originalFeatureList) {
                    if (!original.getID().equals(neighbor.getID())) continue;
                    ModifyGeometryFeatureCommand command = new ModifyGeometryFeatureCommand(original.getID(), (Geometry)neighbor.getDefaultGeometry(), (Geometry)original.getDefaultGeometry(), this.selectedLayer);
                    undoableCommands.add(command);
                    ProjectPlugin.log((String)(String.valueOf(className) + " - Neighbour result: " + ((Geometry)neighbor.getDefaultGeometry()).toText()));
                }
            }
            LinkedList<UndoableMapCommand> linkedList = undoableCommands;
            return linkedList;
        }
        catch (SplitFeatureBuilderFailException sfbe) {
            sfbe.printStackTrace();
            ProjectPlugin.log((String)"This split transaction is not possible.", (Throwable)sfbe);
            throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_split_transaction_failed);
        }
        finally {
            if (featureToSplitIterator != null) {
                featureToSplitIterator.close();
            }
        }
    }

    private List<SimpleFeature> asList(FeatureIterator<SimpleFeature> featureIterator) throws SplitFeaturesCommandException {
        ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry defaultGeometry = (Geometry)feature.getDefaultGeometry();
            ProjectPlugin.log((String)(String.valueOf(className) + "- Original feature: " + defaultGeometry.toText()));
            if (!defaultGeometry.isValid()) {
                ProjectPlugin.log((String)(String.valueOf(className) + "- Original feature has invalid geometry: " + defaultGeometry.toText()));
                throw new SplitFeaturesCommandException(Messages.SplitFeaturesCommand_the_feature_has_invalid_geometry);
            }
            featureList.add(feature);
        }
        return featureList;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.composite != null) {
            this.composite.rollback(monitor);
        }
    }
}

