/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.split;

import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import java.io.IOException;
import java.util.HashSet;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

final class ModifyGeometryFeatureCommand
extends AbstractEditCommand
implements UndoableMapCommand {
    private final String fid;
    private final Geometry newGeometry;
    private final Geometry oldGeometry;
    private final ILayer layer;

    public ModifyGeometryFeatureCommand(String fid, Geometry newGeometry, Geometry oldGeometry, ILayer layer) {
        this.fid = fid;
        this.newGeometry = newGeometry;
        this.oldGeometry = oldGeometry;
        this.layer = layer;
    }

    public String getName() {
        return ModifyGeometryFeatureCommand.class.getName();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.execute(monitor);
    }

    public boolean execute(IProgressMonitor monitor) throws Exception {
        this.modifyFeatureInStore(this.fid, this.newGeometry, this.layer);
        ProjectPlugin.log((String)(String.valueOf(ModifyGeometryFeatureCommand.class.getName()) + " - Feature Modified: fid - " + this.fid + " - " + this.newGeometry.toText()));
        return true;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.modifyFeatureInStore(this.fid, this.oldGeometry, this.layer);
    }

    private void modifyFeatureInStore(String fidToUpdate, Geometry geometry, ILayer layer) throws IOException {
        FeatureStore store = (FeatureStore)layer.getResource(FeatureStore.class, (IProgressMonitor)new NullProgressMonitor());
        GeometryDescriptor geomAttr = ((SimpleFeatureType)store.getSchema()).getGeometryDescriptor();
        Class expectedClass = geomAttr.getType().getBinding();
        Geometry adaptedGeom = GeometryUtil.adapt(this.newGeometry, (Class<? extends Geometry>)expectedClass);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        FeatureId fid = ff.featureId(fidToUpdate);
        HashSet<FeatureId> ids = new HashSet<FeatureId>(1);
        ids.add(fid);
        Id filter = ff.id(ids);
        store.modifyFeatures((AttributeDescriptor)geomAttr, (Object)adaptedGeom, (Filter)filter);
    }
}

