/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.view;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.parallel.internal.InfoMessage;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.PrecisionToolsMode;
import eu.udig.tools.parallel.view.AbstractParametersComposite;
import java.util.Observable;
import javax.measure.unit.Unit;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ParallelParametersComposite
extends AbstractParametersComposite {
    private ParallelContext parallelContext = null;
    private static final int GRID_DATA_2a_WIDTH_HINT = 200;
    private static final int GRID_DATA_3a_WIDTH_HINT = 185;
    private static final int GRID_DATA_1a_WIDTH_HINT = 90;
    private static final int GRID_DATA_4a_WIDTH_HINT = 115;
    private Button buttonSwitchSide = null;
    private Text textDistance = null;
    private CLabel labelDistance = null;
    private CLabel labelUnit = null;
    private String distance = "";
    private Unit<?> mapUnits = null;
    private String unitName = "";
    private Button applyButton;

    public ParallelParametersComposite(Composite parent, int style) {
        super(parent, style);
        this.createParametersContent();
        this.createContent();
    }

    @Override
    protected void setCustomToolContext() {
        this.parallelContext = (ParallelContext)this.toolContext;
    }

    private void createParametersContent() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = 90;
        gridData.verticalAlignment = 4;
        this.labelDistance = new CLabel(this.compositeOperations, 0);
        this.labelDistance.setLayoutData((Object)gridData);
        this.labelDistance.setText(String.valueOf(Messages.PrecisionParallel_distance) + ":");
        this.labelDistance.setToolTipText(String.valueOf(Messages.PrecisionParallel_distance) + ":" + this.distance);
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.widthHint = 200;
        gridData1.verticalAlignment = 4;
        this.textDistance = new Text(this.compositeOperations, 2048);
        this.textDistance.setLayoutData((Object)gridData1);
        this.textDistance.setText(this.distance);
        this.textDistance.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ParallelParametersComposite.this.applyChanges();
                }
            }
        });
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = false;
        gridData3.grabExcessVerticalSpace = false;
        gridData3.widthHint = 185;
        gridData3.verticalAlignment = 4;
        this.labelUnit = new CLabel(this.compositeOperations, 0);
        this.labelUnit.setLayoutData((Object)gridData3);
        this.labelUnit.setText(this.unitName);
        CLabel emptyLabel = new CLabel(this.compositeOperations, 0);
        emptyLabel.setLayoutData((Object)gridData3);
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = false;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.widthHint = 115;
        gridData4.verticalAlignment = 4;
        this.buttonSwitchSide = new Button(this.compositeOperations, 0);
        this.buttonSwitchSide.setLayoutData((Object)gridData4);
        this.buttonSwitchSide.setText(Messages.PrecisionParallel_buttonSwitchText);
        this.buttonSwitchSide.setToolTipText(Messages.PrecisionParallel_buttonSwitchToolTip);
        this.buttonSwitchSide.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ParallelParametersComposite.this.parallelContext.getReferenceFeature() != null) {
                    ParallelParametersComposite.this.parallelContext.changePosition();
                }
            }
        });
        this.buttonSwitchSide.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if ((e.keyCode == 13 || e.keyCode == 0x1000050) && ParallelParametersComposite.this.parallelContext.getReferenceFeature() != null) {
                    ParallelParametersComposite.this.parallelContext.changePosition();
                }
            }
        });
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        gridData2.grabExcessHorizontalSpace = false;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.widthHint = 90;
        gridData2.verticalAlignment = 4;
        this.applyButton = new Button(this.compositeOperations, 0);
        this.applyButton.setLayoutData((Object)gridData2);
        this.applyButton.setText(Messages.PrecisionTool_apply_text);
        this.applyButton.setToolTipText(Messages.PrecisionTool_apply_tooltip_text);
        this.applyButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ParallelParametersComposite.this.applyChanges();
            }
        });
        this.applyButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ParallelParametersComposite.this.applyChanges();
                }
            }
        });
    }

    @Override
    public void discardChanges() {
        if (this.parallelContext == null) {
            return;
        }
        if (this.parallelContext.getReferenceFeature() != null) {
            this.parallelContext.initContext();
        }
    }

    @Override
    protected void applyChanges() {
        Double d;
        if (this.parallelContext.getReferenceFeature() == null) {
            this.displayMessage(InfoMessage.Type.ERROR);
            return;
        }
        this.distance = this.textDistance.getText();
        try {
            d = Double.valueOf(this.distance);
        }
        catch (NumberFormatException numberFormatException) {
            InfoMessage message = new InfoMessage(Messages.PrecisionParallel_error_distance_NaN, InfoMessage.Type.ERROR);
            this.messageImage.setImage(message.getImage());
            this.messageText.setText(message.getText());
            this.parallelContext.setMode(PrecisionToolsMode.ERROR);
            this.parallelContext.update("UPDATE_VIEW");
            return;
        }
        if (d == 0.0) {
            InfoMessage message = new InfoMessage(Messages.PrecisionParallel_error_distance_zero, InfoMessage.Type.ERROR);
            this.messageImage.setImage(message.getImage());
            this.messageText.setText(message.getText());
            this.parallelContext.setMode(PrecisionToolsMode.ERROR);
            this.parallelContext.update("UPDATE_VIEW");
            return;
        }
        try {
            this.parallelContext.calculateParallelCurve(d);
            this.parallelContext.update("UPDATE_LAYER");
        }
        catch (IllegalArgumentException iae) {
            this.parallelContext.setMode(PrecisionToolsMode.ERROR);
            this.displayMessage(iae.getMessage(), InfoMessage.Type.ERROR);
        }
    }

    @Override
    protected void clearData() {
        if (this.parallelContext != null) {
            this.parallelContext.initContext();
            this.referenceLine = "";
            this.referenceLineToolTip = "";
            this.distance = "";
            this.unitName = "";
            this.populate();
        }
    }

    @Override
    protected void populate() {
        Display.findDisplay((Thread)this.fatherThread).asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ParallelParametersComposite.this.labelReferenceLine.isDisposed()) {
                    ParallelParametersComposite.this.labelReferenceLine.setText(String.valueOf(Messages.PrecisionTool_reference_line) + ": " + ParallelParametersComposite.this.referenceLine);
                    ParallelParametersComposite.this.labelReferenceLine.setToolTipText(String.valueOf(Messages.PrecisionTool_reference_line) + ": " + ParallelParametersComposite.this.referenceLineToolTip);
                }
                if (!ParallelParametersComposite.this.textDistance.isDisposed()) {
                    ParallelParametersComposite.this.textDistance.setText(ParallelParametersComposite.this.distance);
                }
                if (!ParallelParametersComposite.this.labelUnit.isDisposed()) {
                    ParallelParametersComposite.this.labelUnit.setText(ParallelParametersComposite.this.unitName);
                    ParallelParametersComposite.this.labelUnit.setToolTipText(ParallelParametersComposite.this.getUnitName(ParallelParametersComposite.this.mapUnits));
                }
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("UPDATE_VIEW".equals(arg)) {
            return;
        }
        if (this.parallelContext.mode == PrecisionToolsMode.BUSY || this.parallelContext.mode == PrecisionToolsMode.EDITING) {
            return;
        }
        if (this.parallelContext.getReferenceFeature() != null) {
            this.referenceLine = this.parallelContext.getFeatureText();
            this.referenceLineToolTip = this.parallelContext.getFeatureToolTip();
        } else {
            this.referenceLine = "";
            this.referenceLineToolTip = "";
        }
        this.distance = this.parallelContext.getInitialCoordinate() != null ? String.valueOf(this.parallelContext.getDistance()) : "";
        if (this.parallelContext.getUnits() != null) {
            this.mapUnits = this.parallelContext.getUnits();
            this.unitName = String.valueOf(this.mapUnits);
        } else {
            this.unitName = "";
        }
        this.populate();
        if ("UPDATE_ERROR".equals(arg)) {
            this.displayMessage(this.parallelContext.getErrorMessage(), InfoMessage.Type.ERROR);
        } else {
            this.displayMessage(InfoMessage.Type.INFORMATION);
        }
    }

    @Override
    protected void displayMessage(InfoMessage.Type type) {
        if (this.parallelContext.getReferenceFeature() == null) {
            this.displayMessage(Messages.PrecisionParallel_InitialMessage, type);
        } else if (this.parallelContext.getInitialCoordinate() == null) {
            this.displayMessage(Messages.PrecisionParallel_Set_Distance, type);
        } else {
            this.displayMessage(Messages.PrecisionParallel_Set_Another_Distance, type);
        }
    }

    protected void displayMessage(String text, InfoMessage.Type type) {
        final InfoMessage message = new InfoMessage();
        message.setText(text);
        message.setType(type);
        Display.findDisplay((Thread)this.fatherThread).asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ParallelParametersComposite.this.messageText.isDisposed()) {
                    ParallelParametersComposite.this.messageText.setText(message.getText());
                }
                if (!ParallelParametersComposite.this.messageImage.isDisposed()) {
                    ParallelParametersComposite.this.messageImage.setImage(message.getImage());
                }
            }
        });
    }
}

