/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal.command;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.tools.feature.util.GeoToolsUtils;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.MapUtil;
import eu.udig.tools.parallel.internal.FeatureHighLight;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.PrecisionToolsMode;
import eu.udig.tools.parallel.internal.PrecisionToolsUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.measure.unit.Unit;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.internal.commands.draw.DrawFeatureCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SetReferenceFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    private ParallelContext parallelContext = null;
    private EditToolHandler handler = null;
    private MapMouseEvent event = null;

    public SetReferenceFeatureCommand(ParallelContext paralleContext, EditToolHandler handler, MapMouseEvent event) {
        this.parallelContext = paralleContext;
        this.handler = handler;
        this.event = event;
    }

    public String getName() {
        return Messages.PrecisionParallelReferenceFeature;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        SimpleFeature feature = PrecisionToolsUtil.getFeatureUnderCursor(this.handler, this.event);
        assert (feature != null);
        IMap map = this.handler.getContext().getMap();
        assert (map != null);
        CoordinateReferenceSystem crs = MapUtil.getCRS(map);
        Unit<?> mapUnits = GeoToolsUtils.getDefaultCRSUnit(crs);
        this.parallelContext.setUnits(mapUnits);
        EditBlackboard bb = this.handler.getEditBlackboard(this.handler.getEditLayer());
        Point currPoint = Point.valueOf((int)this.event.x, (int)this.event.y);
        Coordinate coor = bb.toCoord(currPoint);
        if (this.parallelContext.getReferenceFeature() != null) {
            this.parallelContext.setMode(PrecisionToolsMode.BUSY);
            this.parallelContext.setReferenceFeature(feature, coor);
            this.parallelContext.setInitialCoordinate(null);
        } else {
            this.parallelContext.setReferenceFeature(feature, coor);
        }
        this.parallelContext.setMode(PrecisionToolsMode.WAITING);
        ArrayList<DrawFeatureCommand> commands = new ArrayList<DrawFeatureCommand>();
        DrawFeatureCommand drawCmd = new DrawFeatureCommand(feature);
        commands.add(drawCmd);
        FeatureHighLight animation = new FeatureHighLight(commands, new Rectangle());
        AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
    }
}

