/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal.behaviour;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.command.SetInitialPointCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;

public class SetInitialPointEventBehaviour
implements EventBehaviour {
    private ParallelContext parallelContext = null;

    public SetInitialPointEventBehaviour(ParallelContext parallelContext) {
        this.parallelContext = parallelContext;
    }

    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean releasedEvent;
        boolean legalState = handler.getCurrentState() == EditState.NONE || handler.getCurrentState() == EditState.MODIFYING;
        boolean legalButton = e.button == 8;
        boolean bl = releasedEvent = eventType == EventType.RELEASED;
        if (!(legalState && legalButton && releasedEvent)) {
            return false;
        }
        return this.parallelContext.getReferenceFeature() != null;
    }

    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Behaviour is not valid for the current state");
        }
        EditBlackboard bb = handler.getEditBlackboard(handler.getEditLayer());
        Point currPoint = Point.valueOf((int)e.x, (int)e.y);
        Coordinate coor = bb.toCoord(currPoint);
        SetInitialPointCommand setInitialPointCommand = new SetInitialPointCommand(this.parallelContext, coor);
        return setInitialPointCommand;
    }

    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log((String)"", (Throwable)error);
    }
}

