/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import java.util.List;

final class QuadrantAnalyzer {
    private int index;
    private int size;
    private int intersectionLastPosition;
    private Coordinate imaginaryCoord;
    private Coordinate realIntersectionCoord;
    private final List<Coordinate> inputList;
    private final List<Coordinate> sourceList;
    private boolean valids1p1;
    private boolean valids1p2;
    private boolean valids2p1;
    private boolean valids2p2;

    public QuadrantAnalyzer(List<Coordinate> inputList, List<Coordinate> sourceList, int index, int intersectionLastPosition) {
        assert (inputList != null) : "cannot be null";
        assert (sourceList != null) : "cannot be null";
        this.index = index;
        this.inputList = inputList;
        this.sourceList = sourceList;
        this.intersectionLastPosition = intersectionLastPosition;
    }

    public QuadrantAnalyzer(List<Coordinate> inputList, List<Coordinate> sourceList, int index, int intersectionLastPosition, int size, Coordinate realIntersectionCoord, Coordinate imaginaryCoord) {
        this(inputList, sourceList, index, intersectionLastPosition);
        this.size = size;
        this.realIntersectionCoord = realIntersectionCoord;
        this.imaginaryCoord = imaginaryCoord;
    }

    public void analyzeNonClosedLines() {
        Coordinate s1p1 = this.inputList.get(this.index);
        Coordinate s1p2 = this.inputList.get(this.index + 1);
        Coordinate s2p1 = this.inputList.get(this.intersectionLastPosition);
        Coordinate s2p2 = this.inputList.get(this.intersectionLastPosition + 1);
        Coordinate s1p1src = this.sourceList.get(this.index);
        Coordinate s1p2src = this.sourceList.get(this.index + 1);
        Coordinate s2p1src = this.sourceList.get(this.intersectionLastPosition);
        Coordinate s2p2src = this.sourceList.get(this.intersectionLastPosition + 1);
        this.analyze(s1p1, s1p2, s2p1, s2p2, s1p1src, s1p2src, s2p1src, s2p2src);
    }

    public boolean isValid() {
        return this.valids1p1 && this.valids1p2 && this.valids2p1 && this.valids2p2;
    }

    public void analyzeClosedLines() {
        int secondIndex = this.intersectionLastPosition == 0 ? this.size - 1 : this.intersectionLastPosition - 1;
        Coordinate s1p1 = this.inputList.get(this.index);
        Coordinate s1p2 = this.inputList.get(this.index + 1);
        Coordinate s2p1 = this.inputList.get(this.intersectionLastPosition);
        Coordinate s2p2 = this.inputList.get(secondIndex);
        Coordinate s1p1src = this.sourceList.get(this.index);
        Coordinate s1p2src = this.sourceList.get(this.index + 1);
        Coordinate s2p1src = this.sourceList.get(this.intersectionLastPosition);
        Coordinate s2p2src = this.sourceList.get(secondIndex);
        this.analyzeUsingIntersection(s1p1, s1p2, s2p1, s2p2, s1p1src, s1p2src, s2p1src, s2p2src);
    }

    private void analyzeUsingIntersection(Coordinate s1p1, Coordinate s1p2, Coordinate s2p1, Coordinate s2p2, Coordinate s1p1src, Coordinate s1p2src, Coordinate s2p1src, Coordinate s2p2src) {
        int qs1p1s2p1src;
        int qs1p1s2p1 = Quadrant.quadrant((Coordinate)s1p1, (Coordinate)this.realIntersectionCoord);
        this.valids1p1 = qs1p1s2p1 == (qs1p1s2p1src = Quadrant.quadrant((Coordinate)s1p1src, (Coordinate)this.imaginaryCoord));
        int qs1p2s2p1 = Quadrant.quadrant((Coordinate)s1p2, (Coordinate)this.realIntersectionCoord);
        int qs1p2s2p1src = Quadrant.quadrant((Coordinate)s1p2src, (Coordinate)this.imaginaryCoord);
        this.valids1p2 = qs1p2s2p1 == qs1p2s2p1src;
        int qs2p1s1p1 = Quadrant.quadrant((Coordinate)s2p1, (Coordinate)this.realIntersectionCoord);
        int qs2p1s1p1src = Quadrant.quadrant((Coordinate)s2p1src, (Coordinate)this.imaginaryCoord);
        this.valids2p1 = qs2p1s1p1 == qs2p1s1p1src;
        int qs2p2s1p1 = Quadrant.quadrant((Coordinate)s2p2, (Coordinate)this.realIntersectionCoord);
        int qs2p2s1p1src = Quadrant.quadrant((Coordinate)s2p2src, (Coordinate)this.imaginaryCoord);
        this.valids2p2 = qs2p2s1p1 == qs2p2s1p1src;
    }

    private void analyze(Coordinate s1p1, Coordinate s1p2, Coordinate s2p1, Coordinate s2p2, Coordinate s1p1src, Coordinate s1p2src, Coordinate s2p1src, Coordinate s2p2src) {
        int qs1p1s2p1 = Quadrant.quadrant((Coordinate)s1p1, (Coordinate)s2p1);
        int qs1p1s2p1src = Quadrant.quadrant((Coordinate)s1p1src, (Coordinate)s2p1src);
        int qs1p1s2p2 = Quadrant.quadrant((Coordinate)s1p1, (Coordinate)s2p2);
        int qs1p1s2p2src = Quadrant.quadrant((Coordinate)s1p1src, (Coordinate)s2p2src);
        this.valids1p1 = qs1p1s2p1 == qs1p1s2p1src && qs1p1s2p2 == qs1p1s2p2src;
        int qs1p2s2p1 = Quadrant.quadrant((Coordinate)s1p2, (Coordinate)s2p1);
        int qs1p2s2p1src = Quadrant.quadrant((Coordinate)s1p2src, (Coordinate)s2p1src);
        int qs1p2s2p2 = Quadrant.quadrant((Coordinate)s1p2, (Coordinate)s2p2);
        int qs1p2s2p2src = Quadrant.quadrant((Coordinate)s1p2src, (Coordinate)s2p2src);
        this.valids1p2 = qs1p2s2p1 == qs1p2s2p1src && qs1p2s2p2 == qs1p2s2p2src;
        int qs2p1s1p1 = Quadrant.quadrant((Coordinate)s2p1, (Coordinate)s1p1);
        int qs2p1s1p1src = Quadrant.quadrant((Coordinate)s2p1src, (Coordinate)s1p1src);
        int qs2p1s1p2 = Quadrant.quadrant((Coordinate)s2p1, (Coordinate)s1p2);
        int qs2p1s1p2src = Quadrant.quadrant((Coordinate)s2p1src, (Coordinate)s1p2src);
        this.valids2p1 = qs2p1s1p1 == qs2p1s1p1src && qs2p1s1p2 == qs2p1s1p2src;
        int qs2p2s1p1 = Quadrant.quadrant((Coordinate)s2p2, (Coordinate)s1p1);
        int qs2p2s1p1src = Quadrant.quadrant((Coordinate)s2p2src, (Coordinate)s1p1src);
        int qs2p2s1p2 = Quadrant.quadrant((Coordinate)s2p2, (Coordinate)s1p2);
        int qs2p2s1p2src = Quadrant.quadrant((Coordinate)s2p2src, (Coordinate)s1p2src);
        this.valids2p2 = qs2p2s1p1 == qs2p2s1p1src && qs2p2s1p2 == qs2p2s1p2src;
    }

    public AnalyzerPosition getResultIndex() {
        if (!this.valids1p1) {
            return AnalyzerPosition.SEGMENT_1_POINT_1;
        }
        if (!this.valids1p2) {
            return AnalyzerPosition.SEGMENT_1_POINT_2;
        }
        if (!this.valids2p1) {
            return AnalyzerPosition.SEGMENT_2_POINT_1;
        }
        if (!this.valids2p2) {
            return AnalyzerPosition.SEGMENT_2_POINT_2;
        }
        return AnalyzerPosition.RESULTANT_NONE;
    }

    public static enum AnalyzerPosition {
        SEGMENT_1_POINT_1,
        SEGMENT_1_POINT_2,
        SEGMENT_2_POINT_1,
        SEGMENT_2_POINT_2,
        RESULTANT_NONE;

    }
}

