/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import java.io.IOException;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class PrecisionToolsUtil {
    private PrecisionToolsUtil() {
    }

    public static boolean isFeatureUnderCursor(EditToolHandler handler, MapMouseEvent e) {
        block13: {
            FeatureIterator iterator;
            FeatureCollection collection;
            block11: {
                block12: {
                    int snapRadious = 5;
                    if (PreferenceUtil.instance().getSnapBehaviour() != SnapBehaviour.OFF) {
                        snapRadious = PreferenceUtil.instance().getSnappingRadius() + PreferenceUtil.instance().getSnappingRadius() / 2;
                    }
                    ReferencedEnvelope bbox = handler.getContext().getBoundingBox(e.getPoint(), snapRadious);
                    try {
                        bbox = bbox.transform(handler.getEditLayer().getCRS(), true);
                    }
                    catch (TransformException te) {
                        te.printStackTrace();
                    }
                    catch (FactoryException fe) {
                        fe.printStackTrace();
                    }
                    collection = null;
                    iterator = null;
                    try {
                        Class<BBOX> filterType = BBOX.class;
                        FeatureStore store = (FeatureStore)handler.getEditLayer().getResource(FeatureStore.class, null);
                        Filter createBBoxFilter = PrecisionToolsUtil.createBBoxFilter(bbox, handler.getEditLayer(), filterType);
                        collection = store.getFeatures(createBBoxFilter);
                        iterator = collection.features();
                        if (!iterator.hasNext()) break block11;
                        if (iterator == null) break block12;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        break block13;
                    }
                    finally {
                        if (iterator != null) {
                            collection.close(iterator);
                        }
                    }
                    collection.close(iterator);
                }
                return true;
            }
            if (iterator != null) {
                collection.close(iterator);
            }
        }
        return false;
    }

    private static Filter createBBoxFilter(ReferencedEnvelope boundingBox, ILayer layer, Class<? extends Filter> filterType) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        if (!layer.hasResource(FeatureSource.class)) {
            return Filter.EXCLUDE;
        }
        try {
            SimpleFeatureType schema = layer.getSchema();
            Name geom = PrecisionToolsUtil.getGeometryAttDescriptor(schema).getName();
            BBOX bboxFilter = factory.bbox((Expression)factory.property(geom), (BoundingBox)boundingBox);
            return bboxFilter;
        }
        catch (Exception e) {
            ProjectPlugin.getPlugin().log((Object)e);
            return Filter.EXCLUDE;
        }
    }

    private static GeometryDescriptor getGeometryAttDescriptor(SimpleFeatureType schema) {
        return schema.getGeometryDescriptor();
    }

    public static SimpleFeature getFeatureUnderCursor(EditToolHandler handler, MapMouseEvent e) {
        block13: {
            FeatureIterator iterator;
            FeatureCollection collection;
            block11: {
                SimpleFeature simpleFeature;
                block12: {
                    int snapRadious = 5;
                    if (PreferenceUtil.instance().getSnapBehaviour() != SnapBehaviour.OFF) {
                        snapRadious = PreferenceUtil.instance().getSnappingRadius() + PreferenceUtil.instance().getSnappingRadius() / 2;
                    }
                    ReferencedEnvelope bbox = handler.getContext().getBoundingBox(e.getPoint(), snapRadious);
                    try {
                        bbox = bbox.transform(handler.getEditLayer().getCRS(), true);
                    }
                    catch (TransformException te) {
                        te.printStackTrace();
                    }
                    catch (FactoryException fe) {
                        fe.printStackTrace();
                    }
                    collection = null;
                    iterator = null;
                    try {
                        Class<BBOX> filterType = BBOX.class;
                        FeatureStore store = (FeatureStore)handler.getEditLayer().getResource(FeatureStore.class, null);
                        Filter createBBoxFilter = PrecisionToolsUtil.createBBoxFilter(bbox, handler.getEditLayer(), filterType);
                        collection = store.getFeatures(createBBoxFilter);
                        iterator = collection.features();
                        if (!iterator.hasNext()) break block11;
                        simpleFeature = (SimpleFeature)iterator.next();
                        if (iterator == null) break block12;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        break block13;
                    }
                    finally {
                        if (iterator != null) {
                            collection.close(iterator);
                        }
                    }
                    collection.close(iterator);
                }
                return simpleFeature;
            }
            if (iterator != null) {
                collection.close(iterator);
            }
        }
        return null;
    }
}

