/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LineStringExtracter;
import eu.udig.tools.parallel.internal.OffsetBuilder;
import eu.udig.tools.parallel.internal.PrecisionToolsContext;
import eu.udig.tools.parallel.internal.PrecisionToolsMode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class ParallelContext
extends PrecisionToolsContext {
    private EditGeom referenceLine = null;
    private SimpleFeature referenceFeature = null;
    private Coordinate[] inputCoordinates = null;
    private List<Geometry> outputCoordinates = null;
    private OffsetBuilder.OffsetPosition offsetPosition = null;
    private static final double DEPRECIATE_VALUE = 0.006;
    private int startPosition = 1;
    private double distance = 0.0;
    private String errorMessage = "";

    @Override
    public synchronized void initContext() {
        this.initialCoordinate = null;
        this.referenceLine = null;
        this.referenceFeature = null;
        this.reverse = false;
        this.distanceCoorX = 0.0;
        this.distanceCoorY = 0.0;
        this.referenceCoor = null;
        this.length = null;
        this.units = null;
        this.previousMode = PrecisionToolsMode.WAITING;
        this.mode = PrecisionToolsMode.WAITING;
        this.update("UPDATE_LAYER");
    }

    public EditGeom getReferenceLine() {
        return this.referenceLine;
    }

    public synchronized SimpleFeature getReferenceFeature() {
        return this.referenceFeature;
    }

    public synchronized void setReferenceFeature(SimpleFeature feature, Coordinate clickCoordinate) {
        assert (feature != null);
        this.referenceFeature = feature;
        this.inputCoordinates = this.getLineCoordinates(clickCoordinate);
        this.inputCoordinates = CoordinateArrays.removeRepeatedPoints((Coordinate[])this.inputCoordinates);
        if (this.inputCoordinates.length > 2) {
            this.removeVertexOfTheSameLine(this.inputCoordinates);
        }
        this.update("UPDATE_LAYER");
    }

    private void removeVertexOfTheSameLine(Coordinate[] inputCoordinates) {
        ArrayList<Coordinate> removedCoordinates = new ArrayList<Coordinate>();
        ArrayList<Coordinate> initialCoordinates = new ArrayList<Coordinate>();
        int length = inputCoordinates.length;
        int i = 0;
        while (i < length - 2) {
            initialCoordinates.add(inputCoordinates[i]);
            if (this.sameTangent(inputCoordinates, i)) {
                removedCoordinates.add(inputCoordinates[i + 1]);
            }
            ++i;
        }
        if (length > 2) {
            initialCoordinates.add(inputCoordinates[length - 2]);
            initialCoordinates.add(inputCoordinates[length - 1]);
        }
        initialCoordinates.removeAll(removedCoordinates);
        this.inputCoordinates = initialCoordinates.toArray(new Coordinate[initialCoordinates.size()]);
    }

    private boolean sameTangent(Coordinate[] inputCoordinates, int i) {
        Coordinate[] newCoor = new Coordinate[]{inputCoordinates[i], inputCoordinates[i + 1]};
        double dx1 = newCoor[1].x - newCoor[0].x;
        double dy1 = newCoor[1].y - newCoor[0].y;
        double tangent = dx1 / dy1;
        newCoor = new Coordinate[]{inputCoordinates[i + 1], inputCoordinates[i + 2]};
        double dx2 = newCoor[1].x - newCoor[0].x;
        double dy2 = newCoor[1].y - newCoor[0].y;
        double tangentToCompare = dx2 / dy2;
        double diff = Math.abs(tangent - tangentToCompare);
        return diff < 0.006;
    }

    @Override
    public synchronized void setInitialCoordinate(Coordinate coordinate) {
        this.initialCoordinate = coordinate;
        try {
            this.calculateParallelCurve();
            this.update("UPDATE_LAYER");
        }
        catch (IllegalArgumentException iae) {
            this.errorMessage = iae.getMessage();
            this.setMode(PrecisionToolsMode.ERROR);
            this.update("UPDATE_ERROR");
        }
    }

    public synchronized void changePosition() {
        if (OffsetBuilder.OffsetPosition.POSITION_UNDER.equals((Object)this.offsetPosition)) {
            this.offsetPosition = OffsetBuilder.OffsetPosition.POSITION_UPPER;
        } else if (OffsetBuilder.OffsetPosition.POSITION_UPPER.equals((Object)this.offsetPosition)) {
            this.offsetPosition = OffsetBuilder.OffsetPosition.POSITION_UNDER;
        }
        try {
            this.calculateParallelCurve(this.offsetPosition, this.startPosition);
            this.update("UPDATE_LAYER");
        }
        catch (IllegalArgumentException iae) {
            this.errorMessage = iae.getMessage();
            this.setMode(PrecisionToolsMode.ERROR);
            this.update("UPDATE_ERROR");
        }
    }

    private void calculateParallelCurve(OffsetBuilder.OffsetPosition offsetPosition2, int startPosition2) throws IllegalArgumentException {
        assert (this.referenceFeature != null);
        assert (this.inputCoordinates.length > 1) : "At least 2 coordinate must be";
        OffsetBuilder builder = new OffsetBuilder(offsetPosition2, startPosition2, 0.006);
        this.outputCoordinates = builder.getLineCurve(this.inputCoordinates, this.distance, ((Geometry)this.referenceFeature.getDefaultGeometry()).getFactory());
    }

    private void calculateParallelCurve() throws IllegalArgumentException {
        assert (this.referenceFeature != null);
        assert (this.inputCoordinates.length > 1) : "At least 2 coordinate must be";
        this.distance = this.calculateDistanceAndCurrentPostion();
        OffsetBuilder builder = new OffsetBuilder(this.offsetPosition, this.startPosition, 0.006);
        this.outputCoordinates = builder.getLineCurve(this.inputCoordinates, this.distance, ((Geometry)this.referenceFeature.getDefaultGeometry()).getFactory());
    }

    public void calculateParallelCurve(Double distance) throws IllegalArgumentException {
        assert (this.referenceFeature != null);
        assert (this.inputCoordinates.length > 1) : "At least 2 coordinate must be";
        this.distance = distance;
        OffsetBuilder builder = new OffsetBuilder(this.offsetPosition, this.startPosition, 0.006);
        this.outputCoordinates = builder.getLineCurve(this.inputCoordinates, this.distance, ((Geometry)this.referenceFeature.getDefaultGeometry()).getFactory());
    }

    private double calculateDistanceAndCurrentPostion() {
        LineSegment seg = new LineSegment();
        LineSegment closestSeg = new LineSegment();
        double closestDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < this.inputCoordinates.length - 1) {
            seg.setCoordinates(this.inputCoordinates[i], this.inputCoordinates[i + 1]);
            double distance = CGAlgorithms.distancePointLine((Coordinate)this.initialCoordinate, (Coordinate)this.inputCoordinates[i], (Coordinate)this.inputCoordinates[i + 1]);
            if (distance < closestDistance) {
                closestDistance = distance;
                closestSeg = new LineSegment(this.inputCoordinates[i], this.inputCoordinates[i + 1]);
            }
            ++i;
        }
        this.startPosition = 1;
        int segmentOrientation = CGAlgorithms.computeOrientation((Coordinate)closestSeg.p0, (Coordinate)closestSeg.p1, (Coordinate)this.initialCoordinate);
        this.offsetPosition = segmentOrientation == -1 ? OffsetBuilder.OffsetPosition.POSITION_UNDER : OffsetBuilder.OffsetPosition.POSITION_UPPER;
        boolean outsideTurn = true;
        int length = this.inputCoordinates.length;
        if (length > 2) {
            if (segmentOrientation == 1) {
                int refLineOrientation = CGAlgorithms.computeOrientation((Coordinate)this.inputCoordinates[0], (Coordinate)this.inputCoordinates[1], (Coordinate)this.inputCoordinates[2]);
                outsideTurn = refLineOrientation == -1;
                this.offsetPosition = outsideTurn ? OffsetBuilder.OffsetPosition.POSITION_UPPER : OffsetBuilder.OffsetPosition.POSITION_UNDER;
                this.startPosition = outsideTurn ? 1 : 2;
            } else {
                int refLineOrientation = CGAlgorithms.computeOrientation((Coordinate)this.inputCoordinates[length - 1], (Coordinate)this.inputCoordinates[length - 2], (Coordinate)this.inputCoordinates[length - 3]);
                outsideTurn = refLineOrientation == -1;
                this.offsetPosition = outsideTurn ? OffsetBuilder.OffsetPosition.POSITION_UPPER : OffsetBuilder.OffsetPosition.POSITION_UNDER;
                this.startPosition = outsideTurn ? 2 : 1;
            }
        }
        return closestDistance;
    }

    public List<Geometry> getOutputCoordinates() {
        return this.outputCoordinates;
    }

    private Coordinate[] getLineCoordinates(Coordinate clickCoordinate) {
        Geometry geom = (Geometry)this.referenceFeature.getDefaultGeometry();
        if (geom.getNumGeometries() > 1) {
            geom = this.getGeometry(geom, clickCoordinate);
        }
        return geom.getCoordinates();
    }

    private Geometry getGeometry(Geometry multiGeom, Coordinate clickCoordinate) {
        List linesList = LineStringExtracter.getLines((Geometry)multiGeom);
        LineString geom = null;
        Geometry bboxGeometry = null;
        int snapRadious = 5;
        Point point = this.handler.getContext().worldToPixel(clickCoordinate);
        if (!SnapBehaviour.OFF.equals((Object)PreferenceUtil.instance().getSnapBehaviour())) {
            snapRadious = PreferenceUtil.instance().getSnappingRadius() + PreferenceUtil.instance().getSnappingRadius() / 2;
        }
        ReferencedEnvelope bbox = this.handler.getContext().getBoundingBox(point, snapRadious);
        for (Object obj : linesList) {
            LineString line = (LineString)obj;
            GeometryFactory gfac = line.getFactory();
            bboxGeometry = gfac.toGeometry((Envelope)bbox);
            if (!bboxGeometry.intersects((Geometry)line)) continue;
            geom = line;
        }
        assert (geom != null);
        return geom;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getFeatureText() {
        StringBuffer text = new StringBuffer();
        text.append(this.referenceFeature.getID());
        return text.toString();
    }

    public String getFeatureToolTip() {
        StringBuffer text = new StringBuffer();
        text.append(this.referenceFeature.getID());
        text.append(" ");
        text.append(((Geometry)this.referenceFeature.getDefaultGeometry()).toText());
        return text.toString();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

