/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import eu.udig.tools.parallel.internal.AlgorithmUtils;
import eu.udig.tools.parallel.internal.DataSegmentIntersection;
import eu.udig.tools.parallel.internal.OffsetOrientationAnalyzer;
import eu.udig.tools.parallel.internal.OffsetVertexList;
import eu.udig.tools.parallel.internal.SpecificLineBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OffsetBuilder {
    public OffsetPosition currentPosition = OffsetPosition.POSITION_UPPER;
    private static final double MIN_CURVE_VERTEX_FACTOR = 1.0E-6;
    private final double deprecateValue;
    private double distance = 0.0;
    private OffsetVertexList vertexList;
    private LineIntersector lineIntersector = new RobustLineIntersector();
    private Map<LineSegment, LineSegment> offsetList = new LinkedHashMap<LineSegment, LineSegment>();
    private Coordinate coord0;
    private Coordinate coord1;
    private Coordinate coord2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private LineSegment offset0 = new LineSegment();
    private LineSegment offset1 = new LineSegment();
    private LineSegment lastOffset = new LineSegment();
    private int side = 0;
    private Boolean lastOutsideTurn = null;
    private static PrecisionModel precisionModel = new PrecisionModel();
    private int startPosition;
    private Coordinate newPt;
    private Coordinate lastCoord = new Coordinate();

    public OffsetBuilder(OffsetPosition offsetPosition, int startPosition, double errorMargin) {
        this.currentPosition = offsetPosition;
        this.startPosition = startPosition;
        this.deprecateValue = errorMargin;
    }

    public List<Geometry> getLineCurve(Coordinate[] inputPts, double distance, GeometryFactory geometryFactory) throws IllegalArgumentException {
        ArrayList<Coordinate> coordList = new ArrayList();
        List<Geometry> resultGeom = new ArrayList<Geometry>();
        if (distance <= 0.0) {
            resultGeom.add((Geometry)geometryFactory.createLineString(inputPts));
            return resultGeom;
        }
        this.init(distance);
        this.computeParallelLineCurve(inputPts);
        coordList = this.vertexList.getList();
        boolean isClosed = false;
        if (inputPts[0].equals2D(inputPts[inputPts.length - 1])) {
            coordList = this.closeRing(coordList, geometryFactory);
            isClosed = true;
        }
        List<Coordinate> sourceList = Arrays.asList(inputPts);
        if (this.currentPosition == OffsetPosition.POSITION_UNDER) {
            sourceList = new ArrayList<Coordinate>();
            int i = inputPts.length - 1;
            while (i >= 0) {
                sourceList.add(inputPts[i]);
                --i;
            }
        }
        resultGeom = this.postBuild(coordList, geometryFactory, sourceList, isClosed, resultGeom);
        return resultGeom;
    }

    private List<Geometry> postBuild(List<Coordinate> coordList, GeometryFactory gf, List<Coordinate> sourceList, boolean isClosed, List<Geometry> resultGeom) {
        Map<Integer, List<DataSegmentIntersection>> intersectionData = null;
        Coordinate[] resultCoord = coordList.toArray(new Coordinate[coordList.size()]);
        LineString preBuildGeom = gf.createLineString(resultCoord);
        intersectionData = this.intersectsWithOffset((Geometry)preBuildGeom, gf, coordList);
        OffsetOrientationAnalyzer ori = new OffsetOrientationAnalyzer(coordList, gf, sourceList, intersectionData);
        resultGeom = isClosed ? ori.discardClosed() : ori.discardNonClosed();
        return resultGeom;
    }

    private Map<Integer, List<DataSegmentIntersection>> intersectsWithOffset(Geometry preBuild, GeometryFactory gf, List<Coordinate> coordList) {
        LinkedHashMap<Integer, List<DataSegmentIntersection>> pointsList = new LinkedHashMap<Integer, List<DataSegmentIntersection>>();
        Iterator<Map.Entry<LineSegment, LineSegment>> iterator = this.offsetList.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            List<DataSegmentIntersection> relation = this.getRelationData(iterator, gf, preBuild, index);
            if (!relation.isEmpty()) {
                pointsList.put(index, relation);
            }
            ++index;
        }
        return pointsList;
    }

    private List<DataSegmentIntersection> getRelationData(Iterator<Map.Entry<LineSegment, LineSegment>> iterator, GeometryFactory gf, Geometry preBuild, int index) {
        List<DataSegmentIntersection> relationSegmIntersect = new ArrayList<DataSegmentIntersection>();
        Map.Entry<LineSegment, LineSegment> item = iterator.next();
        LineSegment key = item.getKey();
        LineSegment value = item.getValue();
        SpecificLineBuilder lineBuilder = new SpecificLineBuilder();
        LineString subjectLine = lineBuilder.mountTheLine(key, value, gf);
        relationSegmIntersect = this.getIntersectSegmentsData(subjectLine, preBuild, index, relationSegmIntersect);
        return relationSegmIntersect;
    }

    private List<DataSegmentIntersection> getIntersectSegmentsData(LineString subjectLine, Geometry preBuild, int index, List<DataSegmentIntersection> relationSegmIntersect) {
        Coordinate[] coords = preBuild.getCoordinates();
        GeometryFactory gf = preBuild.getFactory();
        int i = 0;
        while (i < coords.length - 2) {
            if (i < index - 1 || i > index + 1) {
                Coordinate[] part = new Coordinate[]{coords[i], coords[i + 1]};
                LineString segment = gf.createLineString(part);
                if (subjectLine.intersects((Geometry)segment)) {
                    Coordinate intersectionCoord = subjectLine.intersection((Geometry)segment).getCoordinate();
                    boolean isForward = this.calculateForwardOrBackward(subjectLine, subjectLine.getCoordinates(), index, coords.length, coords, gf, intersectionCoord);
                    relationSegmIntersect.add(new DataSegmentIntersection(i, intersectionCoord, isForward));
                }
            }
            ++i;
        }
        return relationSegmIntersect;
    }

    private boolean calculateForwardOrBackward(LineString subjectLine, Coordinate[] subjectLineCoord, int i, int n, Coordinate[] inputList, GeometryFactory gf, Coordinate intersectionCoord) {
        int backwardCounter;
        int forwardCounter = AlgorithmUtils.forwardIntersectedSegmentsCounter(subjectLine, subjectLineCoord, i, n, inputList, gf, intersectionCoord);
        return forwardCounter < (backwardCounter = AlgorithmUtils.backwardIntersectedSegmentCounter((Geometry)subjectLine, subjectLineCoord, i, n, inputList, gf, intersectionCoord));
    }

    private List<Coordinate> closeRing(List<Coordinate> arrayList, GeometryFactory gf) {
        Coordinate intersectionCoord;
        Coordinate[] lastSeg;
        LineString last;
        Coordinate[] firstSeg = new Coordinate[]{arrayList.get(0), arrayList.get(1)};
        LineString first = gf.createLineString(firstSeg);
        if (first.intersects((Geometry)(last = gf.createLineString(lastSeg = new Coordinate[]{arrayList.get(arrayList.size() - 2), arrayList.get(arrayList.size() - 1)}))) && !lastSeg[0].equals2D(intersectionCoord = first.intersection((Geometry)last).getGeometryN(0).getCoordinate()) && !lastSeg[1].equals2D(intersectionCoord)) {
            arrayList.remove(0);
            arrayList.add(0, intersectionCoord);
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(intersectionCoord);
            return arrayList;
        }
        intersectionCoord = new Coordinate();
        this.lineIntersector.computeIntersection(arrayList.get(0), arrayList.get(1), arrayList.get(arrayList.size() - 2), arrayList.get(arrayList.size() - 1));
        intersectionCoord = this.lineIntersector.hasIntersection() ? this.lineIntersector.getIntersection(0) : GeometryUtil.intersection(arrayList.get(0), arrayList.get(1), arrayList.get(arrayList.size() - 2), arrayList.get(arrayList.size() - 1));
        arrayList.remove(0);
        arrayList.add(0, intersectionCoord);
        arrayList.remove(arrayList.size() - 1);
        arrayList.add(intersectionCoord);
        return arrayList;
    }

    private void init(double distance) {
        this.distance = distance;
        this.vertexList = new OffsetVertexList();
        this.vertexList.setPrecisionModel(precisionModel);
        this.vertexList.setMinimumVertexDistance(distance * 1.0E-6);
    }

    private void computeParallelLineCurve(Coordinate[] inputPts) {
        int n = inputPts.length - 1;
        if (this.currentPosition == OffsetPosition.POSITION_UPPER) {
            this.initSideSegments(inputPts[0], inputPts[1], this.startPosition);
            int i = 2;
            while (i <= n) {
                this.addNextSegment(inputPts[i], true);
                ++i;
            }
            this.addLastSegment();
        } else {
            this.initSideSegments(inputPts[n], inputPts[n - 1], this.startPosition);
            int i = n - 2;
            while (i >= 0) {
                this.addNextSegment(inputPts[i], true);
                --i;
            }
            this.addLastSegment();
        }
        this.addLastOffsetToList();
    }

    private void addLastSegment() {
        if (this.lastOutsideTurn != null && this.lastOutsideTurn.booleanValue() || this.vertexList.size() == 0) {
            this.vertexList.addPt(this.offset1.p0, false);
        }
        this.vertexList.addPt(this.offset1.p1, false);
    }

    private void initSideSegments(Coordinate s1, Coordinate s2, int side) {
        this.coord1 = s1;
        this.coord2 = s2;
        this.side = side;
        this.seg1.setCoordinates(s1, s2);
        this.computeOffsetSegment(this.seg1, side, this.distance, this.offset1);
    }

    private void computeOffsetSegment(LineSegment seg, int side, double distance, LineSegment offset) {
        int sideSign = side == 1 ? 1 : -1;
        double dx = seg.p1.x - seg.p0.x;
        double dy = seg.p1.y - seg.p0.y;
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = (double)sideSign * distance * dx / len;
        double uy = (double)sideSign * distance * dy / len;
        offset.p0.x = seg.p0.x - uy;
        offset.p0.y = seg.p0.y + ux;
        offset.p1.x = seg.p1.x - uy;
        offset.p1.y = seg.p1.y + ux;
    }

    private void addNextSegment(Coordinate p, boolean addStartPoint) {
        boolean outsideTurn;
        this.coord0 = this.coord1;
        this.coord1 = this.coord2;
        this.coord2 = p;
        this.seg0.setCoordinates(this.coord0, this.coord1);
        this.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        this.seg1.setCoordinates(this.coord1, this.coord2);
        this.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        if (this.coord1.equals((Object)this.coord2)) {
            return;
        }
        int orientation = CGAlgorithms.computeOrientation((Coordinate)this.coord0, (Coordinate)this.coord1, (Coordinate)this.coord2);
        boolean bl = outsideTurn = orientation == -1 && this.side == 1 || orientation == 1 && this.side == 2;
        if (this.lastOutsideTurn == null) {
            this.lastOutsideTurn = outsideTurn;
        }
        if (outsideTurn) {
            if (this.lastOutsideTurn.booleanValue()) {
                this.vertexList.addPt(this.offset0.p0, false);
            }
            this.addOutsideTurn(addStartPoint);
        } else {
            if (this.vertexList.size() == 0) {
                this.vertexList.addPt(this.offset0.p0, false);
            }
            if (this.lastOutsideTurn.booleanValue()) {
                this.vertexList.addPt(this.offset0.p0, false);
            }
            this.addInsideTurn();
        }
        this.lastOffset.setCoordinates(this.offset0);
        this.lastCoord.setCoordinate(this.coord0);
        LineSegment referencedFromList = new LineSegment();
        referencedFromList.setCoordinates(this.vertexList.getSecondToLastItem(), this.vertexList.getLastItem());
        LineSegment fromOffset = new LineSegment();
        fromOffset.setCoordinates(this.offset0);
        this.offsetList.put(referencedFromList, fromOffset);
        this.lastOutsideTurn = outsideTurn;
    }

    private void addLastOffsetToList() {
        LineSegment derivatedFromList = new LineSegment();
        derivatedFromList.setCoordinates(this.vertexList.getSecondToLastItem(), this.vertexList.getLastItem());
        LineSegment referenceOffset = new LineSegment();
        referenceOffset.setCoordinates(this.offset0);
        this.offsetList.put(derivatedFromList, referenceOffset);
    }

    private void addCornerPoint(LineSegment offset0, LineSegment offset1, boolean b) {
        Coordinate pt = new Coordinate();
        pt = GeometryUtil.intersection(offset0.p0, offset0.p1, offset1.p0, offset1.p1);
        this.vertexList.addPt(pt, b);
    }

    private void addOutsideTurn(boolean addStartPoint) {
        if (addStartPoint) {
            this.vertexList.addPt(this.offset0.p1, false);
        }
        this.addCornerPoint(this.offset0, this.offset1, true);
    }

    private void addInsideTurn() {
        if (!this.linesParallel(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1, this.deprecateValue)) {
            this.newPt = new Coordinate();
            this.newPt = GeometryUtil.intersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
            this.vertexList.addPt(this.newPt, false);
        } else {
            this.newPt = GeometryUtil.intersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
            GeometryFactory gf = new GeometryFactory();
            Point closestPoint = gf.createPoint(this.offset0.closestPoint(this.newPt));
            double distance1 = this.offset0.distance(closestPoint.getCoordinate());
            double distance2 = this.offset1.distance(closestPoint.getCoordinate());
            if (distance1 <= this.deprecateValue || distance2 <= this.deprecateValue) {
                this.vertexList.addPt(this.newPt, false);
            }
        }
    }

    private boolean linesParallel(Coordinate line1P1, Coordinate line1P2, Coordinate line2P1, Coordinate line2P2, double despreciate_value) {
        double A1 = line1P2.y - line1P1.y;
        double B2 = line2P1.x - line2P2.x;
        double A2 = line2P2.y - line2P1.y;
        double B1 = line1P1.x - line1P2.x;
        double det = Math.abs(A1 * B2 - A2 * B1);
        return det <= despreciate_value;
    }

    public static enum OffsetPosition {
        POSITION_UPPER,
        POSITION_UNDER;

    }
}

