/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.ParallelPreview;
import eu.udig.tools.parallel.internal.behaviour.PrecisionToolAcceptBehaviour;
import eu.udig.tools.parallel.internal.behaviour.SetInitialPointEventBehaviour;
import eu.udig.tools.parallel.internal.behaviour.SetReferenceFeatureBehaviour;
import eu.udig.tools.parallel.view.ParallelParametersView;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolConfigurationHelper;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.activator.DrawCurrentGeomVerticesActivator;
import net.refractions.udig.tools.edit.activator.DrawGeomsActivator;
import net.refractions.udig.tools.edit.activator.EditStateListenerActivator;
import net.refractions.udig.tools.edit.activator.GridActivator;
import net.refractions.udig.tools.edit.activator.ResetAllStateActivator;
import net.refractions.udig.tools.edit.activator.SetRenderingFilter;
import net.refractions.udig.tools.edit.activator.SetSnapBehaviourCommandHandlerActivator;
import net.refractions.udig.tools.edit.behaviour.AcceptOnDoubleClickBehaviour;
import net.refractions.udig.tools.edit.behaviour.DefaultCancelBehaviour;
import net.refractions.udig.tools.edit.behaviour.DrawCreateVertexSnapAreaBehaviour;
import net.refractions.udig.tools.edit.behaviour.SetSnapSizeBehaviour;
import net.refractions.udig.tools.edit.behaviour.accept.AcceptChangesBehaviour;
import net.refractions.udig.tools.edit.enablement.ValidToolDetectionActivator;
import net.refractions.udig.tools.edit.enablement.WithinLegalLayerBoundsBehaviour;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ParallelTool
extends AbstractEditTool {
    private ParallelContext parallelContext = new ParallelContext();
    private ParallelPreview parallelPreview = null;
    private ParallelParametersView view = null;

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.parallelContext.setHandler(this.getHandler());
            this.parallelContext.initContext();
            this.parallelContext.setEditBlackBoard(this.getHandler().getEditBlackboard(this.getHandler().getEditLayer()));
            this.parallelContext.deleteObservers();
            this.parallelPreview = ParallelPreview.getInstance();
            this.parallelPreview.setParameters(this.getContext(), this.getHandler(), this.parallelContext);
            this.parallelContext.addObserver(this.parallelPreview);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationGIS.getView((boolean)true, (String)"eu.udig.tools.parallel.view.ParallelParametersView");
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart viewPart = page.findView("eu.udig.tools.parallel.view.ParallelParametersView");
                    ParallelTool.this.view = (ParallelParametersView)viewPart;
                    if (!$assertionsDisabled && ParallelTool.this.view == null) {
                        throw new AssertionError((Object)"view is null");
                    }
                    ParallelTool.this.view.setParallelContext(ParallelTool.this.parallelContext);
                }
            });
        } else {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationGIS.getView((boolean)false, (String)"eu.udig.tools.parallel.view.ParallelParametersView");
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart viewPart = page.findView("eu.udig.tools.parallel.view.ParallelParametersView");
                    page.hideView(viewPart);
                }
            });
        }
    }

    protected void initActivators(Set<Activator> activators) {
        activators.add((Activator)new EditStateListenerActivator());
        activators.add((Activator)new DrawGeomsActivator(DrawGeomsActivator.DrawType.LINE));
        activators.add((Activator)new SetSnapBehaviourCommandHandlerActivator());
        activators.add((Activator)new DrawCurrentGeomVerticesActivator());
        activators.add((Activator)new ResetAllStateActivator());
        activators.add((Activator)new SetRenderingFilter());
        activators.add((Activator)new GridActivator());
    }

    protected void initAcceptBehaviours(List<Behaviour> acceptBehaviours) {
        acceptBehaviours.add((Behaviour)new AcceptChangesBehaviour(LineString.class, false));
        acceptBehaviours.add(new PrecisionToolAcceptBehaviour(this.parallelContext));
    }

    protected void initCancelBehaviours(List<Behaviour> cancelBehaviours) {
        cancelBehaviours.add((Behaviour)new DefaultCancelBehaviour());
    }

    protected void initEventBehaviours(EditToolConfigurationHelper helper) {
        helper.add((EventBehaviour)new DrawCreateVertexSnapAreaBehaviour());
        helper.add((EventBehaviour)new SetReferenceFeatureBehaviour(this.parallelContext));
        helper.add((EventBehaviour)new SetInitialPointEventBehaviour(this.parallelContext));
        helper.add((EventBehaviour)new SetSnapSizeBehaviour());
        helper.add((EventBehaviour)new AcceptOnDoubleClickBehaviour());
        helper.done();
    }

    protected void initEnablementBehaviours(List<EnablementBehaviour> enablementBehaviours) {
        enablementBehaviours.add((EnablementBehaviour)new WithinLegalLayerBoundsBehaviour());
        enablementBehaviours.add((EnablementBehaviour)new ValidToolDetectionActivator(new Class[]{Geometry.class, Polygon.class, MultiPolygon.class, LineString.class, MultiLineString.class}));
    }
}

