/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge.internal.view;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import net.refractions.udig.project.ILayer;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class MergeFeatureBuilder {
    private EventListenerList listeners = new EventListenerList();
    private SimpleFeatureType featureType;
    private List<SimpleFeature> sourceFeatures = Collections.synchronizedList(new LinkedList());
    private Object[] mergedFeature;
    private int defaultGeometryIndex;
    private ILayer layer;

    public MergeFeatureBuilder(ILayer layer) {
        assert (layer != null);
        this.layer = layer;
        this.featureType = layer.getSchema();
        GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
        if (geometryDescriptor == null) {
            throw new IllegalStateException("The layer schema does not contain a geometry descriptor");
        }
        this.mergedFeature = new Object[this.featureType.getAttributeCount()];
        this.defaultGeometryIndex = this.featureType.indexOf(geometryDescriptor.getName());
    }

    private boolean compatibleFeatureType(List<SimpleFeature> sourceFeatures) {
        this.featureType = sourceFeatures.get(0).getFeatureType();
        int i = 0;
        while (i < sourceFeatures.size()) {
            SimpleFeature next = sourceFeatures.get(i);
            if (this.featureType != next.getFeatureType()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addSourceFeature(List<SimpleFeature> featureList) {
        for (SimpleFeature feature : featureList) {
            this.addSourceFeature(feature);
        }
    }

    public int addSourceFeature(SimpleFeature feature) {
        if (this.sourceFeatures.contains(feature)) {
            return -1;
        }
        if (this.sourceFeatures.isEmpty()) {
            this.setDefaultMergeValues(feature);
        }
        assert (this.canMerge(feature)) : "this precondition should be evaluated before call this method";
        this.sourceFeatures.add(feature);
        assert (this.compatibleFeatureType(this.sourceFeatures)) : "Features in the collection must conform to a common schema";
        return this.sourceFeatures.size() - 1;
    }

    private void setDefaultMergeValues(SimpleFeature feature) {
        this.mergedFeature = feature.getAttributes().toArray();
        this.mergedFeature[this.getDefaultGeometryIndex()] = null;
    }

    public void addChangeListener(ChangeListener listener) {
        assert (listener != null);
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    public SimpleFeature buildMergedFeature() throws IllegalStateException {
        SimpleFeature feature;
        try {
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.featureType);
            builder.addAll(this.mergedFeature);
            feature = builder.buildFeature(null);
            Geometry geometry = this.buildMergeGeometry();
            feature.setDefaultGeometry((Object)geometry);
        }
        catch (IllegalAttributeException e) {
            throw new IllegalStateException("Can't create merged feature: " + e.getMessage(), e);
        }
        return feature;
    }

    public String getPrittyMergeGeometry() {
        String printableGeom = this.isGeometriesUnion() ? "Union" : this.mergedFeature[this.getDefaultGeometryIndex()].toString();
        return printableGeom;
    }

    public int getDefaultGeometryIndex() {
        assert (this.defaultGeometryIndex >= 0);
        return this.defaultGeometryIndex;
    }

    public boolean isGeometriesUnion() {
        int defaultGeometryIndex = this.getDefaultGeometryIndex();
        boolean geomAttIsMerged = this.mergedFeature[defaultGeometryIndex] == null;
        return geomAttIsMerged;
    }

    public String getAttributeName(int attIndex) {
        assert (attIndex < this.getAttributeCount());
        AttributeDescriptor attributeType = this.featureType.getDescriptor(attIndex);
        return attributeType.getLocalName();
    }

    public Object getMergeAttribute(int attributeIndex) {
        assert (attributeIndex < this.getAttributeCount());
        Object attribute = this.mergedFeature[attributeIndex];
        return attribute;
    }

    public void copyAttributeToMerge(int srcFeatureIndex, int attributeIndex) throws IllegalArgumentException {
        assert (srcFeatureIndex < this.getFeatureCount());
        assert (attributeIndex < this.getAttributeCount());
        Object value = this.getAttribute(srcFeatureIndex, attributeIndex);
        this.setMergeValue(attributeIndex, value);
    }

    public void clearMergeAttribute(int attributeIndex) {
        assert (attributeIndex < this.getAttributeCount());
        Object value = null;
        if (attributeIndex == this.getDefaultGeometryIndex()) {
            value = null;
        }
        this.setMergeValue(attributeIndex, value);
    }

    public Object getAttribute(int featureIndex, int attributeIndex) {
        assert (featureIndex < this.getFeatureCount());
        assert (attributeIndex < this.getAttributeCount());
        SimpleFeature feature = this.getFeature(featureIndex);
        Object attribute = feature.getAttribute(attributeIndex);
        return attribute;
    }

    public int getFeatureCount() {
        return this.sourceFeatures.size();
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public String getID(int featureIndex) {
        assert (featureIndex < this.getFeatureCount());
        SimpleFeature feature = this.getFeature(featureIndex);
        return feature.getID();
    }

    private void setMergeValue(int attributeIndex, Object value) {
        Object oldValue = this.getMergeAttribute(attributeIndex);
        this.mergedFeature[attributeIndex] = value;
        this.fireChangedEvent(attributeIndex, oldValue);
    }

    private void fireChangedEvent(int attributeIndex, Object oldValue) {
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener listener = changeListenerArray[n2];
            listener.attributeChanged(this, attributeIndex, oldValue);
            ++n2;
        }
    }

    public SimpleFeature getFeature(int featureIndex) {
        SimpleFeature feature = this.sourceFeatures.get(featureIndex);
        return feature;
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public List<SimpleFeature> getSourceFeatures() {
        LinkedList<SimpleFeature> clone = new LinkedList<SimpleFeature>(this.sourceFeatures);
        return clone;
    }

    public void removeFromSourceFeatures(SimpleFeature selectedFeature) {
        this.sourceFeatures.remove(selectedFeature);
    }

    public synchronized void removeFromSourceFeatures(List<SimpleFeature> featureList) {
        this.sourceFeatures.removeAll(featureList);
    }

    public synchronized void removeFromSourceFeaturesAll() {
        this.sourceFeatures.clear();
    }

    public boolean canMerge(SimpleFeature newFeature) {
        if (this.sourceFeatures.isEmpty()) {
            return true;
        }
        Geometry defaultGeometry = (Geometry)newFeature.getDefaultGeometry();
        assert (defaultGeometry != null) : "the feature " + newFeature.getID() + " has not geometry!";
        Class geomClass = defaultGeometry != null ? defaultGeometry.getClass() : Object.class;
        Class layerGemetryClass = this.layer.getSchema().getGeometryDescriptor().getType().getBinding();
        if (!layerGemetryClass.isAssignableFrom(geomClass)) {
            return false;
        }
        if (GeometryCollection.class.isAssignableFrom(geomClass)) {
            return true;
        }
        assert (defaultGeometry instanceof Polygon || defaultGeometry instanceof LineString || defaultGeometry instanceof Point);
        for (SimpleFeature sourceFeature : this.sourceFeatures) {
            Geometry sourceGeometry = (Geometry)sourceFeature.getDefaultGeometry();
            if (!defaultGeometry.intersects(sourceGeometry)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Geometry buildMergeGeometry() {
        Geometry union;
        Geometry geom = (Geometry)this.mergedFeature[this.getDefaultGeometryIndex()];
        if (geom != null) {
            return geom;
        }
        SimpleFeatureType type = this.layer.getSchema();
        Class expectedGeometryType = type.getGeometryDescriptor().getType().getBinding();
        List<SimpleFeature> list = this.sourceFeatures;
        synchronized (list) {
            union = GeometryUtil.geometryUnion((FeatureCollection<SimpleFeatureType, SimpleFeature>)DataUtilities.collection(this.sourceFeatures));
        }
        union = GeometryUtil.adapt(union, (Class<? extends Geometry>)expectedGeometryType);
        return union;
    }

    public static interface ChangeListener
    extends EventListener {
        public void attributeChanged(MergeFeatureBuilder var1, int var2, Object var3);
    }
}

