/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge;

import com.vividsolutions.jts.geom.Envelope;
import eu.udig.tools.internal.ui.util.LayerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;

public final class Util {
    private Util() {
    }

    public static List<SimpleFeature> retrieveFeatures(Filter filter, ILayer layer) throws IOException {
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = LayerUtil.getSelectedFeatures(layer, filter);
        ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>();
        FeatureIterator iter = null;
        try {
            iter = features.features();
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                featureList.add(f);
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return featureList;
    }

    public static List<SimpleFeature> retrieveFeaturesInBBox(List<Envelope> bbox, IToolContext context) throws IOException {
        ILayer selectedLayer = context.getSelectedLayer();
        FeatureSource source = (FeatureSource)selectedLayer.getResource(FeatureSource.class, null);
        String typename = ((SimpleFeatureType)source.getSchema()).getName().toString();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Filter filter = selectedLayer.createBBoxFilter(bbox.get(0), null);
        Or filterOR = null;
        int index = 0;
        while (index < bbox.size()) {
            Filter mergedFilter = selectedLayer.createBBoxFilter(bbox.get(index), null);
            filterOR = ff.or(filter, mergedFilter);
            ++index;
        }
        Query query = new Query(typename, filterOR);
        FeatureCollection features = source.getFeatures(query);
        ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>();
        FeatureIterator iter = null;
        try {
            iter = features.features();
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                featureList.add(f);
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return featureList;
    }
}

