/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge;

import com.vividsolutions.jts.geom.Envelope;
import eu.udig.tools.merge.internal.view.MergeView;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.opengis.feature.simple.SimpleFeature;

public class MergeContext {
    private static final MergeContext THIS = new MergeContext();
    public static final int MERGEMODE_TOOL = 1;
    public static final int MERGEMODE_OPERATION = 2;
    private int mergeMode;
    private Point bboxStartPoint = null;
    private SelectionBoxCommand selectionBoxCommand = new SelectionBoxCommand();
    private List<Envelope> boundList = new ArrayList<Envelope>();
    private MergeView mergeView = null;
    private IToolContext toolContext = null;
    private List<SimpleFeature> preSelectedFeatures = Collections.emptyList();
    private ILayer preSelectedLayer = null;

    private MergeContext() {
    }

    public static MergeContext getInstance() {
        return THIS;
    }

    public IToolContext getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(IToolContext toolContext) {
        this.toolContext = toolContext;
    }

    public void initContext() {
        this.bboxStartPoint = null;
        this.selectionBoxCommand = new SelectionBoxCommand();
        this.mergeView = null;
        this.toolContext = null;
        this.boundList.clear();
    }

    public synchronized void setBBoxStartPoint(Point point) {
        assert (point != null);
        this.bboxStartPoint = point;
    }

    public synchronized Point getBBoxStartPoint() {
        return this.bboxStartPoint;
    }

    public SelectionBoxCommand getSelectionBoxCommand() {
        return this.selectionBoxCommand;
    }

    public void addBound(Envelope bound) {
        assert (bound != null);
        this.boundList.add(bound);
    }

    public void removeBound(Envelope bound) {
        assert (bound != null);
        this.boundList.remove(bound);
    }

    public List<Envelope> getBoundList() {
        return this.boundList;
    }

    public MergeView getMergeView() {
        return this.mergeView;
    }

    public boolean isMergeViewActive() {
        return this.mergeView != null && !this.mergeView.isDisposed();
    }

    public void disposeMergeView() {
        this.mergeView = null;
    }

    public void activeMergeView(MergeView view) {
        this.mergeView = view;
    }

    public void setMergeMode(int mode) {
        this.mergeMode = mode;
    }

    public int getMergeMode() {
        return this.mergeMode;
    }

    public void addPreselectedFeatures(List<SimpleFeature> preSelectedFeatures, ILayer preSelectedLayer) {
        this.preSelectedFeatures = preSelectedFeatures;
        this.preSelectedLayer = preSelectedLayer;
    }

    public List<SimpleFeature> getPreselectedFeatures() {
        return this.preSelectedFeatures;
    }

    public ILayer getPreSelectedLayer() {
        return this.preSelectedLayer;
    }

    public void clearPreselectedFeatures() {
        this.preSelectedFeatures.clear();
    }
}

