/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.internal.ui.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.feature.util.FeatureUtil;
import eu.udig.tools.internal.ui.util.MapUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.SelectionCommandFactory;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class LayerUtil {
    private LayerUtil() {
    }

    private static Query getSelectionQuery(ILayer layer) {
        Filter filter;
        Query selectionQuery = layer.getQuery(true);
        Query layerQuery = new Query(selectionQuery);
        CoordinateReferenceSystem layerCrs = layer.getCRS();
        if (ILayer.UNKNOWN_CRS == layerCrs) {
            CoordinateReferenceSystem mapCRS = MapUtil.getCRS(layer.getMap());
            layerQuery.setCoordinateSystem(mapCRS);
        }
        if (Filter.EXCLUDE.equals(filter = selectionQuery.getFilter())) {
            layerQuery.setFilter((Filter)Filter.INCLUDE);
        }
        return layerQuery;
    }

    public static int getCountOfSelectedFeatures(ILayer layer) throws IOException {
        return LayerUtil.getCountOfSelectedFeatures(layer, (Filter)Filter.INCLUDE);
    }

    public static int getCountOfSelectedFeatures(ILayer layer, Filter filter) throws IOException {
        FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, null);
        assert (source != null);
        Query query = LayerUtil.getSelectionQuery(layer);
        FeatureCollection features = source.getFeatures(query);
        if (features.isEmpty()) {
            features = source.getFeatures(filter);
        }
        int count = FeatureUtil.computeCollectionSize((FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
        return count;
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> getSelectedFeatures(ILayer layer) throws IOException {
        return LayerUtil.getSelectedFeatures(layer, (Filter)Filter.INCLUDE);
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> findAllFeatures(ILayer layer) throws IOException {
        return LayerUtil.getSelectedFeatures(layer, (Filter)Filter.INCLUDE);
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> getSelectedFeatures(ILayer layer, Filter extraFilter) throws IOException {
        FeatureCollection features;
        assert (layer != null);
        assert (extraFilter != null);
        FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, ProgressManager.instance().get(new Object[0]));
        if (source == null) {
            return FeatureCollections.newCollection();
        }
        Query selectionQuery = LayerUtil.getSelectionQuery(layer);
        if (!Filter.INCLUDE.equals(extraFilter)) {
            Filter selectionFilter = selectionQuery.getFilter();
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            And filter = ff.and(selectionFilter, extraFilter);
            selectionQuery.setFilter((Filter)filter);
            features = source.getFeatures(selectionQuery);
        } else {
            features = source.getFeatures();
        }
        return features;
    }

    public static String findNewLayerName(IMap map, String name) {
        String newLayerName = name;
        HashSet<String> layerNames = new HashSet<String>();
        for (ILayer layer : map.getMapLayers()) {
            layerNames.add(layer.getName());
        }
        int matches = 1;
        while (layerNames.contains(newLayerName)) {
            newLayerName = String.valueOf(name) + ++matches;
        }
        return newLayerName;
    }

    public static String findNewLayerName(ILayer existingLayer, String name) throws IOException {
        String newLayerName = LayerUtil.findNewLayerName(existingLayer.getMap(), name);
        IGeoResource resource = existingLayer.findGeoResource(FeatureSource.class);
        if (resource != null) {
            FeatureSource source = (FeatureSource)resource.resolve(FeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
            DataStore ds = (DataStore)source.getDataStore();
            String[] dsTypes = ds.getTypeNames();
            HashSet<String> typeNames = new HashSet<String>(Arrays.asList(dsTypes));
            int matches = 1;
            while (typeNames.contains(newLayerName)) {
                newLayerName = String.valueOf(name) + ++matches;
            }
        }
        return newLayerName;
    }

    public static CoordinateReferenceSystem getCrs(ILayer sourceLayer) {
        assert (sourceLayer != null);
        CoordinateReferenceSystem crs = sourceLayer.getCRS();
        if (ILayer.UNKNOWN_CRS == crs) {
            IMap map = sourceLayer.getMap();
            IViewportModel viewportModel = map.getViewportModel();
            crs = viewportModel.getCRS();
        }
        return crs;
    }

    public static Coordinate mapToLayer(IMap map, ILayer layer, Coordinate coordInMapCrs) {
        try {
            MathTransform toLayer = layer.mapToLayerTransform();
            double[] src = new double[]{coordInMapCrs.x, coordInMapCrs.y};
            double[] dst = new double[2];
            toLayer.transform(src, 0, dst, 0, 1);
            return new Coordinate(dst[0], dst[1]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<? extends Geometry> getGeometryClass(ILayer layer) {
        assert (layer != null);
        GeometryDescriptor type = layer.getSchema().getGeometryDescriptor();
        Class geomClass = type.getType().getBinding();
        return geomClass;
    }

    public static void presentSelection(ILayer sourceLayer, Filter filter) {
        assert (sourceLayer != null);
        assert (filter != null);
        UndoableMapCommand createSelectCommand = SelectionCommandFactory.getInstance().createSelectCommand(sourceLayer, filter);
        sourceLayer.getMap().sendCommandSync((MapCommand)createSelectCommand);
    }

    public static boolean isCompatible(ILayer layer, List<?> geometries) {
        if (layer == null) {
            return false;
        }
        Class type = layer.getSchema().getGeometryDescriptor().getType().getBinding();
        return geometries.contains(type);
    }
}

