/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.internal.ui.util;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.mediator.PlatformGISMediator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class DialogUtil {
    private DialogUtil() {
    }

    public static void openError(final String title, final String message) {
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)title, (String)message);
            }
        });
    }

    public static void openInformation(final String title, final String message) {
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)title, (String)message);
            }
        });
    }

    public static void openWarning(final String title, final String message) {
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)title, (String)message);
            }
        });
    }

    public static boolean openQuestion(final String title, final String message) {
        final boolean[] confirm = new boolean[1];
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                confirm[0] = MessageDialog.openQuestion(null, (String)title, (String)message);
            }
        });
        return confirm[0];
    }

    public static boolean openConfirm(final String title, final String message) {
        final boolean[] confirm = new boolean[1];
        PlatformGISMediator.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                confirm[0] = MessageDialog.openConfirm(null, (String)title, (String)message);
            }
        });
        return confirm[0];
    }

    public static void runInProgressDialog(final String dialogTitle, final boolean showRunInBackground, final IRunnableWithProgress process, boolean runASync, final boolean confirmCancelRequests) {
        Runnable object = new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ProgressMonitorDialog dialog = DialogUtil.openProgressMonitorDialog(shell, dialogTitle, showRunInBackground, confirmCancelRequests);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                PlatformGISMediator.runBlockingOperation(new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        process.run(monitor);
                                    }
                                }, monitor);
                            }
                            catch (InvocationTargetException e) {
                                throw e;
                            }
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (runASync) {
            Display.getDefault().asyncExec(object);
        } else {
            PlatformGISMediator.syncInDisplayThread(object);
        }
    }

    public static void runsyncInDisplayThread(final String dialogTitle, final boolean showRunInBackground, final IRunnableWithProgress process, final boolean confirmCancelRequests) {
        Runnable object = new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ProgressMonitorDialog dialog = DialogUtil.openProgressMonitorDialog(shell, dialogTitle, showRunInBackground, confirmCancelRequests);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                PlatformGISMediator.syncInDisplayThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            process.run(monitor);
                                        }
                                        catch (InvocationTargetException e) {
                                            e.printStackTrace();
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        PlatformGISMediator.syncInDisplayThread(object);
    }

    public static ProgressMonitorDialog openProgressMonitorDialog(Shell shell, final String dialogTitle, final boolean showRunInBackground, final boolean confirmCancelRequests) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

            protected void cancelPressed() {
                boolean confirmed = true;
                if (confirmCancelRequests) {
                    String title = Messages.DialogUtil_title;
                    String message = Messages.DialogUtil_message;
                    confirmed = DialogUtil.openQuestion(title, message);
                }
                if (confirmed) {
                    super.cancelPressed();
                }
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(dialogTitle);
            }

            protected void createButtonsForButtonBar(Composite parent) {
                if (showRunInBackground) {
                    this.createBackgroundButton(parent);
                }
                super.createButtonsForButtonBar(parent);
            }

            private void createBackgroundButton(Composite parent) {
                this.createButton(parent, 14, Messages.DialogUtil_runInBackground, true);
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 14) {
                    this.getShell().setVisible(false);
                } else {
                    super.buttonPressed(buttonId);
                }
            }
        };
        return dialog;
    }
}

