/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.internal.mediator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BusyIndicator;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.geotools.data.FeatureStore;
import org.opengis.feature.simple.SimpleFeatureType;

public final class AppGISAdapter {
    private AppGISAdapter() {
    }

    public static List<? extends ILayer> addLayersToMap(IMap map, List<IGeoResource> resources, int index) {
        return ApplicationGIS.addLayersToMap((IMap)map, resources, (int)index);
    }

    public static List<ILayer> getActiveMapLayers() {
        IMap map = ApplicationGIS.getActiveMap();
        return AppGISAdapter.getMapLayers(map);
    }

    public static List<ILayer> getMapLayers(IMap map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List list = map.getMapLayers();
        LinkedList<ILayer> sortedLayerList = new LinkedList<ILayer>();
        for (ILayer layerToInsert : list) {
            if (!AppGISAdapter.canResolveFeautreStore(layerToInsert) || layerToInsert.getName() == null) continue;
            if (sortedLayerList.size() == 0) {
                sortedLayerList.add(layerToInsert);
                continue;
            }
            int insertPosition = -1;
            int i = 0;
            while (i < sortedLayerList.size()) {
                String curName = ((ILayer)sortedLayerList.get(i)).getName();
                if (layerToInsert.getName().compareTo(curName) < 0) {
                    insertPosition = i;
                }
                ++i;
            }
            if (insertPosition != -1) {
                sortedLayerList.add(insertPosition, layerToInsert);
                continue;
            }
            sortedLayerList.add(layerToInsert);
        }
        return sortedLayerList;
    }

    private static boolean canResolveFeautreStore(ILayer layer) {
        IGeoResource resource = layer.getGeoResource();
        boolean retValue = resource.canResolve(FeatureStore.class);
        return retValue;
    }

    public static IMap getActiveMap() {
        IMap map = ApplicationGIS.getActiveMap();
        return map;
    }

    public static ICatalog getCatalog() {
        return CatalogPlugin.getDefault().getLocalCatalog();
    }

    public static IGeoResource createTempGeoResource(SimpleFeatureType featureType) {
        assert (featureType != null);
        ICatalog catalog = AppGISAdapter.getCatalog();
        assert (catalog != null);
        IGeoResource resource = catalog.createTemporaryResource((Object)featureType);
        return resource;
    }

    public static ILayer getSelectedLayer() {
        IMap map = AppGISAdapter.getActiveMap();
        if (map == null) {
            return null;
        }
        IEditManager edit = map.getEditManager();
        if (edit == null) {
            return null;
        }
        ILayer layer = edit.getSelectedLayer();
        if (layer == null) {
            return null;
        }
        if (layer.getName() == null) {
            return null;
        }
        return layer;
    }

    public static EditCommandFactory getEditCommandFactory() {
        return EditCommandFactory.getInstance();
    }

    public static void showWhile(ViewportPane pane, Runnable runnable) {
        BusyIndicator.showWhile((ViewportPane)pane, (Runnable)runnable);
    }
}

