/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import eu.udig.tools.geometry.internal.util.GeometryList;
import eu.udig.tools.geometry.internal.util.GeometrySet;
import eu.udig.tools.geometry.split.AdaptedPolygon;
import eu.udig.tools.geometry.split.RingUtil;
import eu.udig.tools.geometry.split.UsefulSplitLineBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class SplitUtil {
    public static List<LinearRing> addRingThatIntersects(LineString segment, Polygon polygon) {
        GeometryList<LinearRing> rings = new GeometryList<LinearRing>();
        int j = 0;
        while (j < polygon.getNumInteriorRing()) {
            LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(j);
            if (interiorRing.intersects((Geometry)segment)) {
                rings.add(interiorRing);
            }
            ++j;
        }
        return rings;
    }

    public static double calculateDistanceFromFirst(Coordinate intersectionCoord, Coordinate firstSegmentCoord, Coordinate secondSegmentCoord) {
        return firstSegmentCoord.distance(intersectionCoord);
    }

    public static int countIntersectionsFromPosition(int posFirstCoord, Coordinate[] coordinates, Geometry boundary) {
        GeometrySet intersectionList = new GeometrySet();
        int i = posFirstCoord;
        while (i < coordinates.length - 1) {
            Geometry intersection = SplitUtil.intersection(coordinates, i, boundary, false);
            if (intersection instanceof Point || intersection instanceof MultiPoint || intersection instanceof GeometryCollection) {
                int j = 0;
                while (j < intersection.getNumGeometries()) {
                    Geometry intersectionPart = intersection.getGeometryN(j);
                    if (!intersectionList.contains(intersectionPart)) {
                        intersectionList.add(intersectionPart);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return intersectionList.size();
    }

    public static int countIntersectionsFromPosition(int posFirstCoord, Coordinate[] coordinates, Geometry boundary, Coordinate skipCoord) {
        GeometrySet intersectionList = new GeometrySet();
        int i = posFirstCoord;
        while (i < coordinates.length - 1) {
            Geometry intersection = SplitUtil.intersection(coordinates, i, boundary, false);
            if (intersection instanceof Point || intersection instanceof MultiPoint || intersection instanceof GeometryCollection) {
                int j = 0;
                while (j < intersection.getNumGeometries()) {
                    Geometry intersectionPart = intersection.getGeometryN(j);
                    if (!intersectionList.contains(intersectionPart) && !intersectionPart.getCoordinate().equals((Object)skipCoord)) {
                        intersectionList.add(intersectionPart);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return intersectionList.size();
    }

    public static Geometry intersection(Coordinate[] coordinates, int i, Geometry boundary, boolean startsFromEnd) {
        Coordinate[] segmentCoordinates = new Coordinate[]{coordinates[i], startsFromEnd ? coordinates[i - 1] : coordinates[i + 1]};
        LineString segment = boundary.getFactory().createLineString(segmentCoordinates);
        Geometry intersection = boundary.intersection((Geometry)segment);
        assert (intersection instanceof MultiPoint || intersection instanceof Point || intersection instanceof GeometryCollection || intersection instanceof LineString) : "point must be point";
        return intersection;
    }

    public static boolean areAllCoordinatesOutside(Coordinate[] coordinates, Geometry polygonGeometry) {
        GeometryFactory geomFactory = polygonGeometry.getFactory();
        boolean allOutside = true;
        int i = 0;
        while (i < coordinates.length) {
            Point point = geomFactory.createPoint(coordinates[i]);
            if (polygonGeometry.contains((Geometry)point)) {
                allOutside = false;
                break;
            }
            ++i;
        }
        return allOutside;
    }

    public static int findPositionOfFirstCoordinateOutside(LineString splitLine, Geometry polygonGeometry) {
        Coordinate[] lineCoordinates = splitLine.getCoordinates();
        GeometryFactory fc = splitLine.getFactory();
        int position = -1;
        int i = 0;
        while (i < lineCoordinates.length) {
            boolean valid = SplitUtil.isCoordOutSidePolygon(polygonGeometry, lineCoordinates, i, fc);
            if (valid) {
                return i;
            }
            ++i;
        }
        return position;
    }

    public static int findLastCoordinateOutside(LineString splitLine, Geometry polygonGeometry) {
        Coordinate[] lineCoordinates = splitLine.getCoordinates();
        GeometryFactory fc = splitLine.getFactory();
        int position = -1;
        int i = lineCoordinates.length - 1;
        while (i >= 0) {
            boolean valid = SplitUtil.isCoordOutSidePolygon(polygonGeometry, lineCoordinates, i, fc);
            if (valid) {
                return i;
            }
            --i;
        }
        return position;
    }

    private static boolean isCoordOutSidePolygon(Geometry polygonGeometry, Coordinate[] lineCoords, int indexInLineCoords, GeometryFactory fc) {
        Point point = fc.createPoint(lineCoords[indexInLineCoords]);
        if (polygonGeometry.disjoint((Geometry)point)) {
            return true;
        }
        if (polygonGeometry.touches((Geometry)point) && indexInLineCoords < lineCoords.length - 1) {
            Coordinate[] firstSeg = new Coordinate[]{lineCoords[indexInLineCoords], lineCoords[indexInLineCoords + 1]};
            LineString firstSegment = fc.createLineString(firstSeg);
            return SplitUtil.containsLineString(polygonGeometry.intersection((Geometry)firstSegment));
        }
        return false;
    }

    public static boolean containsLineString(Geometry geometry) {
        int i = 0;
        while (i < geometry.getNumGeometries()) {
            Geometry geomPart = geometry.getGeometryN(i);
            if (geomPart instanceof LineString || geomPart instanceof MultiLineString) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isClosedLine(LineString splitLine) {
        Geometry multiLines = splitLine.union();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(multiLines);
        Collection polyCollection = polygonizer.getPolygons();
        return polyCollection.size() != 0;
    }

    public static Geometry buildLineUnion(Geometry splitLines) {
        List<Geometry> resultGeoms = new ArrayList<Geometry>();
        List<Coordinate> mergedCoordinates = new ArrayList<Coordinate>();
        GeometryFactory gf = splitLines.getFactory();
        int i = 0;
        while (i < splitLines.getNumGeometries()) {
            Coordinate[] partCoord = splitLines.getGeometryN(i).getCoordinates();
            if (!mergedCoordinates.isEmpty()) {
                Coordinate lastAddedCoord = (Coordinate)mergedCoordinates.get(mergedCoordinates.size() - 1);
                if (lastAddedCoord.equals2D(partCoord[0])) {
                    mergedCoordinates = SplitUtil.addCoordinates(partCoord, mergedCoordinates, 1);
                } else {
                    resultGeoms = SplitUtil.addMergedGeometry(mergedCoordinates, resultGeoms, gf);
                    mergedCoordinates.clear();
                    mergedCoordinates = SplitUtil.addCoordinates(partCoord, mergedCoordinates, 0);
                }
            } else {
                mergedCoordinates = SplitUtil.addCoordinates(partCoord, mergedCoordinates, 0);
            }
            ++i;
        }
        if (mergedCoordinates.size() != 0) {
            resultGeoms = SplitUtil.addMergedGeometry(mergedCoordinates, resultGeoms, gf);
        }
        return gf.buildGeometry(resultGeoms);
    }

    private static List<Geometry> addMergedGeometry(List<Coordinate> mergedCoordinates, List<Geometry> resultGeoms, GeometryFactory gf) {
        Coordinate[] mergedArray = mergedCoordinates.toArray(new Coordinate[mergedCoordinates.size()]);
        if (mergedArray.length > 2 && !SplitUtil.isColinear(mergedArray)) {
            Coordinate[] closed = RingUtil.builRing(mergedArray);
            if (!CGAlgorithms.isCCW((Coordinate[])closed)) {
                Geometry reverse = SplitUtil.reverseLineString(closed, gf);
                assert (CGAlgorithms.isCCW((Coordinate[])reverse.getCoordinates())) : "It should be CCW. Actual SplitLine: " + reverse;
                reverse = SplitUtil.reverseLineString(mergedArray, gf);
                resultGeoms.add(reverse);
            } else {
                resultGeoms.add((Geometry)gf.createLineString(mergedArray));
            }
        } else {
            resultGeoms.add((Geometry)gf.createLineString(mergedArray));
        }
        return resultGeoms;
    }

    public static boolean isColinear(Coordinate[] lineCoord) {
        boolean isColinear = true;
        int i = 0;
        while (i < lineCoord.length - 2) {
            if (CGAlgorithms.computeOrientation((Coordinate)lineCoord[i], (Coordinate)lineCoord[i + 1], (Coordinate)lineCoord[i + 2]) != 0) {
                isColinear = false;
                break;
            }
            ++i;
        }
        return isColinear;
    }

    private static List<Coordinate> addCoordinates(Coordinate[] partCoord, List<Coordinate> mergedCoordinates, int startPosition) {
        int j = startPosition;
        while (j < partCoord.length) {
            mergedCoordinates.add(partCoord[j]);
            ++j;
        }
        return mergedCoordinates;
    }

    private static Geometry reverseLineString(Coordinate[] intersectionCoordinates, GeometryFactory gf) {
        intersectionCoordinates = CoordinateArrays.copyDeep((Coordinate[])intersectionCoordinates);
        CoordinateArrays.reverse((Coordinate[])intersectionCoordinates);
        return gf.createLineString(intersectionCoordinates);
    }

    public static Coordinate[] createCoordinateArrayWithoutDuplicated(int posFirstCoord, int posLastCoord, Coordinate[] sourceCoords) {
        Coordinate[] newCoords = new Coordinate[posLastCoord - posFirstCoord + 1];
        newCoords = Arrays.copyOfRange(sourceCoords, posFirstCoord, posLastCoord + 1);
        newCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])newCoords);
        return newCoords;
    }

    public static Coordinate[] replaceCoordinate(int insertPosition, Coordinate newCoord, Coordinate[] coordArray) {
        ArrayList<Coordinate> workingArray = new ArrayList<Coordinate>(Arrays.asList(coordArray));
        workingArray.set(insertPosition, newCoord);
        return workingArray.toArray(new Coordinate[workingArray.size()]);
    }

    public static LineString insertVertexInLine(LineString line, Coordinate vertex) {
        Coordinate[] lineCoords = line.getCoordinates();
        if (CoordinateArrays.indexOf((Coordinate)vertex, (Coordinate[])lineCoords) > 0) {
            return line;
        }
        Coordinate[] newLineCoords = SplitUtil.insertVertexInLine(lineCoords, vertex);
        LineString newLine = line.getFactory().createLineString(newLineCoords);
        return newLine;
    }

    public static Coordinate[] insertVertexInLine(Coordinate[] line, Coordinate vertex) {
        Coordinate[] newLine = new Coordinate[line.length + 1];
        double vertexDistance = line[0].distance(vertex);
        int found = -1;
        int j = -1;
        int i = 0;
        while (i < line.length) {
            double currentDistance = line[0].distance(line[i]);
            if (!(currentDistance <= vertexDistance)) {
                found = i;
                break;
            }
            newLine[++j] = line[i];
            ++i;
        }
        if (found != -1) {
            newLine[++j] = vertex;
            i = found;
            while (i < line.length) {
                newLine[++j] = line[i];
                ++i;
            }
        } else {
            newLine[newLine.length - 1] = vertex;
        }
        return newLine;
    }

    public static Coordinate[] mergeCoordinate(Coordinate[] firstLine, Coordinate[] secondLine) {
        LinkedList<Coordinate> merge = new LinkedList<Coordinate>();
        int i = 0;
        while (i < firstLine.length) {
            if (!merge.contains(firstLine[i])) {
                merge.add(firstLine[i]);
            }
            ++i;
        }
        i = 0;
        while (i < secondLine.length) {
            if (!merge.contains(secondLine[i])) {
                merge.add(secondLine[i]);
            }
            ++i;
        }
        return merge.toArray(new Coordinate[merge.size()]);
    }

    public static boolean canSplitPolygon(Geometry geometryToSplit, UsefulSplitLineBuilder splitLineBuilder) {
        assert (geometryToSplit instanceof Polygon || geometryToSplit instanceof MultiPolygon);
        LineString originalSplitLine = splitLineBuilder.getOriginalSplitLine();
        Geometry boundary = geometryToSplit.getBoundary();
        if (geometryToSplit.contains((Geometry)originalSplitLine) && !boundary.intersects((Geometry)originalSplitLine)) {
            return SplitUtil.isClosedLine(originalSplitLine);
        }
        if (SplitUtil.isClosedLine(originalSplitLine)) {
            return SplitUtil.validateClosedLine(originalSplitLine, geometryToSplit);
        }
        int i = 0;
        while (i < boundary.getNumGeometries()) {
            Geometry eachBoundary = boundary.getGeometryN(i);
            Geometry intersectionPonts = eachBoundary.intersection((Geometry)originalSplitLine);
            if (!(intersectionPonts instanceof LineString) && !(intersectionPonts instanceof MultiLineString)) {
                assert (intersectionPonts instanceof MultiPoint || intersectionPonts instanceof Point || intersectionPonts instanceof GeometryCollection) : "the intersection with the boundary must be point or multypoint";
                if (intersectionPonts.getNumGeometries() >= 2) {
                    int j = 0;
                    while (j < geometryToSplit.getNumGeometries()) {
                        Polygon currentPolygon = (Polygon)geometryToSplit.getGeometryN(j);
                        AdaptedPolygon adaptedPolygon = new AdaptedPolygon(currentPolygon);
                        Geometry usefulSplitLines = splitLineBuilder.createUsefulSplitLine(originalSplitLine, adaptedPolygon);
                        if (usefulSplitLines != null) {
                            return true;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean validateClosedLine(LineString splitLine, Geometry originalGeometry) {
        Geometry multiLines = splitLine.union();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(multiLines);
        Collection polyCollection = polygonizer.getPolygons();
        for (Geometry pieces : polyCollection) {
            if (!originalGeometry.contains(pieces) && !originalGeometry.intersects(pieces) || !(originalGeometry.intersection(pieces) instanceof Polygon) && !(originalGeometry.intersection(pieces) instanceof MultiPolygon)) continue;
            return true;
        }
        return false;
    }
}

