/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import eu.udig.tools.geometry.split.Graph;
import eu.udig.tools.geometry.split.RingExtractor;
import eu.udig.tools.geometry.split.SplitClosedLines;
import eu.udig.tools.geometry.split.SplitEdge;
import eu.udig.tools.geometry.split.SplitEdgeStar;
import eu.udig.tools.geometry.split.SplitGraphBuilder;
import eu.udig.tools.geometry.split.SplitGraphNode;
import eu.udig.tools.geometry.split.SplitUtil;
import eu.udig.tools.geometry.split.UsefulSplitLineBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SplitStrategy {
    private static final Logger LOGGER = Logger.getLogger(SplitStrategy.class.getName());
    private final LineString splitLine;
    private final Map<Class<?>, SpecificSplitOp> strategies;

    public SplitStrategy(LineString splitLine) {
        assert (splitLine != null) : "should not be null";
        this.splitLine = splitLine;
        this.strategies = new HashMap(4);
        this.strategies.put(LineString.class, new LineStringSplitter());
        this.strategies.put(MultiLineString.class, new MultiLineStringSplitter());
        this.strategies.put(Polygon.class, new PolygonSplitter());
        this.strategies.put(MultiPolygon.class, new MultiPolygonSplitter());
    }

    public LineString getSplitLine() {
        return this.splitLine;
    }

    public List<Geometry> split(Geometry geomToSplit) {
        assert (!(geomToSplit instanceof Point) && !(geomToSplit instanceof MultiPoint)) : "cannot split point or multipoint";
        Class<?> geometryClass = geomToSplit.getClass();
        SpecificSplitOp splitOp = this.findSplitStrategy(geometryClass);
        UsefulSplitLineBuilder usefulSplitLineBuilder = UsefulSplitLineBuilder.newInstance(this.getSplitLine());
        LOGGER.fine("SplitStrategy, geomToSplit: " + geomToSplit.toText());
        LOGGER.fine("SplitStrategy, split line: " + usefulSplitLineBuilder.getOriginalSplitLine().toText());
        splitOp.setSplitLine(usefulSplitLineBuilder);
        List<Geometry> splitResult = splitOp.split(geomToSplit);
        return splitResult;
    }

    public boolean canSplit(Geometry geomToSplit) {
        assert (geomToSplit != null) : "the Geometry to split musn't be null";
        Class<?> geometryClass = geomToSplit.getClass();
        SpecificSplitOp splitOp = this.findSplitStrategy(geometryClass);
        UsefulSplitLineBuilder usefulSplitLineBuilder = UsefulSplitLineBuilder.newInstance(this.getSplitLine());
        LOGGER.fine("SplitStrategy, geomToSplit: " + geomToSplit.toText());
        LOGGER.fine("SplitStrategy, split line: " + usefulSplitLineBuilder.getOriginalSplitLine().toText());
        splitOp.setSplitLine(usefulSplitLineBuilder);
        boolean bool = splitOp.canSplit(geomToSplit);
        return bool;
    }

    private SpecificSplitOp findSplitStrategy(Class<?> geomToSplitClass) {
        assert (this.strategies.containsKey(geomToSplitClass)) : geomToSplitClass;
        return this.strategies.get(geomToSplitClass);
    }

    private static abstract class AbstractGeometryCollectionSplitter
    implements SpecificSplitOp {
        private SpecificSplitOp splitter;
        private UsefulSplitLineBuilder splitLineBuilder;

        private AbstractGeometryCollectionSplitter(SpecificSplitOp spliterOperation) {
            this.splitter = spliterOperation;
        }

        @Override
        public final void setSplitLine(UsefulSplitLineBuilder splitLine) {
            this.splitLineBuilder = splitLine;
            this.splitter.setSplitLine(splitLine);
        }

        @Override
        public UsefulSplitLineBuilder getSplitLine() {
            return this.splitLineBuilder;
        }

        @Override
        public final List<Geometry> split(Geometry geomToSplit) {
            GeometryCollection coll = (GeometryCollection)geomToSplit;
            int numParts = coll.getNumGeometries();
            ArrayList<Geometry> result = new ArrayList<Geometry>();
            int partN = 0;
            while (partN < numParts) {
                Geometry simplePartN = coll.getGeometryN(partN);
                if (this.splitter.canSplit(simplePartN)) {
                    List<Geometry> splittedPart = this.splitter.split(simplePartN);
                    result.addAll(splittedPart);
                } else {
                    result.add(simplePartN);
                }
                ++partN;
            }
            return result;
        }

        @Override
        public boolean canSplit(Geometry geomToSplit) {
            if (!(geomToSplit instanceof MultiPolygon) && !(geomToSplit instanceof MultiLineString)) {
                throw new IllegalArgumentException("MultiPolygon or MultiLineString geometry is expected");
            }
            GeometryCollection coll = (GeometryCollection)geomToSplit;
            int numParts = coll.getNumGeometries();
            int partN = 0;
            while (partN < numParts) {
                Geometry currentGeometry = coll.getGeometryN(partN);
                if (this.splitter.canSplit(currentGeometry)) {
                    return true;
                }
                ++partN;
            }
            return false;
        }

        protected abstract GeometryCollection buildFromParts(GeometryFactory var1, List<?> var2);
    }

    private static abstract class AbstractSplitter
    implements SpecificSplitOp {
        private UsefulSplitLineBuilder usefulSplitLineBuilder;

        private AbstractSplitter() {
        }

        @Override
        public void setSplitLine(UsefulSplitLineBuilder splitLine) {
            this.usefulSplitLineBuilder = splitLine;
        }

        @Override
        public UsefulSplitLineBuilder getSplitLine() {
            return this.usefulSplitLineBuilder;
        }
    }

    private static class LineStringSplitter
    extends AbstractSplitter {
        private LineStringSplitter() {
        }

        @Override
        public List<Geometry> split(Geometry geomToSplit) {
            LineString lineString = (LineString)geomToSplit;
            LineString splitLine = this.getSplitLine().getOriginalSplitLine();
            Geometry result = lineString.difference((Geometry)splitLine);
            ArrayList<Geometry> listLines = new ArrayList<Geometry>();
            int i = 0;
            while (i < result.getNumGeometries()) {
                listLines.add(result.getGeometryN(i));
                ++i;
            }
            return listLines;
        }

        @Override
        public boolean canSplit(Geometry lineString) {
            if (!(lineString instanceof LineString)) {
                throw new IllegalArgumentException("LineString is spected");
            }
            LineString splitLine = this.getSplitLine().getOriginalSplitLine();
            return splitLine.intersects(lineString);
        }
    }

    private static class MultiLineStringSplitter
    extends AbstractGeometryCollectionSplitter {
        public MultiLineStringSplitter() {
            super(new LineStringSplitter());
        }

        @Override
        protected GeometryCollection buildFromParts(GeometryFactory gf, List<?> parts) {
            LineString[] lines = parts.toArray(new LineString[parts.size()]);
            MultiLineString result = gf.createMultiLineString(lines);
            return result;
        }

        @Override
        public boolean canSplit(Geometry multiLine) {
            if (!(multiLine instanceof MultiLineString)) {
                throw new IllegalArgumentException("LineString is spected");
            }
            LineString splitLine = this.getSplitLine().getOriginalSplitLine();
            return splitLine.intersects(multiLine);
        }
    }

    private static class MultiPolygonSplitter
    extends AbstractGeometryCollectionSplitter {
        public MultiPolygonSplitter() {
            super(new PolygonSplitter());
        }

        @Override
        protected GeometryCollection buildFromParts(GeometryFactory gf, List<?> parts) {
            Polygon[] polygons = parts.toArray(new Polygon[parts.size()]);
            MultiPolygon result = gf.createMultiPolygon(polygons);
            return result;
        }
    }

    private static class PolygonSplitter
    extends AbstractSplitter {
        private List<LinkedHashSet<SplitEdge>> interiorRings = new ArrayList<LinkedHashSet<SplitEdge>>();
        private GeometryFactory geometryFactory;

        private PolygonSplitter() {
        }

        @Override
        public List<Geometry> split(Geometry geomToSplit) {
            assert (geomToSplit instanceof Polygon);
            Polygon polygon = (Polygon)geomToSplit;
            LineString splitLine = this.getSplitLine().getOriginalSplitLine();
            List<Geometry> splitPolygon = SplitUtil.isClosedLine(splitLine) ? this.splitPolygonClosedLines(polygon) : this.splitPolygon(polygon);
            return splitPolygon;
        }

        private List<Geometry> splitPolygon(Polygon aPolygon) {
            this.geometryFactory = aPolygon.getFactory();
            UsefulSplitLineBuilder splitLine = this.getSplitLine();
            SplitGraphBuilder graphBuilder = new SplitGraphBuilder(aPolygon, splitLine);
            graphBuilder.build();
            Graph graph = graphBuilder.getResultantGraph();
            LinkedList<DirectedEdge> directedEdgeList = new LinkedList<DirectedEdge>();
            for (DirectedEdge de : graph.getEdgeEnds()) {
                if (!de.isForward()) continue;
                directedEdgeList.add(de);
            }
            ArrayList<LinkedHashSet<SplitEdge>> allTheRings = new ArrayList<LinkedHashSet<SplitEdge>>();
            List<Object> ringList = new ArrayList();
            ringList = this.findRing(directedEdgeList);
            allTheRings.addAll(ringList);
            ringList = this.checkRings(directedEdgeList);
            allTheRings.addAll(ringList);
            List<LinearRing> nonSplitHoles = this.getNonSplitHoles(graphBuilder);
            List<Geometry> resultingPolygons = this.buildSimplePolygons(allTheRings, nonSplitHoles);
            return resultingPolygons;
        }

        private List<LinearRing> getNonSplitHoles(SplitGraphBuilder graph) {
            ArrayList<LinearRing> nonSplitHoles = new ArrayList<LinearRing>();
            for (LinkedHashSet<SplitEdge> edgeList : this.interiorRings) {
                List<LinearRing> rings = this.buildLinearRing(edgeList);
                nonSplitHoles.addAll(rings);
            }
            Set<LinearRing> holes = graph.getNonSplitRings();
            for (LinearRing hole : holes) {
                nonSplitHoles.add(hole);
            }
            return nonSplitHoles;
        }

        private List<LinkedHashSet<SplitEdge>> findRing(List<DirectedEdge> directedEdgeList) {
            List<LinkedHashSet<SplitEdge>> edgeList = new ArrayList<LinkedHashSet<SplitEdge>>();
            edgeList = this.findIntersectionRings(directedEdgeList, edgeList);
            edgeList = this.findShellRings(directedEdgeList, edgeList);
            this.storeHolesRings(directedEdgeList);
            return edgeList;
        }

        private void storeHolesRings(List<DirectedEdge> directedEdgeList) {
            for (DirectedEdge de : directedEdgeList) {
                DirectedEdge startEdge = de;
                SplitEdge edge = (SplitEdge)startEdge.getEdge();
                if (edge.isVisited() || !edge.isHoleEdge() || !this.isOnlyHoleEdge(edge, directedEdgeList)) continue;
                LinkedHashSet<SplitEdge> interiorRings = this.builtRing(startEdge, 1);
                this.interiorRings.add(interiorRings);
            }
        }

        private List<LinkedHashSet<SplitEdge>> findShellRings(List<DirectedEdge> directedEdgeList, List<LinkedHashSet<SplitEdge>> edgeList) {
            for (DirectedEdge de : directedEdgeList) {
                DirectedEdge startEdge = de;
                SplitEdge edge = (SplitEdge)startEdge.getEdge();
                if (edge.isVisited() || !edge.isShellEdge()) continue;
                edgeList.add(this.builtRing(startEdge, 1));
            }
            return edgeList;
        }

        private List<LinkedHashSet<SplitEdge>> findIntersectionRings(List<DirectedEdge> directedEdgeList, List<LinkedHashSet<SplitEdge>> edgeList) {
            for (DirectedEdge de : directedEdgeList) {
                LinkedHashSet<SplitEdge> result;
                DirectedEdge startEdge = de;
                SplitEdge edge = (SplitEdge)startEdge.getEdge();
                if (edge.isVisited() || !edge.isIntersectionEdge() || !this.isOnlyIntersectionEdge(edge, directedEdgeList) || (result = this.builtRing(startEdge, -1)) == null) continue;
                edgeList.add(result);
            }
            return edgeList;
        }

        private boolean isOnlyHoleEdge(SplitEdge edge, List<DirectedEdge> directedEdgeList) {
            for (DirectedEdge direct : directedEdgeList) {
                SplitEdge possibleEdge = (SplitEdge)direct.getEdge();
                if (!possibleEdge.isIntersectionEdge() || !this.sameCoordinates(edge.getCoordinates(), possibleEdge.getCoordinates())) continue;
                return false;
            }
            return true;
        }

        private boolean isOnlyIntersectionEdge(SplitEdge edge, List<DirectedEdge> directedEdgeList) {
            for (DirectedEdge direct : directedEdgeList) {
                SplitEdge possibleHole = (SplitEdge)direct.getEdge();
                if (!possibleHole.isHoleEdge() || !this.sameCoordinates(edge.getCoordinates(), possibleHole.getCoordinates())) continue;
                return false;
            }
            return true;
        }

        private List<LinkedHashSet<SplitEdge>> checkRings(List<DirectedEdge> directedEdgeList) {
            ArrayList<LinkedHashSet<SplitEdge>> edgeList = new ArrayList<LinkedHashSet<SplitEdge>>();
            for (DirectedEdge de : directedEdgeList) {
                DirectedEdge startEdge = de;
                SplitEdge edge = (SplitEdge)startEdge.getEdge();
                if (edge.isTwiceVisited() || !edge.isIntersectionEdge() || this.intersectionAndHoleSame(directedEdgeList)) continue;
                int direction = this.testDirection(startEdge, -1);
                edgeList.add(this.builtRing(startEdge, direction));
            }
            return edgeList;
        }

        private boolean intersectionAndHoleSame(List<DirectedEdge> directedEdgeList) {
            for (DirectedEdge de : directedEdgeList) {
                SplitEdge edge = (SplitEdge)de.getEdge();
                if (!edge.isIntersectionEdge()) continue;
                for (DirectedEdge direct : directedEdgeList) {
                    SplitEdge possibleHoleOrShell = (SplitEdge)direct.getEdge();
                    if (!possibleHoleOrShell.isHoleEdge() && !possibleHoleOrShell.isShellEdge() || !this.sameCoordinates(edge.getCoordinates(), possibleHoleOrShell.getCoordinates())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean sameCoordinates(Coordinate[] intersection, Coordinate[] hole) {
            if (intersection[0].equals((Object)hole[0]) && intersection[1].equals((Object)hole[1])) {
                return true;
            }
            if (intersection[1].equals((Object)hole[0]) && intersection[0].equals((Object)hole[1])) {
                return true;
            }
            if (intersection[0].equals((Object)hole[1]) && intersection[1].equals((Object)hole[0])) {
                return true;
            }
            return intersection[1].equals((Object)hole[1]) && intersection[0].equals((Object)hole[0]);
        }

        private LinkedHashSet<SplitEdge> builtRing(DirectedEdge startEdge, int direction) {
            DirectedEdge currentDirectedEdge = startEdge;
            DirectedEdge nextDirectedEdge = null;
            LinkedHashSet<SplitEdge> ring = new LinkedHashSet<SplitEdge>();
            while (!this.edgesAreEqual((SplitEdge)startEdge.getEdge(), nextDirectedEdge)) {
                SplitEdge currentEdge = (SplitEdge)currentDirectedEdge.getEdge();
                ring.add(currentEdge);
                currentEdge.countVisited();
                DirectedEdge sym = currentDirectedEdge.getSym();
                SplitGraphNode endNode = (SplitGraphNode)sym.getNode();
                SplitEdgeStar nodeEdges = (SplitEdgeStar)endNode.getEdges();
                nextDirectedEdge = nodeEdges.findClosestEdgeInDirection(sym, direction);
                assert (nextDirectedEdge != null);
                currentDirectedEdge = nextDirectedEdge;
            }
            return ring;
        }

        private int testDirection(DirectedEdge startEdge, int direction) {
            DirectedEdge currentDirectedEdge = startEdge;
            DirectedEdge nextDirectedEdge = null;
            int finalDirection = direction;
            while (!this.edgesAreEqual((SplitEdge)startEdge.getEdge(), nextDirectedEdge)) {
                SplitEdge currentEdge = (SplitEdge)currentDirectedEdge.getEdge();
                if (currentEdge.isTwiceVisited()) {
                    finalDirection = direction == -1 ? 1 : -1;
                    break;
                }
                DirectedEdge sym = currentDirectedEdge.getSym();
                SplitGraphNode endNode = (SplitGraphNode)sym.getNode();
                SplitEdgeStar nodeEdges = (SplitEdgeStar)endNode.getEdges();
                nextDirectedEdge = nodeEdges.findClosestEdgeInDirection(sym, direction);
                assert (nextDirectedEdge != null);
                currentDirectedEdge = nextDirectedEdge;
            }
            return finalDirection;
        }

        private boolean edgesAreEqual(SplitEdge startEdge, DirectedEdge nextDirectedEdge) {
            if (nextDirectedEdge == null) {
                return false;
            }
            return startEdge.equalsCoordinates(nextDirectedEdge.getEdge());
        }

        private List<Geometry> buildSimplePolygons(List<LinkedHashSet<SplitEdge>> allRings, List<LinearRing> nonSplitHoles) {
            ArrayList<Geometry> polygons = new ArrayList<Geometry>(allRings.size());
            for (LinkedHashSet<SplitEdge> edgeList : allRings) {
                Polygon poly;
                Polygon result = poly = this.buildPolygon(edgeList);
                for (LinearRing holeRing : nonSplitHoles) {
                    if (!holeRing.within((Geometry)poly)) continue;
                    Polygon hole = this.geometryFactory.createPolygon(holeRing, null);
                    result = result.difference((Geometry)hole);
                }
                boolean repeated = false;
                for (Geometry insertedPol : polygons) {
                    if (!result.equals(insertedPol)) continue;
                    repeated = true;
                }
                if (repeated) continue;
                int i = 0;
                while (i < result.getNumGeometries()) {
                    polygons.add(result.getGeometryN(i));
                    ++i;
                }
            }
            return polygons;
        }

        private Polygon buildPolygon(LinkedHashSet<SplitEdge> edgeList) {
            Polygon poly;
            LinearRing[] ring;
            LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
            Coordinate[] lastCoordinates = null;
            for (SplitEdge edge : edgeList) {
                Coordinate startPoint;
                Coordinate endPoint;
                Coordinate[] coordinates = edge.getCoordinates();
                if (lastCoordinates != null && !(endPoint = lastCoordinates[lastCoordinates.length - 1]).equals2D(startPoint = coordinates[0])) {
                    coordinates = CoordinateArrays.copyDeep((Coordinate[])coordinates);
                    CoordinateArrays.reverse((Coordinate[])coordinates);
                }
                lastCoordinates = coordinates;
                int i = 0;
                while (i < coordinates.length) {
                    Coordinate coord = coordinates[i];
                    coords.add(coord);
                    ++i;
                }
            }
            Coordinate[] shellCoords = new Coordinate[coords.size()];
            coords.toArray(shellCoords);
            shellCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])shellCoords);
            ArrayList<LinearRing> holeList = new ArrayList<LinearRing>();
            do {
                if ((ring = this.extractInteriorRing(shellCoords))[1] != null) {
                    holeList.add(ring[1]);
                }
                shellCoords = new Coordinate[ring[0].getCoordinates().length];
            } while (this.hasSelfIntersection(shellCoords = ring[0].getCoordinates()));
            if (holeList.isEmpty()) {
                poly = this.geometryFactory.createPolygon(ring[0], null);
            } else {
                LinearRing[] holes = holeList.toArray(new LinearRing[holeList.size()]);
                poly = this.geometryFactory.createPolygon(ring[0], holes);
            }
            return poly;
        }

        private boolean hasSelfIntersection(Coordinate[] shellCoords) {
            int i = 1;
            while (i < shellCoords.length) {
                Coordinate actualCoord = shellCoords[i];
                int j = i + 1;
                while (j < shellCoords.length - 1) {
                    Coordinate selfIntersectionCoord = shellCoords[j];
                    if (actualCoord.equals2D(selfIntersectionCoord)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }

        private LinearRing[] extractInteriorRing(Coordinate[] shellCoords) {
            int selfIntersectionStart = -1;
            int selfIntersectionEnd = -1;
            int i = 1;
            while (i < shellCoords.length && selfIntersectionStart == -1) {
                Coordinate actualCoord = shellCoords[i];
                int j = i + 1;
                while (j < shellCoords.length - 1) {
                    Coordinate selfIntersectionCoord = shellCoords[j];
                    if (actualCoord.equals2D(selfIntersectionCoord)) {
                        selfIntersectionStart = i;
                        selfIntersectionEnd = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            LinearRing[] shellAndHole = new LinearRing[2];
            LinkedList<Coordinate> shell = new LinkedList<Coordinate>();
            LinkedList<Coordinate> hole = new LinkedList<Coordinate>();
            int j = 0;
            while (j < shellCoords.length) {
                shell.add(shellCoords[j]);
                if (j == selfIntersectionStart) {
                    int i2 = selfIntersectionStart;
                    while (i2 <= selfIntersectionEnd) {
                        hole.add(shellCoords[i2]);
                        ++i2;
                    }
                    j = selfIntersectionEnd;
                }
                ++j;
            }
            shellAndHole[0] = this.geometryFactory.createLinearRing(shell.toArray(new Coordinate[shell.size()]));
            shellAndHole[1] = hole.size() != 0 ? this.geometryFactory.createLinearRing(hole.toArray(new Coordinate[hole.size()])) : null;
            return shellAndHole;
        }

        private List<LinearRing> buildLinearRing(LinkedHashSet<SplitEdge> edgeList) {
            LinearRing[] result;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            Coordinate[] lastCoordinates = null;
            for (SplitEdge edge : edgeList) {
                Coordinate startPoint;
                Coordinate endPoint;
                Coordinate[] coordinates = edge.getCoordinates();
                if (lastCoordinates != null && !(endPoint = lastCoordinates[lastCoordinates.length - 1]).equals2D(startPoint = coordinates[0])) {
                    coordinates = CoordinateArrays.copyDeep((Coordinate[])coordinates);
                    CoordinateArrays.reverse((Coordinate[])coordinates);
                }
                lastCoordinates = coordinates;
                int i = 0;
                while (i < coordinates.length) {
                    Coordinate coord = coordinates[i];
                    coords.add(coord);
                    ++i;
                }
            }
            Coordinate[] shellCoords = new Coordinate[coords.size()];
            coords.toArray(shellCoords);
            shellCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])shellCoords);
            ArrayList<LinearRing> holeList = new ArrayList<LinearRing>();
            do {
                if (this.hasSelfIntersection((result = this.extractInteriorRing(shellCoords))[0].getCoordinates())) {
                    if (result[1] != null) {
                        holeList.add(result[1]);
                    }
                    shellCoords = new Coordinate[result[0].getCoordinates().length];
                    shellCoords = result[0].getCoordinates();
                    continue;
                }
                if (result[1] != null && this.hasSelfIntersection(result[1].getCoordinates())) {
                    if (result[0] != null) {
                        holeList.add(result[0]);
                    }
                    shellCoords = new Coordinate[result[1].getCoordinates().length];
                    shellCoords = result[1].getCoordinates();
                    continue;
                }
                shellCoords = new Coordinate[result[0].getCoordinates().length];
                shellCoords = result[0].getCoordinates();
            } while (this.hasSelfIntersection(shellCoords));
            holeList.add(result[0]);
            if (result[1] != null) {
                holeList.add(result[1]);
            }
            return holeList;
        }

        private List<Geometry> splitPolygonClosedLines(Polygon polygon) {
            LineString splitLine = this.getSplitLine().getOriginalSplitLine();
            RingExtractor ringExtractor = new RingExtractor((Geometry)splitLine);
            RingExtractor.ResultRingExtractor data = ringExtractor.processExtraction();
            SplitClosedLines closedLines = new SplitClosedLines(data);
            return closedLines.runClosedLineSplit((Geometry)polygon);
        }

        @Override
        public boolean canSplit(Geometry polygon) {
            if (!(polygon instanceof Polygon)) {
                throw new IllegalArgumentException("Polygon geometry is expected");
            }
            UsefulSplitLineBuilder splitBuilder = this.getSplitLine();
            return SplitUtil.canSplitPolygon(polygon, splitBuilder);
        }
    }

    private static interface SpecificSplitOp {
        public void setSplitLine(UsefulSplitLineBuilder var1);

        public boolean canSplit(Geometry var1);

        public List<Geometry> split(Geometry var1);

        public UsefulSplitLineBuilder getSplitLine();
    }
}

