/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryList;
import eu.udig.tools.geometry.split.AdaptedPolygon;
import eu.udig.tools.geometry.split.Graph;
import eu.udig.tools.geometry.split.SplitEdge;
import eu.udig.tools.geometry.split.UsefulSplitLineBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

class SplitGraphBuilder {
    private static final Logger LOGGER = Logger.getLogger(SplitGraphBuilder.class.getName());
    private final Polygon polygon;
    private final UsefulSplitLineBuilder usefulSplitLineBuilder;
    private Graph graph = new Graph();

    public String toString() {
        return String.valueOf(this.usefulSplitLineBuilder.getClass().getName()) + ":" + this.usefulSplitLineBuilder.toString();
    }

    public SplitGraphBuilder(Polygon polygon, UsefulSplitLineBuilder splitLine) {
        this.polygon = polygon;
        LOGGER.fine("Input polygon: " + polygon.toText());
        LOGGER.fine("Input split line: " + splitLine.getOriginalSplitLine().toText());
        this.usefulSplitLineBuilder = splitLine;
    }

    public SplitGraphBuilder build() {
        this.polygon.normalize();
        this.usefulSplitLineBuilder.build(this.polygon);
        Geometry utilSplitLine = this.usefulSplitLineBuilder.getResultSplitLine();
        AdaptedPolygon adaptedPolygon = this.usefulSplitLineBuilder.getAdaptedPolygon();
        LOGGER.fine("Adapted Polygon: " + adaptedPolygon.asPolygon().toText());
        LOGGER.fine("Util split line: " + utilSplitLine.toText());
        this.buildGraph(utilSplitLine, adaptedPolygon.asPolygon());
        return this;
    }

    private void buildGraph(Geometry utilSplitLine, Polygon polygon) {
        List<Geometry> shellList = this.makeShellGeometryList(polygon, utilSplitLine);
        this.addShellInCW(shellList);
        Set<LinearRing> nonSplitRings = this.usefulSplitLineBuilder.getNonSplitRings();
        List<LineString> splitHoleList = this.makeValidSplitHoles(polygon, nonSplitRings);
        List<Geometry> holesList = this.makeHoleGeometryList(splitHoleList, utilSplitLine);
        this.addHolesInCCW(holesList);
        this.addSplitLineIntoGraph(utilSplitLine, polygon, splitHoleList);
    }

    private void addSplitLineIntoGraph(Geometry utilSplitLine, Polygon polygon, List<LineString> holesList) {
        Geometry intersectingLineStrings = utilSplitLine.intersection((Geometry)polygon);
        if (intersectingLineStrings.getNumGeometries() > 1) {
            intersectingLineStrings = this.filterLineString(intersectingLineStrings);
        }
        MultiLineString holeCollection = intersectingLineStrings.getFactory().createMultiLineString(holesList.toArray(new LineString[holesList.size()]));
        Geometry holeGeometries = holeCollection.difference(utilSplitLine);
        this.insertEdge(intersectingLineStrings, holeGeometries, 1, 0, 0);
    }

    private Geometry filterLineString(Geometry geometry) {
        ArrayList<Geometry> filteredLines = new ArrayList<Geometry>();
        int i = 0;
        while (i < geometry.getNumGeometries()) {
            Geometry possibleLine = geometry.getGeometryN(i);
            if ((possibleLine instanceof LineString || possibleLine instanceof MultiLineString) && possibleLine.getLength() > 1.0E-4) {
                filteredLines.add(possibleLine);
            }
            ++i;
        }
        GeometryFactory gf = geometry.getFactory();
        return gf.buildGeometry(filteredLines);
    }

    private void addHolesInCCW(List<Geometry> holesList) {
        this.graph.addEdges(holesList, 1, 0, 2);
    }

    private void addShellInCW(List<Geometry> shellList) {
        this.graph.addEdges(shellList, 1, 2, 0);
    }

    private List<Geometry> makeShellGeometryList(Polygon polygon, Geometry utilSplitLine) {
        Geometry shellDiff = polygon.getExteriorRing().difference(utilSplitLine);
        List<Geometry> geometriesBelongShell = new ArrayList<Geometry>();
        geometriesBelongShell.add(shellDiff);
        Geometry intersectResult = polygon.getExteriorRing().intersection(utilSplitLine);
        geometriesBelongShell = this.addLinesInCommon(intersectResult, geometriesBelongShell);
        return geometriesBelongShell;
    }

    private List<Geometry> addLinesInCommon(Geometry intersectResult, List<Geometry> geometryList) {
        if (intersectResult instanceof GeometryCollection) {
            int i = 0;
            while (i < intersectResult.getNumGeometries()) {
                Geometry part = intersectResult.getGeometryN(i);
                if (part instanceof LineString || part instanceof MultiLineString) {
                    geometryList.add(part);
                }
                ++i;
            }
        } else if (intersectResult instanceof LineString || intersectResult instanceof MultiLineString) {
            geometryList.add(intersectResult);
        }
        return geometryList;
    }

    private List<Geometry> makeHoleGeometryList(List<LineString> polygonHolesArray, Geometry utilSplitLine) {
        GeometryFactory factory = this.polygon.getFactory();
        MultiLineString holeCollection = factory.createMultiLineString(polygonHolesArray.toArray(new LineString[polygonHolesArray.size()]));
        Geometry nodedHoles = holeCollection.difference(utilSplitLine);
        List<Geometry> geometriesBelongHole = new ArrayList<Geometry>();
        geometriesBelongHole.add(nodedHoles);
        Geometry intersectionResult = holeCollection.intersection(utilSplitLine);
        geometriesBelongHole = this.addLinesInCommon(intersectionResult, geometriesBelongHole);
        return geometriesBelongHole;
    }

    private List<LineString> makeValidSplitHoles(Polygon polygon, Set<LinearRing> nonSplitRings) {
        GeometryList<LineString> holesArray = new GeometryList<LineString>();
        int i = 0;
        while (i < polygon.getNumInteriorRing()) {
            LineString hole = polygon.getInteriorRingN(i);
            if (!nonSplitRings.contains(hole)) {
                holesArray.add(hole);
            }
            ++i;
        }
        return holesArray;
    }

    private void insertEdge(Geometry intersectingLineStrings, Geometry holeGeometries, int onLoc, int leftLoc, int rightLoc) {
        int i = 0;
        while (i < intersectingLineStrings.getNumGeometries()) {
            Geometry intersectingSegment = intersectingLineStrings.getGeometryN(i);
            if (intersectingSegment.getNumPoints() == 2 && !holeGeometries.isEmpty()) {
                intersectingSegment = this.adjustSegmentToHoleDirection(intersectingSegment, holeGeometries);
            }
            Coordinate[] coords = intersectingSegment.getCoordinates();
            int j = 0;
            while (j < coords.length - 1) {
                SplitEdge edge = SplitEdge.newInstance(coords[j], coords[j + 1], onLoc, leftLoc, rightLoc);
                this.graph.addEdge(edge);
                ++j;
            }
            ++i;
        }
    }

    private LineString adjustSegmentToHoleDirection(Geometry intersectingSegment, Geometry holeGeometries) {
        Geometry intersection;
        LineString intersectedHole = this.intersectionHole(intersectingSegment, holeGeometries);
        if (intersectedHole == null) {
            return (LineString)intersectingSegment;
        }
        Coordinate secondIntersection = null;
        Coordinate firstIntersection = null;
        int j = -1;
        Coordinate[] holeCoords = intersectedHole.getCoordinates();
        LinkedList<Coordinate> ring = new LinkedList<Coordinate>();
        int i = 0;
        while (i < holeCoords.length - 1) {
            Geometry intersection2 = this.intersectionWithSegment(holeCoords, i, intersectingSegment);
            if (intersection2 instanceof Point && firstIntersection == null) {
                firstIntersection = intersection2.getCoordinate();
                ring.add(firstIntersection);
                ring.add(holeCoords[i + 1]);
                j = i + 1;
                break;
            }
            ++i;
        }
        assert (firstIntersection != null && j != -1);
        while (true) {
            if ((intersection = this.intersectionWithSegment(holeCoords, j, intersectingSegment)) instanceof Point && !intersection.getCoordinate().equals2D(firstIntersection)) break;
            ring.add(holeCoords[j + 1]);
            ++j;
        }
        secondIntersection = intersection.getCoordinate();
        ring.add(secondIntersection);
        ring.add(firstIntersection);
        assert (secondIntersection != null);
        GeometryFactory factory = intersectingSegment.getFactory();
        LinearRing linearRing = factory.createLinearRing(ring.toArray(new Coordinate[ring.size()]));
        LineString adjustedSegment = null;
        adjustedSegment = this.isCW(linearRing) ? this.createAdjustedSegment(firstIntersection, secondIntersection, factory) : this.createAdjustedSegment(secondIntersection, firstIntersection, factory);
        return adjustedSegment;
    }

    private LineString intersectionHole(Geometry splitLineSegment, Geometry holeGeometries) {
        List<LineString> holeList = this.convertHolesGeometriesToHoleList(holeGeometries);
        LineString intersectedHole = null;
        for (LineString hole : holeList) {
            Geometry intersectionWithHole = splitLineSegment.intersection((Geometry)hole);
            if (intersectionWithHole.getNumGeometries() != 2) continue;
            intersectedHole = hole;
        }
        return intersectedHole;
    }

    private List<LineString> convertHolesGeometriesToHoleList(Geometry holeGeometries) {
        assert (holeGeometries != null);
        ArrayList<LineString> holeList = new ArrayList<LineString>(holeGeometries.getNumGeometries());
        int i = 0;
        while (i < holeGeometries.getNumGeometries()) {
            LineString hole = (LineString)holeGeometries.getGeometryN(i);
            holeList.add(hole);
            ++i;
        }
        return holeList;
    }

    private LineString createAdjustedSegment(Coordinate firstIntersection, Coordinate secondIntersection, GeometryFactory factory) {
        Coordinate[] adjustedSegmentCoords = new Coordinate[]{firstIntersection, secondIntersection};
        return factory.createLineString(adjustedSegmentCoords);
    }

    private boolean isCW(LinearRing linearRing) {
        Coordinate[] ringCoord = linearRing.getCoordinates();
        return !CGAlgorithms.isCCW((Coordinate[])ringCoord);
    }

    private Geometry intersectionWithSegment(Coordinate[] holeCoords, int i, Geometry intersectingSegment) {
        Coordinate[] holeSegmentCoord = new Coordinate[]{holeCoords[i], holeCoords[i + 1]};
        GeometryFactory geomFact = intersectingSegment.getFactory();
        LineString holeSegment = geomFact.createLineString(holeSegmentCoord);
        Geometry intersection = holeSegment.intersection(intersectingSegment);
        return intersection;
    }

    public Set<LinearRing> getNonSplitRings() {
        return this.usefulSplitLineBuilder.getNonSplitRings();
    }

    public Graph getResultantGraph() {
        return this.graph;
    }
}

