/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.split.RingExtractor;
import eu.udig.tools.geometry.split.SplitStrategy;
import java.util.ArrayList;
import java.util.List;

final class SplitClosedLines {
    Geometry remainingLine = null;
    List<Geometry> rings = null;
    List<Geometry> piecesFrom = null;

    public SplitClosedLines(RingExtractor.ResultRingExtractor inputData) {
        this.remainingLine = inputData.getRemainingLine();
        this.rings = inputData.getRings();
    }

    public List<Geometry> runClosedLineSplit(Geometry polygon) {
        this.piecesFrom = new ArrayList<Geometry>();
        Geometry result = this.processClosedLines(polygon);
        this.piecesFrom.addAll(this.processRemainingLine(result));
        return this.piecesFrom;
    }

    private Geometry processClosedLines(Geometry polygon) {
        Geometry result = polygon;
        GeometryFactory gf = polygon.getFactory();
        for (Geometry ring : this.rings) {
            Polygon polygonArea = gf.createPolygon((LinearRing)ring, null);
            result = result.difference((Geometry)polygonArea);
            Geometry areaIntersection = polygonArea.intersection(polygon);
            int i = 0;
            while (i < areaIntersection.getNumGeometries()) {
                this.piecesFrom.add(areaIntersection.getGeometryN(i));
                ++i;
            }
        }
        return result;
    }

    private List<Geometry> processRemainingLine(Geometry geomToSplit) {
        ArrayList<Geometry> splitResult = new ArrayList<Geometry>();
        ArrayList<Geometry> inputGeometries = new ArrayList<Geometry>();
        Geometry line = this.remainingLine;
        int j = 0;
        while (j < geomToSplit.getNumGeometries()) {
            inputGeometries.add(geomToSplit.getGeometryN(j));
            ++j;
        }
        int i = 0;
        while (i < line.getNumGeometries()) {
            splitResult.clear();
            SplitStrategy strategy = new SplitStrategy((LineString)line.getGeometryN(i));
            for (Geometry inputGeom : inputGeometries) {
                if (strategy.canSplit(inputGeom)) {
                    splitResult.addAll(strategy.split(inputGeom));
                    continue;
                }
                splitResult.add(inputGeom);
            }
            inputGeometries.clear();
            inputGeometries.addAll(splitResult);
            ++i;
        }
        return inputGeometries;
    }
}

