/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import eu.udig.tools.geometry.split.SplitStrategy;
import eu.udig.tools.geometry.split.VertexStrategy;
import java.util.ArrayList;
import java.util.List;

public final class SplitBuilder {
    private List<Geometry> originalGeometryList;
    private List<Geometry> splitResultList;
    private List<Geometry> neighbourResultList;
    private LineString splitLine;
    private SplitStrategy splitStrategy;

    private SplitBuilder() {
    }

    public static SplitBuilder newInstansceUsingSplitLine(LineString splitLine) {
        assert (splitLine != null) : "can't be null";
        SplitBuilder sb = new SplitBuilder();
        sb.splitLine = splitLine;
        sb.splitStrategy = new SplitStrategy(splitLine);
        sb.splitResultList = new ArrayList<Geometry>();
        sb.neighbourResultList = new ArrayList<Geometry>();
        sb.originalGeometryList = new ArrayList<Geometry>();
        return sb;
    }

    public SplitBuilder buildEntireProcess(List<Geometry> allGeometries) {
        ArrayList<Geometry> goingToSplit = new ArrayList<Geometry>();
        ArrayList<Geometry> goingToNeighbour = new ArrayList<Geometry>();
        for (Geometry geom : allGeometries) {
            if (this.canSplit(geom)) {
                goingToSplit.add(geom);
                continue;
            }
            goingToNeighbour.add(geom);
        }
        this.buildSplit(goingToSplit);
        this.buildNeighbours(goingToNeighbour);
        return this;
    }

    public SplitBuilder buildSplit(List<Geometry> splitGeometries) {
        for (Geometry geom : splitGeometries) {
            if (!this.canSplit(geom)) continue;
            this.splitResultList.addAll(this.split(geom));
        }
        return this;
    }

    public List<Geometry> getSplitResult() {
        return this.splitResultList;
    }

    private boolean canSplit(Geometry geom) {
        return this.splitStrategy.canSplit(geom);
    }

    private List<Geometry> split(Geometry geomToSplit) {
        this.originalGeometryList.add(geomToSplit);
        return this.splitStrategy.split(geomToSplit);
    }

    public SplitBuilder buildNeighbours(List<Geometry> neighbourGeometries) {
        for (Geometry geom : neighbourGeometries) {
            if (!this.requireVertex(geom)) continue;
            this.neighbourResultList.add(this.addVertexToNeighbour(geom));
        }
        return this;
    }

    public List<Geometry> getNeighbourResult() {
        return this.neighbourResultList;
    }

    private boolean requireVertex(Geometry geomToAddVertex) {
        for (Geometry geomNeighbor : this.originalGeometryList) {
            if (!geomToAddVertex.touches(geomNeighbor)) continue;
            return true;
        }
        return false;
    }

    private Geometry addVertexToNeighbour(Geometry geomToAddVertex) {
        return VertexStrategy.addIntersectionVertex(geomToAddVertex, (Geometry)this.splitLine, this.originalGeometryList);
    }
}

