/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import eu.udig.tools.geometry.merge.MergeStrategy;
import eu.udig.tools.geometry.split.SplitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class RingExtractor {
    private GeometryFactory gf = null;
    private Geometry line = null;

    public RingExtractor(Geometry line) {
        Geometry linegeom = line.union();
        Coordinate[] coordinates = linegeom.getCoordinates();
        coordinates = CoordinateArrays.removeRepeatedPoints((Coordinate[])coordinates);
        this.line = linegeom.getFactory().createLineString(coordinates);
        this.gf = line.getFactory();
    }

    public ResultRingExtractor processExtraction() {
        assert (this.line != null) : "the line can't be null";
        assert (this.gf != null) : "the geometry factory can't be null";
        ArrayList<Geometry> ringList = new ArrayList<Geometry>();
        Geometry multiLines = this.line.union();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(multiLines);
        Collection polyCollection = polygonizer.getPolygons();
        for (Polygon pol : polyCollection) {
            Coordinate[] polCoord = pol.getExteriorRing().getCoordinates();
            LinearRing polygonRing = this.gf.createLinearRing(polCoord);
            ringList.add((Geometry)polygonRing);
        }
        Geometry result = this.getRemainingLine(this.line.getCoordinates(), ringList);
        ResultRingExtractor outputData = new ResultRingExtractor(result, ringList);
        return outputData;
    }

    private Geometry getRemainingLine(Coordinate[] originalCoord, List<Geometry> ringList) {
        LinkedList<Geometry> segmentsToAdd = new LinkedList<Geometry>();
        Geometry result = this.line;
        for (Geometry ring : ringList) {
            result = result.difference(ring);
        }
        result = SplitUtil.buildLineUnion(result);
        int i = 0;
        while (i < originalCoord.length - 1) {
            Coordinate[] segCoords = new Coordinate[]{originalCoord[i], originalCoord[i + 1]};
            LineString segmentToTest = this.gf.createLineString(segCoords);
            int j = i + 1;
            while (j < originalCoord.length - 1) {
                Coordinate[] testCoord = new Coordinate[]{originalCoord[j], originalCoord[j + 1]};
                LineString eachSegment = this.gf.createLineString(testCoord);
                if (segmentToTest.intersects((Geometry)eachSegment) && segmentToTest.intersection((Geometry)eachSegment) instanceof LineString) {
                    segmentsToAdd.add(segmentToTest.intersection((Geometry)eachSegment));
                }
                ++j;
            }
            ++i;
        }
        if (segmentsToAdd.size() != 0) {
            result = this.nodSegments(segmentsToAdd, ringList, result);
        }
        return result;
    }

    private Geometry nodSegments(List<Geometry> segmentsToAdd, List<Geometry> ringList, Geometry actualResultLine) {
        Geometry result = actualResultLine;
        for (Geometry segment : segmentsToAdd) {
            assert (segment.getCoordinates().length == 2) : "the segment should have 2 coordinates.";
            for (Geometry ring : ringList) {
                if (!ring.contains(segment) && !ring.intersects(segment)) continue;
                result = MergeStrategy.mergeOp(result, segment);
            }
        }
        return result;
    }

    public class ResultRingExtractor {
        private Geometry remainingLine;
        private List<Geometry> rings;

        public ResultRingExtractor(Geometry remainingLine, List<Geometry> rings) {
            this.remainingLine = remainingLine;
            this.rings = rings;
        }

        public Geometry getRemainingLine() {
            return this.remainingLine;
        }

        public List<Geometry> getRings() {
            return this.rings;
        }
    }
}

