/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import eu.udig.tools.geometry.internal.util.GeometryList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class LineBoundaryIntersectionAssociation {
    private IntersectCursor cursor = IntersectCursor.NULL;
    private List<SplitLineSegmentIntersectionNode> splitLineSegmentWithIntersectionList = new LinkedList<SplitLineSegmentIntersectionNode>();
    private Map<Point, IntersectionLink> intersectionLinks = new LinkedHashMap<Point, IntersectionLink>();
    private GeometryFactory geomFactory;
    private IntersectCursor backCursor;

    public LineBoundaryIntersectionAssociation(Coordinate[] lineCoords, LinearRing ring) {
        this.geomFactory = ring.getFactory();
        this.splitLineSegmentWithIntersectionList = this.makeIntersectionSegmentList(lineCoords, ring);
    }

    private List<SplitLineSegmentIntersectionNode> makeIntersectionSegmentList(Coordinate[] splitLine, LinearRing ring) {
        this.splitLineSegmentWithIntersectionList = new ArrayList<SplitLineSegmentIntersectionNode>();
        int i = 0;
        while (i < splitLine.length - 1) {
            LineString lineSegment = this.geomFactory.createLineString(new Coordinate[]{splitLine[i], splitLine[i + 1]});
            GeometryList<Point> segmentIntersectionList = new GeometryList<Point>();
            List<LineString> ringSegmentList = this.ringToSegmentList(ring);
            for (LineString ringSegment : ringSegmentList) {
                Geometry intersectionGeom = lineSegment.intersection((Geometry)ringSegment);
                if (!(intersectionGeom instanceof Point)) continue;
                IntersectionLink link = new IntersectionLink(lineSegment, ringSegment, (Point)intersectionGeom);
                this.intersectionLinks.put(link.getIntersection(), link);
                if (segmentIntersectionList.contains(intersectionGeom)) continue;
                segmentIntersectionList.add((Point)intersectionGeom);
            }
            SplitLineSegmentIntersectionNode lineSegmentIntersection = new SplitLineSegmentIntersectionNode(lineSegment, segmentIntersectionList);
            this.splitLineSegmentWithIntersectionList.add(lineSegmentIntersection);
            ++i;
        }
        return this.splitLineSegmentWithIntersectionList;
    }

    private List<LineString> ringToSegmentList(LinearRing ring) {
        GeometryList<LineString> segmentList = new GeometryList<LineString>();
        Coordinate[] ringCoords = ring.getCoordinates();
        int i = 0;
        while (i < ringCoords.length - 1) {
            LineString segment = this.geomFactory.createLineString(new Coordinate[]{ringCoords[i], ringCoords[i + 1]});
            segmentList.add(segment);
            ++i;
        }
        return segmentList;
    }

    public void moveFirstIntersection() {
        this.backCursor = this.cursor = IntersectCursor.NULL;
        int segmentPosition = 0;
        while (segmentPosition < this.splitLineSegmentWithIntersectionList.size()) {
            SplitLineSegmentIntersectionNode segmentNode = this.splitLineSegmentWithIntersectionList.get(segmentPosition);
            if (!segmentNode.getIntersectionList().isEmpty()) {
                Point point = segmentNode.searchNearestIntersection();
                IntersectionLink link = this.intersectionLinks.get(point);
                LineString ringSegment = link.getRingSegment();
                this.cursor = new IntersectCursor();
                this.cursor.setCurrentIntersection(segmentPosition, point, ringSegment);
                break;
            }
            ++segmentPosition;
        }
    }

    public void moveBeforeFirst() {
        this.cursor = IntersectCursor.NULL;
    }

    public void moveNextIntersection() {
        if (this.splitLineSegmentWithIntersectionList.isEmpty()) {
            this.cursor = IntersectCursor.NULL;
            return;
        }
        if (this.cursor == IntersectCursor.NULL) {
            this.moveFirstIntersection();
            return;
        }
        this.backCursor = (IntersectCursor)this.cursor.clone();
        int lastVisitedSegment = this.cursor.getSegmentPosition();
        Point lastVistedIntersection = this.cursor.getIntersectionPoint();
        SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(lastVisitedSegment);
        Point intersectionFound = node.searchNearestIntersectionFrom(lastVistedIntersection);
        if (intersectionFound != null) {
            IntersectionLink link = this.intersectionLinks.get(intersectionFound);
            LineString ringSegment = link.getRingSegment();
            this.cursor.setCurrentIntersection(lastVisitedSegment, intersectionFound, ringSegment);
            return;
        }
        int i = lastVisitedSegment + 1;
        while (i < this.splitLineSegmentWithIntersectionList.size()) {
            node = this.splitLineSegmentWithIntersectionList.get(i);
            for (Point currentIntersection : node.getIntersectionList()) {
                if (currentIntersection == null || lastVistedIntersection.equals((Geometry)currentIntersection)) continue;
                IntersectionLink link = this.intersectionLinks.get(currentIntersection);
                LineString ringSegment = link.getRingSegment();
                this.cursor.setCurrentIntersection(i, currentIntersection, ringSegment);
                return;
            }
            ++i;
        }
        this.cursor = IntersectCursor.NULL;
    }

    public void moveBackIntersection() {
        assert (this.backCursor != IntersectCursor.NULL) : "illegal state!. It could occurs if the client call this method without a previous calling to the moveNextIntersection() method ";
        this.cursor = this.backCursor;
        this.backCursor = IntersectCursor.NULL;
    }

    public LineString getRingSegment() {
        return this.cursor.getIntersectedRingSegment();
    }

    public Coordinate getIntersection() {
        return this.cursor.getIntersectionPoint().getCoordinate();
    }

    public int getIntersectionSegmentPosition() {
        return this.cursor.getSegmentPosition();
    }

    public int countIntersections() {
        GeometryList intersectionList = new GeometryList();
        for (SplitLineSegmentIntersectionNode lineIntersection : this.splitLineSegmentWithIntersectionList) {
            for (Point point : lineIntersection.getIntersectionList()) {
                if (intersectionList.contains(point)) continue;
                intersectionList.add(point);
            }
        }
        return intersectionList.size();
    }

    public int getVisitedIntersection() {
        return this.cursor.getVisitedIntersection();
    }

    public LineString buildLineBetweenIntersection(int firstSegmentPosition, Coordinate firstIntersection, int lastSegmentPosition, Coordinate secondIntersection) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(firstIntersection);
        SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(firstSegmentPosition);
        assert (lastSegmentPosition < this.splitLineSegmentWithIntersectionList.size());
        int i = firstSegmentPosition;
        while (i <= lastSegmentPosition) {
            node = this.splitLineSegmentWithIntersectionList.get(i);
            Coordinate[] vertexList = node.getSegment().getCoordinates();
            int j = 0;
            while (j < vertexList.length) {
                Coordinate curVertex = vertexList[j];
                if (((Coordinate)coordinates.get(0)).distance(curVertex) < ((Coordinate)coordinates.get(0)).distance(secondIntersection) && !coordinates.contains(curVertex)) {
                    coordinates.add(curVertex);
                }
                ++j;
            }
            ++i;
        }
        if (!coordinates.contains(secondIntersection)) {
            coordinates.add(secondIntersection);
        }
        Coordinate[] coordsArray = coordinates.toArray(new Coordinate[coordinates.size()]);
        LineString newLine = this.geomFactory.createLineString(coordsArray);
        return newLine;
    }

    public LineString buildLineBetweenIntersectionSegments(int firstSegmentPosition, int lastSegmentPosition) {
        LinkedList<Coordinate> coordinatList = new LinkedList<Coordinate>();
        assert (firstSegmentPosition <= lastSegmentPosition && lastSegmentPosition < this.splitLineSegmentWithIntersectionList.size());
        int i = firstSegmentPosition;
        while (i <= lastSegmentPosition) {
            SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(i);
            Coordinate[] vertexList = node.getSegment().getCoordinates();
            int j = 0;
            while (j < vertexList.length) {
                if (!coordinatList.contains(vertexList[j])) {
                    coordinatList.add(vertexList[j]);
                }
                ++j;
            }
            ++i;
        }
        Coordinate[] coordinates = coordinatList.toArray(new Coordinate[coordinatList.size()]);
        LineString splitLineFragment = this.geomFactory.createLineString(coordinates);
        return splitLineFragment;
    }

    public LineString buildLineBetweenIntersectionPoints(int firstSegmentPosition, Coordinate firstIntersection, int lastSegmentPosition, Coordinate lastIntersection) {
        assert (firstSegmentPosition <= lastSegmentPosition && lastSegmentPosition < this.splitLineSegmentWithIntersectionList.size());
        LinkedList<Coordinate> coordinatList = new LinkedList<Coordinate>();
        if (firstSegmentPosition == lastSegmentPosition) {
            List<Coordinate> lineFragment = this.truncateSegmentBetween(firstSegmentPosition, firstIntersection, lastIntersection);
            coordinatList.addAll(lineFragment);
        } else {
            List<Coordinate> firstLineFragment = this.trunkateHeaderSegment(firstSegmentPosition, firstIntersection);
            coordinatList.addAll(firstLineFragment);
            int i = firstSegmentPosition + 1;
            while (i < lastSegmentPosition) {
                SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(i);
                Coordinate[] vertexList = node.getSegment().getCoordinates();
                int j = 0;
                while (j < vertexList.length) {
                    if (!coordinatList.contains(vertexList[j])) {
                        coordinatList.add(vertexList[j]);
                    }
                    ++j;
                }
                ++i;
            }
            List<Coordinate> lastLineFragment = this.trunkateTailSegment(lastSegmentPosition, lastIntersection);
            for (Coordinate coordinate : lastLineFragment) {
                if (coordinatList.contains(coordinate)) continue;
                coordinatList.add(coordinate);
            }
        }
        Coordinate[] coordinates = coordinatList.toArray(new Coordinate[coordinatList.size()]);
        LineString splitLineFragment = this.geomFactory.createLineString(coordinates);
        return splitLineFragment;
    }

    private List<Coordinate> truncateSegmentBetween(int firstSegmentPosition, Coordinate firstIntersection, Coordinate lastIntersection) {
        LinkedList<Coordinate> newLine = new LinkedList<Coordinate>();
        SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(firstSegmentPosition);
        Coordinate[] lineFragment = node.getSegment().getCoordinates();
        double firstIntersectDistance = lineFragment[0].distance(firstIntersection);
        double lastIntersectDistance = lineFragment[0].distance(lastIntersection);
        newLine.add(firstIntersection);
        int i = 0;
        while (i < lineFragment.length) {
            double currentDistance = lineFragment[0].distance(lineFragment[i]);
            if (firstIntersectDistance < currentDistance && currentDistance < lastIntersectDistance) {
                newLine.add(lineFragment[i]);
            }
            ++i;
        }
        newLine.add(lastIntersection);
        return newLine;
    }

    private List<Coordinate> trunkateHeaderSegment(int firstSegmentPosition, Coordinate firstIntersection) {
        LinkedList<Coordinate> newLine = new LinkedList<Coordinate>();
        SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(firstSegmentPosition);
        Coordinate[] lineFragment = node.getSegment().getCoordinates();
        double vertexDistance = lineFragment[0].distance(firstIntersection);
        int found = -1;
        int i = 0;
        while (i < lineFragment.length) {
            double currentDistance = lineFragment[0].distance(lineFragment[i]);
            if (currentDistance > vertexDistance) {
                found = i;
                break;
            }
            ++i;
        }
        if (found != -1) {
            newLine.add(firstIntersection);
            i = found;
            while (i < lineFragment.length) {
                newLine.add(lineFragment[i]);
                ++i;
            }
        } else {
            newLine.add(firstIntersection);
        }
        return newLine;
    }

    private List<Coordinate> trunkateTailSegment(int lastSegmentPosition, Coordinate lastIntersection) {
        LinkedList<Coordinate> newLine = new LinkedList<Coordinate>();
        SplitLineSegmentIntersectionNode node = this.splitLineSegmentWithIntersectionList.get(lastSegmentPosition);
        Coordinate[] lineFragment = node.getSegment().getCoordinates();
        double vertexDistance = lineFragment[0].distance(lastIntersection);
        int found = -1;
        int i = 0;
        while (i < lineFragment.length) {
            double currentDistance = lineFragment[0].distance(lineFragment[i]);
            if (!(currentDistance < vertexDistance)) {
                found = i;
                break;
            }
            newLine.add(lineFragment[i]);
            ++i;
        }
        if (found != -1) {
            newLine.add(lastIntersection);
        } else {
            newLine.add(lastIntersection);
        }
        return newLine;
    }

    public LineString getSplitLineSegment(int segmentPosition) {
        SplitLineSegmentIntersectionNode segmentNode = this.splitLineSegmentWithIntersectionList.get(segmentPosition);
        return segmentNode.getSegment();
    }

    public int size() {
        return this.splitLineSegmentWithIntersectionList.size();
    }

    public static class IntersectCursor
    implements Cloneable {
        private Point intersectionPoint = null;
        private int segmentPosition = -1;
        private LineString ringSegment = null;
        private int visitedIntersection = 0;
        public static IntersectCursor NULL = new IntersectCursor();

        public void setCurrentIntersection(int i, Point intersectionPoint, LineString ringSegment) {
            this.setState(i, intersectionPoint, ringSegment);
        }

        public Object clone() {
            IntersectCursor duplicated = null;
            try {
                duplicated = (IntersectCursor)super.clone();
                duplicated.intersectionPoint = (Point)this.intersectionPoint.clone();
                duplicated.ringSegment = (LineString)this.ringSegment.clone();
                duplicated.segmentPosition = this.segmentPosition;
                duplicated.visitedIntersection = this.visitedIntersection;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return duplicated;
        }

        public int getVisitedIntersection() {
            return this.visitedIntersection;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntersectCursor other = (IntersectCursor)obj;
            if (this.intersectionPoint == null ? other.intersectionPoint != null : !this.intersectionPoint.equals((Geometry)other.intersectionPoint)) {
                return false;
            }
            if (this.ringSegment == null ? other.ringSegment != null : !this.ringSegment.equals((Geometry)other.ringSegment)) {
                return false;
            }
            return this.segmentPosition == other.segmentPosition;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.intersectionPoint == null ? 0 : this.intersectionPoint.hashCode());
            result = 31 * result + (this.ringSegment == null ? 0 : this.ringSegment.hashCode());
            result = 31 * result + this.segmentPosition;
            result = 31 * result + this.visitedIntersection;
            return result;
        }

        public Point getIntersectionPoint() {
            return this.intersectionPoint;
        }

        public int getSegmentPosition() {
            return this.segmentPosition;
        }

        public LineString getIntersectedRingSegment() {
            return this.ringSegment;
        }

        private void setState(int segmentPosition, Point intersectionPoint, LineString intersectedRingSegment) {
            assert (segmentPosition >= 0 && intersectionPoint != null && intersectedRingSegment != null);
            this.segmentPosition = segmentPosition;
            this.intersectionPoint = intersectionPoint;
            this.ringSegment = intersectedRingSegment;
            ++this.visitedIntersection;
        }
    }

    private class IntersectionLink {
        private final LineString splitLineSegment;
        private final LineString ringSegment;
        private final Point intersection;

        public IntersectionLink(LineString splitSegment, LineString ringSegment, Point intersection) {
            assert (splitSegment != null && ringSegment != null && intersection != null);
            this.splitLineSegment = splitSegment;
            this.ringSegment = ringSegment;
            this.intersection = intersection;
        }

        public String toString() {
            return "IntersectionLink( SplitLine: " + this.splitLineSegment + " - RingSegment: " + this.ringSegment + " - Intersection: " + this.intersection + ")";
        }

        public LineString getRingSegment() {
            return this.ringSegment;
        }

        public Point getIntersection() {
            return this.intersection;
        }
    }

    private static class SplitLineSegmentIntersectionNode {
        private LineString segment = null;
        private List<Point> intersectionList = null;
        private GeometryFactory geometryFactory;

        public SplitLineSegmentIntersectionNode(LineString segment, List<Point> intersectionList) {
            this.geometryFactory = segment.getFactory();
            this.segment = segment;
            this.intersectionList = this.sortIntersectionByDistance(intersectionList);
        }

        public String toString() {
            StringBuilder str = new StringBuilder(this.segment.toText());
            str.append(" [");
            for (Point point : this.intersectionList) {
                str.append(point.toText());
                str.append(" ");
            }
            str.append("]");
            return str.toString();
        }

        public LineString getSegment() {
            return this.segment;
        }

        public List<Point> getIntersectionList() {
            return this.intersectionList;
        }

        private List<Point> sortIntersectionByDistance(List<Point> unSortedList) {
            if (unSortedList.size() <= 1) {
                return unSortedList;
            }
            List<Point> sortedList = new GeometryList<Point>();
            sortedList.add(0, unSortedList.get(0));
            Point firstVertex = this.geometryFactory.createPoint(this.segment.getCoordinateN(0));
            int i = 1;
            while (i < unSortedList.size()) {
                Point curPoint = unSortedList.get(i);
                double newDistance = DistanceOp.distance((Geometry)firstVertex, (Geometry)curPoint);
                assert (newDistance >= 0.0);
                boolean wasInserted = false;
                int j = 0;
                while (j < sortedList.size()) {
                    Point sortedPoint = (Point)sortedList.get(j);
                    double sortedDistance = DistanceOp.distance((Geometry)firstVertex, (Geometry)sortedPoint);
                    assert (sortedDistance >= 0.0);
                    if (newDistance < sortedDistance) {
                        sortedList = this.addPointInListFilterEquals(sortedList, j, curPoint);
                        wasInserted = true;
                        break;
                    }
                    ++j;
                }
                if (!wasInserted && !sortedList.contains(curPoint)) {
                    sortedList.add(curPoint);
                }
                ++i;
            }
            return sortedList;
        }

        private List<Point> addPointInListFilterEquals(List<Point> intersectionList, int insertPosition, Point intersectionPoint) {
            if (intersectionList.contains(intersectionPoint)) {
                return intersectionList;
            }
            intersectionList.add(insertPosition, intersectionPoint);
            return intersectionList;
        }

        public Point searchNearestIntersection() {
            return this.intersectionList.isEmpty() ? null : this.intersectionList.get(0);
        }

        private Point searchNearestIntersectionFrom(Point referencePoint) {
            int positionOfReferencePoint = -1;
            int i = 0;
            while (i < this.intersectionList.size()) {
                Coordinate referenceCoordinate;
                Point point = this.intersectionList.get(i);
                Coordinate pointCoordinate = point.getCoordinate();
                if (pointCoordinate.equals2D(referenceCoordinate = referencePoint.getCoordinate())) {
                    positionOfReferencePoint = i;
                    break;
                }
                ++i;
            }
            if (positionOfReferencePoint == -1) {
                return null;
            }
            Point nexIntersection = null;
            if (positionOfReferencePoint + 1 < this.intersectionList.size()) {
                nexIntersection = this.intersectionList.get(positionOfReferencePoint + 1);
            }
            return nexIntersection;
        }
    }
}

