/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import eu.udig.tools.geometry.split.SplitUtil;

final class IntersectionStrategy {
    private IntersectMemento intersectState = null;

    IntersectionStrategy() {
    }

    public Coordinate getIntersection() {
        return this.intersectState.getIntersection();
    }

    public int getIntersectionPosition() {
        return this.intersectState.getIntersectionPosition();
    }

    public boolean foundIntersection() {
        return this.intersectState.intersects();
    }

    public void findFirstIntersection(Coordinate[] lineCoords, Geometry boundary) {
        assert (boundary instanceof LinearRing || boundary instanceof LineString || boundary instanceof MultiLineString) : "Boundary must be the linear ring.";
        this.intersectState = new IntersectMemento();
        int numGeometries = 0;
        Geometry intersection = null;
        int i = 0;
        while (i < lineCoords.length - 1) {
            intersection = SplitUtil.intersection(lineCoords, i, boundary, false);
            numGeometries = intersection.getNumGeometries();
            if (numGeometries >= 1) break;
            ++i;
        }
        if (numGeometries == 1) {
            this.intersectState.setIntersection(i, intersection);
        } else if (numGeometries > 1) {
            Coordinate firstLineCoord = lineCoords[i];
            Coordinate secondLineCoord = lineCoords[i + 1];
            double minDistance = Double.MAX_VALUE;
            int j = 0;
            while (j < intersection.getNumGeometries()) {
                Geometry pointToTest = intersection.getGeometryN(j);
                double distance = SplitUtil.calculateDistanceFromFirst(pointToTest.getCoordinate(), firstLineCoord, secondLineCoord);
                if (Math.abs(distance) < minDistance) {
                    this.intersectState.setIntersection(i, pointToTest);
                    minDistance = Math.abs(distance);
                }
                ++j;
            }
        }
    }

    public void findLastIntersection(Coordinate[] coordinates, Geometry boundary) {
        assert (boundary instanceof LinearRing || boundary instanceof LineString || boundary instanceof MultiLineString) : "Boundary must be the linear ring.";
        this.intersectState = new IntersectMemento();
        int i = coordinates.length - 1;
        while (i >= 0) {
            Geometry intersection = SplitUtil.intersection(coordinates, i, boundary, true);
            int numGeometries = intersection.getNumGeometries();
            if (numGeometries == 1) {
                this.intersectState.setIntersection(i, intersection);
                return;
            }
            if (numGeometries > 1) {
                Coordinate firstLineCoord = coordinates[i];
                Coordinate secondLineCoord = coordinates[i - 1];
                double minDistance = Double.MAX_VALUE;
                int j = 0;
                while (j < intersection.getNumGeometries()) {
                    Geometry pointToTest = intersection.getGeometryN(j);
                    double distance = SplitUtil.calculateDistanceFromFirst(pointToTest.getCoordinate(), firstLineCoord, secondLineCoord);
                    if (Math.abs(distance) < minDistance) {
                        this.intersectState.setIntersection(i, pointToTest);
                        minDistance = Math.abs(distance);
                    }
                    ++j;
                }
                return;
            }
            --i;
        }
    }

    public void findLastIntersectionPosition(Coordinate[] coordinates, Geometry boundary) {
        assert (boundary instanceof LinearRing || boundary instanceof LineString || boundary instanceof MultiLineString) : "Boundary must be the linear ring.";
        this.intersectState = new IntersectMemento();
        int i = coordinates.length - 1;
        while (i >= 0) {
            Geometry intersection = SplitUtil.intersection(coordinates, i, boundary, true);
            int numGeometries = intersection.getNumGeometries();
            if (numGeometries >= 1) {
                this.intersectState.setIntersection(i, intersection);
                return;
            }
            --i;
        }
    }

    private static class IntersectMemento {
        private Coordinate intersectionPoint = null;
        private int intersectionPosition = -1;

        public void setIntersection(int position, Geometry point) {
            assert (position >= 0 && point != null) : "illegal intersection state";
            this.intersectionPoint = point.getCoordinate();
            this.intersectionPosition = position;
        }

        public Coordinate getIntersection() {
            return this.intersectionPoint;
        }

        public int getIntersectionPosition() {
            return this.intersectionPosition;
        }

        public boolean intersects() {
            return this.intersectionPosition != -1;
        }
    }
}

