/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryList;
import eu.udig.tools.geometry.split.RingUtil;
import eu.udig.tools.geometry.split.SplitUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class AdaptedPolygon
implements Cloneable {
    private Polygon originalPolygon;
    private Map<LinearRing, Map<String, LineString>> ringSegmentAdaptedAssociation = new LinkedHashMap<LinearRing, Map<String, LineString>>();
    private GeometryFactory geomFactory;

    public AdaptedPolygon(Polygon original, LineString splitLine) {
        this.geomFactory = original.getFactory();
        this.originalPolygon = original;
        this.initSegmentAssociation(original, splitLine);
    }

    public AdaptedPolygon(Polygon original) {
        this.geomFactory = original.getFactory();
        this.originalPolygon = original;
        this.initSegmentAssociation(original, null);
    }

    public final Object clone() {
        AdaptedPolygon duplicated;
        block4: {
            duplicated = null;
            try {
                duplicated = (AdaptedPolygon)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        duplicated.geomFactory = this.geomFactory;
        duplicated.originalPolygon = (Polygon)this.originalPolygon.clone();
        duplicated.ringSegmentAdaptedAssociation = new LinkedHashMap<LinearRing, Map<String, LineString>>();
        for (Map.Entry<LinearRing, Map<String, LineString>> ringSegmentEntry : this.ringSegmentAdaptedAssociation.entrySet()) {
            LinearRing ring = ringSegmentEntry.getKey();
            LinkedHashMap<String, LineString> newSegmentMap = new LinkedHashMap<String, LineString>();
            Map<String, LineString> sourceSegmentMap = ringSegmentEntry.getValue();
            for (Map.Entry<String, LineString> segmentEntry : sourceSegmentMap.entrySet()) {
                newSegmentMap.put(segmentEntry.getKey(), (LineString)segmentEntry.getValue().clone());
            }
            duplicated.ringSegmentAdaptedAssociation.put(ring, newSegmentMap);
        }
        return duplicated;
    }

    private void initSegmentAssociation(Polygon originalPolygon, LineString splitLine) {
        LinearRing exteriorRing = (LinearRing)this.originalPolygon.getExteriorRing();
        Map<String, LineString> exteriorSegments = this.createSegmentAdaptedAssociation(exteriorRing, splitLine);
        this.ringSegmentAdaptedAssociation.put(exteriorRing, exteriorSegments);
        int i = 0;
        while (i < this.originalPolygon.getNumInteriorRing()) {
            LinearRing interiorRing = (LinearRing)this.originalPolygon.getInteriorRingN(i);
            Map<String, LineString> interiorSegments = this.createSegmentAdaptedAssociation(interiorRing, splitLine);
            this.ringSegmentAdaptedAssociation.put(interiorRing, interiorSegments);
            ++i;
        }
    }

    private Map<String, LineString> createSegmentAdaptedAssociation(LinearRing ring, LineString splitLine) {
        List<LineString> segmentList = RingUtil.ringToSegmentList(ring);
        LinkedHashMap<String, LineString> segmentMap = new LinkedHashMap<String, LineString>(segmentList.size());
        for (LineString segment : segmentList) {
            if (splitLine != null) {
                Geometry intersection = splitLine.intersection((Geometry)segment);
                LineString adaptedSegment = segment;
                if (intersection instanceof Point || intersection instanceof MultiPoint) {
                    int i = 0;
                    while (i < intersection.getNumGeometries()) {
                        Point vertex = (Point)intersection.getGeometryN(i);
                        adaptedSegment = SplitUtil.insertVertexInLine(adaptedSegment, vertex.getCoordinate());
                        ++i;
                    }
                }
                segmentMap.put(adaptedSegment.toText(), adaptedSegment);
                continue;
            }
            segmentMap.put(segment.toText(), segment);
        }
        return segmentMap;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(100);
        for (Map<String, LineString> ringAdaptedSegmentLink : this.ringSegmentAdaptedAssociation.values()) {
            str.append("{");
            for (Map.Entry<String, LineString> segmentAndAdapted : ringAdaptedSegmentLink.entrySet()) {
                str.append("[Original [");
                str.append(segmentAndAdapted.getKey());
                str.append("] ");
                str.append("Adapted [");
                str.append(segmentAndAdapted.getValue());
                str.append("]] ");
            }
            str.append("}");
        }
        return str.toString();
    }

    public Polygon getOriginalPolygon() {
        return this.originalPolygon;
    }

    public Polygon asPolygon() {
        LinearRing originalExteriorRing = (LinearRing)this.originalPolygon.getExteriorRing();
        LinearRing exteriorRing = this.buildAdaptedRing(originalExteriorRing);
        Set<Map.Entry<LinearRing, Map<String, LineString>>> entrySet = this.ringSegmentAdaptedAssociation.entrySet();
        LinearRing[] holes = new LinearRing[entrySet.size() - 1];
        int i = 0;
        for (Map.Entry<LinearRing, Map<String, LineString>> entry : entrySet) {
            LinearRing currentRing = entry.getKey();
            if (currentRing.equals((Geometry)originalExteriorRing)) continue;
            LinearRing holeRing = this.buildAdaptedRing(currentRing);
            holes[i++] = holeRing;
        }
        Polygon polygon = this.geomFactory.createPolygon(exteriorRing, holes);
        return polygon;
    }

    private LinearRing buildAdaptedRing(LinearRing ring) {
        Map<String, LineString> exteriorAdaptedSegment = this.lookupRing(this.ringSegmentAdaptedAssociation, ring);
        assert (exteriorAdaptedSegment != null);
        GeometryList<LineString> values = new GeometryList<LineString>(exteriorAdaptedSegment.values());
        LinearRing newRing = RingUtil.segmentListToRing(values);
        return newRing;
    }

    private Map<String, LineString> lookupRing(Map<LinearRing, Map<String, LineString>> ringSegmentAdaptedAssociation, LinearRing requestRing) {
        Map<String, LineString> segmentsOfRing = null;
        for (Map.Entry<LinearRing, Map<String, LineString>> ringSegmentList : ringSegmentAdaptedAssociation.entrySet()) {
            if (!ringSegmentList.getKey().equals((Geometry)requestRing)) continue;
            segmentsOfRing = ringSegmentList.getValue();
            break;
        }
        return segmentsOfRing;
    }

    public void insertVertex(LinearRing orignalRing, LineString originalRingSegment, Coordinate intersection) {
        Map<String, LineString> segmentMap = this.lookupRing(this.ringSegmentAdaptedAssociation, orignalRing);
        assert (segmentMap != null) : "inexistent ring";
        String wktSegment = originalRingSegment.toText();
        LineString adaptedSegment = segmentMap.get(wktSegment);
        assert (adaptedSegment != null) : "inexistent segment";
        LineString newAdaptedSegment = SplitUtil.insertVertexInLine(adaptedSegment, intersection);
        segmentMap.put(wktSegment, newAdaptedSegment);
    }

    public LinearRing getAdaptedRingOf(LinearRing originalRing) {
        LinearRing adaptedRing = this.buildAdaptedRing(originalRing);
        return adaptedRing;
    }
}

