/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.internal.util;

import com.vividsolutions.jts.algorithm.CentralEndpointIntersector;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import eu.udig.tools.geometry.merge.MergeStrategy;
import eu.udig.tools.internal.i18n.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeometryUtil {
    private static Coordinate[][] inputLines = new Coordinate[2][2];

    private GeometryUtil() {
    }

    public static Geometry geometryUnion(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        Geometry resultGeom = null;
        FeatureIterator iterator = featureCollection.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature currFeature = (SimpleFeature)iterator.next();
                Geometry featureGeom = (Geometry)currFeature.getDefaultGeometry();
                assert (featureGeom != null) : "the feature must have almost one geometry";
                featureGeom.normalize();
                resultGeom = resultGeom == null ? featureGeom : MergeStrategy.mergeOp(resultGeom, featureGeom);
            }
        }
        finally {
            iterator.close();
        }
        return resultGeom;
    }

    public static Geometry[] extractGeometries(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        FeatureIterator iter = featureCollection.features();
        try {
            ArrayList<Geometry> geometries = new ArrayList<Geometry>(featureCollection.size());
            int finalSize = 0;
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (geometry == null) continue;
                if (geometry instanceof GeometryCollection) {
                    GeometryCollection geomSet = (GeometryCollection)geometry;
                    int size = geomSet.getNumGeometries();
                    int j = 0;
                    while (j < size) {
                        geometries.add(geomSet.getGeometryN(j));
                        ++j;
                    }
                    finalSize += size;
                    continue;
                }
                geometries.add(geometry);
                ++finalSize;
            }
            Geometry[] geometryArray = geometries.toArray(new Geometry[finalSize]);
            return geometryArray;
        }
        finally {
            iter.close();
        }
    }

    public static Geometry adapt(Geometry inputGeom, Class<? extends Geometry> adaptTo) {
        Geometry geom;
        ArrayList<Geometry> geomList;
        assert (inputGeom != null) : "inputGeom can't be null";
        assert (adaptTo != null) : "adaptTo can't be null";
        if (Geometry.class.equals(adaptTo)) {
            return inputGeom;
        }
        Class<?> geomClass = inputGeom.getClass();
        if (geomClass.equals(adaptTo)) {
            return inputGeom;
        }
        GeometryFactory gf = inputGeom.getFactory();
        if (MultiPoint.class.equals(adaptTo) && Point.class.equals(geomClass)) {
            return gf.createMultiPoint(new Point[]{(Point)inputGeom});
        }
        if (Polygon.class.equals(adaptTo)) {
            if (adaptTo.equals(geomClass)) {
                return inputGeom;
            }
            Polygonizer polygonnizer = new Polygonizer();
            polygonnizer.add(inputGeom);
            Collection polys = polygonnizer.getPolygons();
            Polygon[] polygons = new ArrayList(polys).toArray(new Polygon[polys.size()]);
            if (polygons.length == 1) {
                return polygons[0];
            }
        }
        if (MultiPolygon.class.equals(adaptTo)) {
            if (adaptTo.equals(geomClass)) {
                return inputGeom;
            }
            if (Polygon.class.equals(geomClass)) {
                return gf.createMultiPolygon(new Polygon[]{(Polygon)inputGeom});
            }
        }
        if (GeometryCollection.class.equals(adaptTo)) {
            return gf.createGeometryCollection(new Geometry[]{inputGeom});
        }
        if (MultiLineString.class.equals(adaptTo) || LineString.class.equals(adaptTo)) {
            LineMerger merger = new LineMerger();
            merger.add(inputGeom);
            Collection mergedLineStrings = merger.getMergedLineStrings();
            ArrayList lineList = new ArrayList(mergedLineStrings);
            LineString[] lineStrings = lineList.toArray(new LineString[mergedLineStrings.size()]);
            assert (lineStrings.length >= 1);
            if (MultiLineString.class.equals(adaptTo)) {
                MultiLineString line = gf.createMultiLineString(lineStrings);
                return line;
            }
            if (lineStrings.length == 1) {
                LineString mergedResult = lineStrings[0];
                return mergedResult;
            }
            String msg = MessageFormat.format(Messages.GeometryUtil_DonotKnowHowAdapt, geomClass.getSimpleName(), adaptTo.getSimpleName());
            throw new IllegalArgumentException(msg);
        }
        if (Polygon.class.equals(adaptTo) && MultiPolygon.class.equals(geomClass)) {
            assert (inputGeom.getNumGeometries() == 1) : "the collection must have 1 element to adapt to Polygon";
            return inputGeom.getGeometryN(1);
        }
        if (LineString.class.equals(adaptTo) && MultiLineString.class.equals(geomClass)) {
            assert (inputGeom.getNumGeometries() == 1) : "the collection must have 1 element to adapt to Polygon";
            return inputGeom.getGeometryN(1);
        }
        if (GeometryCollection.class.equals(geomClass) && (MultiPoint.class.equals(adaptTo) || Point.class.equals(adaptTo))) {
            geomList = new ArrayList<Geometry>();
            int i = 0;
            while (i < inputGeom.getNumGeometries()) {
                geom = inputGeom.getGeometryN(i);
                Class<?> clazz = geom.getClass();
                if (MultiPoint.class.equals(clazz) || Point.class.equals(clazz)) {
                    geomList.add(geom);
                }
                ++i;
            }
            return gf.buildGeometry(geomList);
        }
        if (GeometryCollection.class.equals(geomClass) && (MultiLineString.class.equals(adaptTo) || LineString.class.equals(adaptTo))) {
            geomList = new ArrayList();
            int i = 0;
            while (i < inputGeom.getNumGeometries()) {
                geom = inputGeom.getGeometryN(i);
                Class<?> clazz = geom.getClass();
                if (MultiLineString.class.equals(clazz) || LineString.class.equals(clazz)) {
                    geomList.add(geom);
                }
                ++i;
            }
            return gf.buildGeometry(geomList);
        }
        if (GeometryCollection.class.equals(geomClass) && (MultiPolygon.class.equals(adaptTo) || Polygon.class.equals(adaptTo))) {
            geomList = new ArrayList();
            int i = 0;
            while (i < inputGeom.getNumGeometries()) {
                geom = inputGeom.getGeometryN(i);
                Class<?> clazz = geom.getClass();
                if (MultiPolygon.class.equals(clazz) || Polygon.class.equals(clazz)) {
                    geomList.add(geom);
                }
                ++i;
            }
            return gf.buildGeometry(geomList);
        }
        String msg = MessageFormat.format(Messages.GeometryUtil_DonotKnowHowAdapt, geomClass.getSimpleName(), adaptTo.getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public static GeometryCollection adaptToGeomCollection(ArrayList<Geometry> simpleGeometries, Class<? extends GeometryCollection> expectedClass) {
        if (simpleGeometries.size() == 0) {
            return GeometryUtil.getNullGeometryCollection();
        }
        GeometryFactory geomFactory = simpleGeometries.get(0).getFactory();
        MultiPolygon geomResult = null;
        if (MultiPolygon.class.equals(expectedClass)) {
            geomResult = geomFactory.createMultiPolygon(simpleGeometries.toArray(new Polygon[simpleGeometries.size()]));
        } else if (MultiLineString.class.equals(expectedClass)) {
            geomResult = geomFactory.createMultiLineString(simpleGeometries.toArray(new LineString[simpleGeometries.size()]));
        } else if (MultiPoint.class.equals(expectedClass)) {
            geomResult = geomFactory.createMultiPoint(simpleGeometries.toArray(new Point[simpleGeometries.size()]));
        } else assert (false) : "illegal argument: the expectedClass parameter must be a subclass of GeometryCollection";
        return geomResult;
    }

    private static GeometryCollection getNullGeometryCollection() {
        GeometryFactory gf = new GeometryFactory();
        return gf.createGeometryCollection(new Geometry[0]);
    }

    public static Geometry adapt(ArrayList<Geometry> sourceGeomArray, Class<? extends Geometry> requiredGeom) {
        Geometry result;
        assert (sourceGeomArray.size() >= 1) : "one or more geometries are required in the source geometry collection";
        GeometryFactory geomFactory = sourceGeomArray.get(0).getFactory();
        if (GeometryCollection.class.equals(requiredGeom.getSuperclass())) {
            Class<? extends Geometry> geomCollectionClass = requiredGeom;
            result = GeometryUtil.adaptToGeomCollection(sourceGeomArray, geomCollectionClass);
        } else {
            result = geomFactory.buildGeometry(sourceGeomArray);
        }
        return result;
    }

    public static int getDimension(Class<?> geomClass) {
        if (Point.class.equals(geomClass) || MultiPoint.class.equals(geomClass)) {
            return 0;
        }
        if (LineString.class.equals(geomClass) || MultiLineString.class.equals(geomClass)) {
            return 1;
        }
        if (Polygon.class.equals(geomClass) || MultiPolygon.class.equals(geomClass)) {
            return 2;
        }
        String msg = MessageFormat.format(Messages.GeometryUtil_CannotGetDimension, geomClass.getName());
        throw new IllegalArgumentException(msg);
    }

    public static Class<? extends GeometryCollection> getCompatibleCollection(Class<? extends Geometry> simpleGeometry) {
        if (Point.class.equals(simpleGeometry)) {
            return MultiPoint.class;
        }
        if (LineString.class.equals(simpleGeometry)) {
            return MultiLineString.class;
        }
        if (Polygon.class.equals(simpleGeometry)) {
            return MultiPolygon.class;
        }
        throw new IllegalArgumentException(Messages.GeometryUtil_ExpectedSimpleGeometry);
    }

    public static Geometry convertLineStringIntoPolygonGeometry(SimpleFeature feature) {
        GeometryFactory factory = new GeometryFactory();
        Geometry featureGeom = (Geometry)feature.getDefaultGeometry();
        ArrayList<Polygon> ringsList = new ArrayList<Polygon>();
        int i = 0;
        while (i < featureGeom.getNumGeometries()) {
            Geometry line = featureGeom.getGeometryN(i);
            Coordinate[] lineCoor = line.getCoordinates();
            if (lineCoor.length >= 3) {
                Coordinate[] closedLine = GeometryUtil.closeGeometry(lineCoor);
                try {
                    LinearRing ring = factory.createLinearRing(closedLine);
                    Polygon polygonGeometry = factory.createPolygon(ring, null);
                    ringsList.add(polygonGeometry);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        Geometry combined = factory.buildGeometry(ringsList);
        return combined;
    }

    public static Coordinate[] closeGeometry(Coordinate[] lineCoor) {
        if (lineCoor[0].equals((Object)lineCoor[lineCoor.length - 1])) {
            return lineCoor;
        }
        Coordinate[] closedCoor = new Coordinate[lineCoor.length + 1];
        int i = 0;
        while (i < lineCoor.length) {
            closedCoor[i] = lineCoor[i];
            ++i;
        }
        closedCoor[i] = lineCoor[0];
        assert (closedCoor[0].equals((Object)closedCoor[closedCoor.length - 1]));
        return closedCoor;
    }

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        GeometryUtil.inputLines[0][0] = p1;
        GeometryUtil.inputLines[0][1] = p2;
        GeometryUtil.inputLines[1][0] = q1;
        GeometryUtil.inputLines[1][1] = q2;
        Coordinate intPt = GeometryUtil.intersectionWithNormalization(p1, p2, q1, q2);
        return intPt;
    }

    private static Coordinate intersectionWithNormalization(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate n1 = new Coordinate(p1);
        Coordinate n2 = new Coordinate(p2);
        Coordinate n3 = new Coordinate(q1);
        Coordinate n4 = new Coordinate(q2);
        Coordinate normPt = new Coordinate();
        GeometryUtil.normalizeToEnvCentre(n1, n2, n3, n4, normPt);
        Coordinate intPt = GeometryUtil.safeHCoordinateIntersection(n1, n2, n3, n4);
        intPt.x += normPt.x;
        intPt.y += normPt.y;
        return intPt;
    }

    private static void normalizeToEnvCentre(Coordinate n00, Coordinate n01, Coordinate n10, Coordinate n11, Coordinate normPt) {
        double minX0 = n00.x < n01.x ? n00.x : n01.x;
        double minY0 = n00.y < n01.y ? n00.y : n01.y;
        double maxX0 = n00.x > n01.x ? n00.x : n01.x;
        double maxY0 = n00.y > n01.y ? n00.y : n01.y;
        double minX1 = n10.x < n11.x ? n10.x : n11.x;
        double minY1 = n10.y < n11.y ? n10.y : n11.y;
        double maxX1 = n10.x > n11.x ? n10.x : n11.x;
        double maxY1 = n10.y > n11.y ? n10.y : n11.y;
        double intMinX = minX0 > minX1 ? minX0 : minX1;
        double intMaxX = maxX0 < maxX1 ? maxX0 : maxX1;
        double intMinY = minY0 > minY1 ? minY0 : minY1;
        double intMaxY = maxY0 < maxY1 ? maxY0 : maxY1;
        double intMidX = (intMinX + intMaxX) / 2.0;
        double intMidY = (intMinY + intMaxY) / 2.0;
        normPt.x = intMidX;
        normPt.y = intMidY;
        n00.x -= normPt.x;
        n00.y -= normPt.y;
        n01.x -= normPt.x;
        n01.y -= normPt.y;
        n10.x -= normPt.x;
        n10.y -= normPt.y;
        n11.x -= normPt.x;
        n11.y -= normPt.y;
    }

    private static Coordinate safeHCoordinateIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = null;
        try {
            intPt = HCoordinate.intersection((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        }
        catch (NotRepresentableException notRepresentableException) {
            intPt = CentralEndpointIntersector.getIntersection((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        }
        return intPt;
    }

    public static LineString rotation(LineString input, double angle) {
        Coordinate center = input.getCentroid().getCoordinate();
        return GeometryUtil.rotation(input, angle, center);
    }

    public static LineString rotation(LineString input, double angle, Coordinate center) {
        GeometryFactory gf = input.getFactory();
        Coordinate[] lineCoords = input.getCoordinates();
        LinkedList<Coordinate> rotationCoords = new LinkedList<Coordinate>();
        int i = 0;
        while (i < lineCoords.length) {
            Coordinate actualCoord = lineCoords[i];
            rotationCoords.add(GeometryUtil.rotate(actualCoord, center, angle));
            ++i;
        }
        Coordinate[] newCoords = rotationCoords.toArray(new Coordinate[rotationCoords.size()]);
        return gf.createLineString(newCoords);
    }

    public static Polygon rotation(Polygon input, double angle) {
        Coordinate center = input.getCentroid().getCoordinate();
        return GeometryUtil.rotation(input, angle, center);
    }

    public static Polygon rotation(Polygon input, double angle, Coordinate pivot) {
        GeometryFactory gf = input.getFactory();
        Coordinate[] shellCoords = input.getExteriorRing().getCoordinates();
        LinkedList<Coordinate> rotationShell = new LinkedList<Coordinate>();
        int i = 0;
        while (i < shellCoords.length) {
            Coordinate actualCoord = shellCoords[i];
            rotationShell.add(GeometryUtil.rotate(actualCoord, pivot, angle));
            ++i;
        }
        LinkedList<LinearRing> holes = new LinkedList<LinearRing>();
        int j = 0;
        while (j < input.getNumInteriorRing()) {
            LinkedList<Coordinate> rotationHole = new LinkedList<Coordinate>();
            Coordinate[] holeCoords = input.getInteriorRingN(j).getCoordinates();
            int i2 = 0;
            while (i2 < holeCoords.length) {
                Coordinate actualCoord = holeCoords[i2];
                rotationHole.add(GeometryUtil.rotate(actualCoord, pivot, angle));
                ++i2;
            }
            Coordinate[] rotatedHole = rotationHole.toArray(new Coordinate[rotationHole.size()]);
            holes.add(gf.createLinearRing(rotatedHole));
            ++j;
        }
        Coordinate[] newCoords = rotationShell.toArray(new Coordinate[rotationShell.size()]);
        LinearRing shell = gf.createLinearRing(newCoords);
        LinearRing[] rings = holes.toArray(new LinearRing[holes.size()]);
        return gf.createPolygon(shell, rings);
    }

    private static Coordinate rotate(Coordinate actualCoord, Coordinate center, double angle) {
        Coordinate rotateCoord = new Coordinate();
        rotateCoord.x = Math.cos(angle) * (actualCoord.x - center.x) - Math.sin(angle) * (actualCoord.y - center.y) + center.x;
        rotateCoord.y = Math.sin(angle) * (actualCoord.x - center.x) + Math.cos(angle) * (actualCoord.y - center.y) + center.y;
        assert (rotateCoord != null);
        return rotateCoord;
    }
}

