/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.arc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.arc.internal.ArcFeedbackManager;
import eu.udig.tools.arc.internal.CreateArcBehaviour;
import eu.udig.tools.arc.internal.beahaviour.AcceptFeedbackBehaviour;
import eu.udig.tools.arc.internal.beahaviour.CancelFeedbakBehaviour;
import eu.udig.tools.arc.internal.beahaviour.EditToolFeedbackBehaviour;
import eu.udig.tools.arc.internal.beahaviour.EditToolFeedbackManager;
import eu.udig.tools.arc.internal.beahaviour.NumOfPointsRunAcceptBehaviour;
import eu.udig.tools.arc.internal.presentation.StatusBar;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolConfigurationHelper;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.activator.DrawCurrentGeomVerticesActivator;
import net.refractions.udig.tools.edit.activator.EditStateListenerActivator;
import net.refractions.udig.tools.edit.activator.ResetAllStateActivator;
import net.refractions.udig.tools.edit.activator.SetSnapBehaviourCommandHandlerActivator;
import net.refractions.udig.tools.edit.behaviour.AcceptOnDoubleClickBehaviour;
import net.refractions.udig.tools.edit.behaviour.AddVertexWhileCreatingBehaviour;
import net.refractions.udig.tools.edit.behaviour.DefaultCancelBehaviour;
import net.refractions.udig.tools.edit.behaviour.DrawCreateVertexSnapAreaBehaviour;
import net.refractions.udig.tools.edit.behaviour.SetSnapSizeBehaviour;
import net.refractions.udig.tools.edit.behaviour.StartEditingBehaviour;
import net.refractions.udig.tools.edit.enablement.ValidToolDetectionActivator;
import net.refractions.udig.tools.edit.enablement.WithinLegalLayerBoundsBehaviour;
import net.refractions.udig.tools.edit.support.ShapeType;

public class ArcTool
extends AbstractEditTool {
    private static final String EXTENSION_ID = "es.axios.udig.ui.editingtools.arc.ArcTool";
    private EditToolFeedbackManager arcFeedbackManager;

    private EditToolFeedbackManager getFeedbackManager() {
        if (this.arcFeedbackManager == null) {
            this.arcFeedbackManager = new ArcFeedbackManager();
        }
        return this.arcFeedbackManager;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        IToolContext context = this.getContext();
        if (active && context.getMapLayers().size() > 0) {
            String message = "Arc Tool activated, specify first point";
            StatusBar.setStatusBarMessage(context, message);
        } else {
            StatusBar.setStatusBarMessage(context, "");
        }
    }

    protected void initActivators(Set<Activator> activators) {
        activators.add((Activator)new EditStateListenerActivator());
        activators.add((Activator)new DrawCurrentGeomVerticesActivator());
        activators.add((Activator)new ResetAllStateActivator());
        activators.add((Activator)new SetSnapBehaviourCommandHandlerActivator());
    }

    protected void initAcceptBehaviours(List<Behaviour> acceptBehaviours) {
        acceptBehaviours.add(new CreateArcBehaviour());
        acceptBehaviours.add(new AcceptFeedbackBehaviour(this.getFeedbackManager()));
    }

    protected void initCancelBehaviours(List<Behaviour> cancelBehaviours) {
        cancelBehaviours.add(new CancelFeedbakBehaviour(this.getFeedbackManager()));
        cancelBehaviours.add((Behaviour)new DefaultCancelBehaviour());
    }

    protected void initEventBehaviours(EditToolConfigurationHelper helper) {
        helper.add((EventBehaviour)new DrawCreateVertexSnapAreaBehaviour());
        helper.startMutualExclusiveList();
        helper.add((EventBehaviour)new AddVertexWhileCreatingBehaviour());
        helper.add((EventBehaviour)new StartEditingBehaviour(ShapeType.POINT));
        helper.stopMutualExclusiveList();
        NumOfPointsRunAcceptBehaviour acceptBehaviour = new NumOfPointsRunAcceptBehaviour(3);
        helper.add((EventBehaviour)acceptBehaviour);
        helper.add((EventBehaviour)new SetSnapSizeBehaviour());
        helper.add((EventBehaviour)new EditToolFeedbackBehaviour(this.getFeedbackManager()));
        helper.add((EventBehaviour)new AcceptOnDoubleClickBehaviour());
        helper.done();
    }

    protected void initEnablementBehaviours(List<EnablementBehaviour> enablementBehaviours) {
        enablementBehaviours.add((EnablementBehaviour)new WithinLegalLayerBoundsBehaviour());
        enablementBehaviours.add((EnablementBehaviour)new ValidToolDetectionActivator(new Class[]{Geometry.class, Polygon.class, MultiPolygon.class, LineString.class, MultiLineString.class}));
    }
}

