/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.internal.FontEditor;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.simple.Mode;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class LabelViewer {
    boolean enabled;
    SimpleFeatureType schema;
    String labelType;
    FontData[] font;
    Color colour;
    boolean pointPlacement = true;
    LabelPlacement labelPlacement = null;
    Button on;
    Combo field;
    FontEditor fonter;
    Composite part;
    KeyListener klisten;
    Combo place;
    Combo place2;
    Combo place3;
    Listener sync = new Listener();
    private SelectionListener listener;

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public TextSymbolizer get(StyleBuilder build) {
        LinePlacement placement;
        if (!this.enabled) {
            return null;
        }
        if (this.font == null || this.font.length == 0) {
            return null;
        }
        if (this.labelType == null || "".equals(this.labelType)) {
            return null;
        }
        String fontName = this.font[0].getName();
        boolean fontBold = this.font[0].getStyle() == 1;
        boolean fontItalic = this.font[0].getStyle() == 2;
        double fontSize = this.font[0].getHeight();
        Font gtFont = build.createFont(fontName, fontItalic, fontBold, fontSize);
        Fill fill = build.createFill(this.colour);
        if (this.pointPlacement) {
            double vert;
            double horiz;
            if (this.place.getSelectionIndex() < 3) {
                switch (this.place.getSelectionIndex()) {
                    case 0: {
                        horiz = 1.0;
                        break;
                    }
                    case 1: {
                        horiz = 0.5;
                        break;
                    }
                    case 2: {
                        horiz = 0.0;
                        break;
                    }
                    default: {
                        horiz = 0.5;
                        break;
                    }
                }
            } else {
                horiz = Double.parseDouble(this.place.getText());
            }
            if (this.place2.getSelectionIndex() < 3) {
                switch (this.place2.getSelectionIndex()) {
                    case 0: {
                        vert = 1.0;
                        break;
                    }
                    case 1: {
                        vert = 0.5;
                        break;
                    }
                    case 2: {
                        vert = 0.0;
                        break;
                    }
                    default: {
                        vert = 0.5;
                        break;
                    }
                }
            } else {
                vert = Double.parseDouble(this.place2.getText());
            }
            double rotation = Double.parseDouble(this.place3.getText());
            placement = build.createPointPlacement(vert, horiz, rotation);
        } else {
            double offset = Double.parseDouble(this.place.getText());
            placement = build.createLinePlacement(offset);
        }
        this.labelPlacement = placement;
        PropertyName exp = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()).property(this.labelType);
        TextSymbolizer text = build.createTextSymbolizer(fill, new Font[]{gtFont}, null, (Expression)exp, (LabelPlacement)placement, null);
        if (SLD.isLine(this.schema)) {
            text.addToOptions("group", "yes");
        }
        text.addToOptions("spaceAround", "2");
        return text;
    }

    public void set(SimpleFeatureType schema, TextSymbolizer sym, Mode mode) {
        this.listen(false);
        try {
            this.schema = schema;
            this.enabled = mode != Mode.NONE && sym != null;
            this.font = SLDs.textFont((TextSymbolizer)sym);
            if (this.font == null || this.font.length == 0) {
                this.font = new FontData[]{new FontData("Arial", 12, 0)};
            }
            this.labelType = SLDs.textLabelString((TextSymbolizer)sym);
            this.colour = SLDs.textFontFill((TextSymbolizer)sym);
            if (this.colour == null) {
                this.colour = Color.BLACK;
            }
            this.on.setEnabled(mode != Mode.NONE);
            this.fonter.setColorValue(this.colour);
            this.fonter.setFontList(this.font);
            if (schema != null) {
                AttributeDescriptor[] attrs = schema.getAttributeDescriptors().toArray(new AttributeDescriptor[0]);
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < attrs.length) {
                    Class cls = attrs[i].getType().getBinding();
                    if (String.class.isAssignableFrom(cls)) {
                        list.add(attrs[i].getName().getLocalPart());
                    } else if (Number.class.isAssignableFrom(cls)) {
                        list.add(attrs[i].getName().getLocalPart());
                    }
                    ++i;
                }
                this.field.removeAll();
                this.field.setItems(list.toArray(new String[0]));
                if (this.labelType == null) {
                    this.field.select(0);
                } else {
                    this.field.setText(this.labelType);
                }
            }
            this.on.setSelection(this.enabled);
            this.field.setEnabled(this.enabled);
            this.fonter.setEnabled(this.enabled);
            if (schema != null && (SLD.isLine(schema) == this.pointPlacement || this.place == null)) {
                boolean bl = this.pointPlacement = !SLD.isLine(schema);
                if (this.pointPlacement) {
                    this.initPlacementContentsPoint();
                } else {
                    this.initPlacementContentsLine();
                }
            }
            this.place.setEnabled(this.enabled);
            if (this.pointPlacement) {
                this.place2.setEnabled(this.enabled);
                this.place3.setEnabled(this.enabled);
                if (this.labelPlacement == null || !(this.labelPlacement instanceof PointPlacement)) {
                    if (mode == Mode.POINT) {
                        this.place.select(2);
                        this.place2.select(2);
                    } else {
                        this.place.select(1);
                        this.place2.select(1);
                    }
                    this.place3.select(0);
                } else {
                    AnchorPoint anchor = ((PointPlacement)this.labelPlacement).getAnchorPoint();
                    String anchorX = anchor.getAnchorPointX().toString();
                    String anchorY = anchor.getAnchorPointY().toString();
                    if (anchorX.equals(Double.toString(1.0))) {
                        this.place2.select(0);
                    } else if (anchorX.equals(Double.toString(0.5))) {
                        this.place2.select(1);
                    } else if (anchorX.equals(Double.toString(0.0))) {
                        this.place2.select(2);
                    } else {
                        this.place2.setText(anchorX);
                    }
                    if (anchorY.equals(Double.toString(1.0))) {
                        this.place.select(0);
                    } else if (anchorY.equals(Double.toString(0.5))) {
                        this.place.select(1);
                    } else if (anchorY.equals(Double.toString(0.0))) {
                        this.place.select(2);
                    } else {
                        this.place.setText(anchorY);
                    }
                    this.place3.setText(((PointPlacement)this.labelPlacement).getRotation().toString());
                }
            } else if (this.labelPlacement == null || !(this.labelPlacement instanceof LinePlacement)) {
                this.place.setText(ProjectPlugin.getPlugin().getPreferenceStore().getString("P_STYLE_DEFAULT_PERPENDICULAR_OFFSET"));
            } else {
                String offset = ((LinePlacement)this.labelPlacement).getPerpendicularOffset().toString();
                this.place.setText(offset);
            }
        }
        finally {
            this.listen(true);
        }
    }

    public void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.field.addSelectionListener((SelectionListener)this.sync);
            this.field.addModifyListener((ModifyListener)this.sync);
            this.fonter.setListener(this.sync);
            if (this.place != null) {
                this.place.addSelectionListener((SelectionListener)this.sync);
                this.place.addModifyListener((ModifyListener)this.sync);
            }
            if (this.place2 != null) {
                this.place2.addSelectionListener((SelectionListener)this.sync);
                this.place2.addModifyListener((ModifyListener)this.sync);
            }
            if (this.place3 != null) {
                this.place3.addSelectionListener((SelectionListener)this.sync);
                this.place3.addModifyListener((ModifyListener)this.sync);
            }
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.field.removeSelectionListener((SelectionListener)this.sync);
            this.field.removeModifyListener((ModifyListener)this.sync);
            this.fonter.clearListener();
            if (this.place != null) {
                this.place.removeSelectionListener((SelectionListener)this.sync);
                this.place.removeModifyListener((ModifyListener)this.sync);
            }
            if (this.place2 != null) {
                this.place2.removeSelectionListener((SelectionListener)this.sync);
                this.place2.removeModifyListener((ModifyListener)this.sync);
            }
            if (this.place3 != null) {
                this.place3.removeSelectionListener((SelectionListener)this.sync);
                this.place3.removeModifyListener((ModifyListener)this.sync);
            }
        }
    }

    public Composite createControl(Composite parent, KeyListener klisten) {
        this.part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_label_label);
        this.klisten = klisten;
        this.on = new Button(this.part, 32);
        this.field = new Combo(this.part, 12);
        this.field.addKeyListener(klisten);
        if (this.schema != null) {
            List types = this.schema.getAttributeDescriptors();
            ArrayList<String> typeStrings = new ArrayList<String>();
            for (AttributeDescriptor attributeDescriptor : types) {
                typeStrings.add(attributeDescriptor.getLocalName());
            }
            this.field.setItems(typeStrings.toArray(new String[0]));
        }
        this.field.setToolTipText(Messages.LabelViewer_field_tooltip);
        this.fonter = new FontEditor(this.part);
        if (this.schema != null) {
            this.pointPlacement = !SLD.isLine(this.schema);
            if (this.pointPlacement) {
                this.initPlacementContentsPoint();
            } else {
                this.initPlacementContentsLine();
            }
        }
        this.listen(true);
        return this.part;
    }

    private void initPlacementContentsLine() {
        if (this.place == null) {
            this.place = new Combo(this.part, 4);
            this.place.addKeyListener(this.klisten);
        }
        this.place.setToolTipText(Messages.LabelViewer_offset);
        String[] itemsO = new String[]{"0", "5", "10", "15", "20"};
        this.place.setItems(itemsO);
        if (this.place2 != null) {
            this.place2.setVisible(false);
        }
        if (this.place3 != null) {
            this.place3.setVisible(false);
        }
    }

    private void initPlacementContentsPoint() {
        String[] itemsH = new String[]{Messages.LabelViewer_left, Messages.LabelViewer_center, Messages.LabelViewer_right};
        String[] itemsV = new String[]{Messages.LabelViewer_bottom, Messages.LabelViewer_middle, Messages.LabelViewer_top};
        String[] itemsR = new String[]{"0", "45", "90", "135", "180", "225", "270", "315", "360"};
        if (this.place == null) {
            this.place = new Combo(this.part, 4);
            this.place.addKeyListener(this.klisten);
        }
        this.place.setToolTipText(Messages.LabelViewer_vertAlign);
        this.place.setItems(itemsV);
        if (this.place2 == null) {
            this.place2 = new Combo(this.part, 4);
            this.place2.addKeyListener(this.klisten);
        }
        this.place2.setToolTipText(Messages.LabelViewer_horizAlign);
        this.place2.setItems(itemsH);
        this.place2.setVisible(true);
        if (this.place3 == null) {
            this.place3 = new Combo(this.part, 4);
            this.place3.addKeyListener(this.klisten);
        }
        this.place3.setToolTipText(Messages.LabelViewer_rotation);
        this.place3.setItems(itemsR);
        this.place3.setVisible(true);
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent selectionEvent) {
            block14: {
                try {
                    try {
                        LabelViewer.this.enabled = LabelViewer.this.on.getSelection();
                        LabelViewer.this.colour = LabelViewer.this.fonter.getAWTColor();
                        LabelViewer.this.font = LabelViewer.this.fonter.getFontList();
                        LabelViewer.this.labelType = LabelViewer.this.field.getText();
                    }
                    catch (Throwable throwable) {
                        LabelViewer.this.field.setEnabled(LabelViewer.this.enabled);
                        LabelViewer.this.fonter.setEnabled(LabelViewer.this.enabled);
                        LabelViewer.this.place.setEnabled(LabelViewer.this.enabled);
                        if (LabelViewer.this.pointPlacement) {
                            LabelViewer.this.place2.setEnabled(LabelViewer.this.enabled);
                            LabelViewer.this.place2.setVisible(true);
                            LabelViewer.this.place3.setEnabled(LabelViewer.this.enabled);
                            LabelViewer.this.place3.setVisible(true);
                        } else if (LabelViewer.this.place2 != null) {
                            LabelViewer.this.place2.setVisible(false);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    LabelViewer.this.field.setEnabled(LabelViewer.this.enabled);
                    LabelViewer.this.fonter.setEnabled(LabelViewer.this.enabled);
                    LabelViewer.this.place.setEnabled(LabelViewer.this.enabled);
                    if (LabelViewer.this.pointPlacement) {
                        LabelViewer.this.place2.setEnabled(LabelViewer.this.enabled);
                        LabelViewer.this.place2.setVisible(true);
                        LabelViewer.this.place3.setEnabled(LabelViewer.this.enabled);
                        LabelViewer.this.place3.setVisible(true);
                    } else if (LabelViewer.this.place2 != null) {
                        LabelViewer.this.place2.setVisible(false);
                    }
                    throw throwable;
                }
                LabelViewer.this.field.setEnabled(LabelViewer.this.enabled);
                LabelViewer.this.fonter.setEnabled(LabelViewer.this.enabled);
                LabelViewer.this.place.setEnabled(LabelViewer.this.enabled);
                if (LabelViewer.this.pointPlacement) {
                    LabelViewer.this.place2.setEnabled(LabelViewer.this.enabled);
                    LabelViewer.this.place2.setVisible(true);
                    LabelViewer.this.place3.setEnabled(LabelViewer.this.enabled);
                    LabelViewer.this.place3.setVisible(true);
                } else if (LabelViewer.this.place2 != null) {
                    LabelViewer.this.place2.setVisible(false);
                }
            }
            LabelViewer.this.fire(selectionEvent);
        }
    }
}

