/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.styling.SelectedChannelType;
import org.opengis.filter.expression.Literal;

public class ChannelViewer {
    private Group channelGrp;
    private Combo cmbBands;
    private Label lblLevel;
    private Spinner spnLevel;
    private Label lblBand;
    private Label lblHistogram;
    private String name;
    private int bandIndex;
    private java.awt.Color channelColor;
    private SelectionListener listener;
    private int[][] histogramData = null;
    private Listener sync = new Listener();

    public ChannelViewer(String name, java.awt.Color channelColor, int bandIndex) {
        this.name = name;
        this.channelColor = channelColor;
        this.bandIndex = bandIndex;
    }

    public void setBands(String[] bands) {
        if (this.cmbBands != null) {
            this.cmbBands.removeAll();
            String[] stringArray = bands;
            int n = bands.length;
            int n2 = 0;
            while (n2 < n) {
                String band = stringArray[n2];
                this.cmbBands.add(band);
                ++n2;
            }
        }
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public void set(SelectedChannelType channel, int defaultValue) {
        this.listen(false);
        try {
            int channelindex = -1;
            if (channel != null) {
                String channelname = channel.getChannelName();
                try {
                    channelindex = Integer.parseInt(channelname);
                    this.cmbBands.setText(--channelindex < this.cmbBands.getItemCount() ? this.cmbBands.getItem(channelindex) : this.cmbBands.getItem(0));
                }
                catch (Exception exception) {
                    this.cmbBands.setText(this.cmbBands.getItem(0));
                }
                Double v = (Double)((Literal)channel.getContrastEnhancement().getGammaValue()).getValue();
                if (v != null) {
                    this.spnLevel.setSelection((int)(v * 10.0));
                }
            } else {
                this.cmbBands.setText(defaultValue < this.cmbBands.getItemCount() ? this.cmbBands.getItem(defaultValue) : this.cmbBands.getItem(0));
                this.spnLevel.setSelection(10);
            }
            this.drawHistogram();
        }
        finally {
            this.listen(true);
        }
    }

    public void updateHistogram(int[][] histValues) {
        this.histogramData = histValues;
        this.drawHistogram();
    }

    private void drawHistogram() {
        if (this.histogramData == null) {
            this.lblHistogram.setText("Loading ...");
            return;
        }
        Image oldImage = this.lblHistogram.getImage();
        Rectangle bounds = this.lblHistogram.getBounds();
        Display display = this.lblHistogram.getDisplay();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        Image newImage = new Image((Device)display, bounds.width, bounds.height);
        this.lblHistogram.setText(Messages.ChannelViewer_HistogramLabel);
        GC gc = new GC((Drawable)newImage);
        if (this.bandIndex < 0 || this.bandIndex > this.histogramData.length) {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            return;
        }
        int[] histValues = this.histogramData[this.bandIndex];
        int max = -1;
        int[] nArray = histValues;
        int n = histValues.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i > max) {
                max = i;
            }
            ++n2;
        }
        Color color2 = null;
        try {
            int height;
            int size = (bounds.width - 1) / 256;
            int inc = 1;
            if (size == 0) {
                inc = (int)Math.ceil(256.0 / (double)(bounds.width - 1));
                int numIntervals = 256 / inc;
                size = (bounds.width - 1) / numIntervals;
            }
            color2 = new Color((Device)display, this.channelColor.getRed(), this.channelColor.getGreen(), this.channelColor.getBlue());
            gc.setForeground(color2);
            double values = 0.0;
            int cnt = 0;
            int i = 0;
            while (i < histValues.length) {
                values += (double)histValues[i];
                ++cnt;
                if (i % inc == 0) {
                    int height2 = (int)((double)(bounds.height - 1) * (values /= (double)cnt) / (double)max);
                    if (height2 > 0) {
                        gc.drawRectangle(i * size, bounds.height - 1, size, -height2);
                    }
                    values = 0.0;
                    cnt = 0;
                }
                ++i;
            }
            if (cnt > 0 && (height = (int)((double)(bounds.height - 1) * (values /= (double)cnt) / (double)max)) > 0) {
                gc.drawRectangle(bounds.width - 2, bounds.height - 1, size, -height);
            }
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        }
        finally {
            gc.dispose();
            if (color2 != null) {
                color2.dispose();
            }
        }
        this.lblHistogram.setImage(newImage);
        if (oldImage != null) {
            oldImage.dispose();
        }
        this.lblHistogram.redraw();
    }

    void listen(boolean listen) {
        if (listen) {
            this.cmbBands.addSelectionListener((SelectionListener)this.sync);
            this.spnLevel.addModifyListener((ModifyListener)this.sync);
        } else {
            this.cmbBands.removeSelectionListener((SelectionListener)this.sync);
            this.spnLevel.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void createControl(Composite parent) {
        this.channelGrp = new Group(parent, 16);
        this.channelGrp.setText(this.name);
        this.channelGrp.setLayoutData((Object)new GridData(768));
        this.channelGrp.setLayout((Layout)new GridLayout(2, false));
        Composite left = new Composite((Composite)this.channelGrp, 0x1000000);
        left.setLayout((Layout)new GridLayout(2, false));
        this.lblBand = new Label(left, 0);
        this.lblBand.setText(Messages.ChannelViewer_BandLabel);
        this.cmbBands = new Combo(left, 12);
        this.cmbBands.setText("-1");
        this.lblLevel = new Label(left, 0);
        this.lblLevel.setText(Messages.ChannelViewer_GammaLabel);
        this.spnLevel = new Spinner(left, 2048);
        this.spnLevel.setValues(255, 0, 255, 1, 1, 5);
        Composite right = new Composite((Composite)this.channelGrp, 0x1000000);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        right.setLayoutData((Object)gd);
        right.setLayout((Layout)new FillLayout(0x10000000));
        this.lblHistogram = new Label(right, 0);
        this.lblHistogram.setText(Messages.ChannelViewer_HistogramLabel);
    }

    public void setEnabled(boolean enabled) {
        this.channelGrp.setEnabled(enabled);
        this.cmbBands.setEnabled(enabled);
        this.spnLevel.setEnabled(enabled);
        this.lblLevel.setEnabled(enabled);
        this.lblBand.setEnabled(enabled);
        this.lblHistogram.setEnabled(enabled);
        if (enabled) {
            this.drawHistogram();
        }
    }

    public String getName() {
        return String.valueOf(this.cmbBands.getSelectionIndex() + 1);
    }

    public double getGamma() {
        return (double)this.spnLevel.getSelection() / 10.0;
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent e) {
            ChannelViewer.this.fire(e);
        }
    }
}

