/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.internal;

import java.awt.Color;
import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.internal.StolenColorEditor;
import net.refractions.udig.style.sld.internal.SymbolizerContent;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleBuilder;
import org.opengis.style.Fill;
import org.opengis.style.Stroke;

public class SLDMarkerEditorPart
extends SLDEditorPart
implements SelectionListener {
    private int opacityMaxValue = 100;
    private double opacityMaxValueFloat = 100.0;
    private StolenColorEditor borderColour;
    private Button borderEnabled;
    private Spinner borderWidth;
    private Spinner borderOpacity;
    private StolenColorEditor markerColour;
    private Button markerEnabled;
    private Combo markerType;
    private Spinner markerWidth;
    private Spinner markerOpacity;

    @Override
    public Class getContentType() {
        return PointSymbolizer.class;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.setStylingElements((PointSymbolizer)this.getContent());
    }

    private void setStylingElements(PointSymbolizer symbolizer) {
        int index;
        Color fill = SLDs.pointFill((PointSymbolizer)symbolizer);
        Color border = SLDs.pointColor((PointSymbolizer)symbolizer);
        int markerSize = SLDs.pointSize((PointSymbolizer)symbolizer);
        int borderSize = SLDs.pointWidth((PointSymbolizer)symbolizer);
        String wellKnownName = SLDs.pointWellKnownName((PointSymbolizer)symbolizer);
        if (markerSize == -1) {
            markerSize = 1;
        }
        this.markerWidth.setSelection(markerSize);
        RGB colour = null;
        if (fill != null) {
            colour = new RGB(fill.getRed(), fill.getGreen(), fill.getBlue());
            this.markerEnabled.setSelection(true);
        } else {
            colour = new RGB(SymbolizerContent.DEFAULT_MARKER_COLOR.getRed(), SymbolizerContent.DEFAULT_MARKER_COLOR.getGreen(), SymbolizerContent.DEFAULT_MARKER_COLOR.getBlue());
            this.markerEnabled.setSelection(false);
        }
        this.markerColour.setColorValue(colour);
        this.borderWidth.setSelection(borderSize);
        if (border != null) {
            colour = new RGB(border.getRed(), border.getGreen(), border.getBlue());
            this.borderEnabled.setSelection(true);
        } else {
            colour = new RGB(SymbolizerContent.DEFAULT_BORDER_COLOR.getRed(), SymbolizerContent.DEFAULT_BORDER_COLOR.getGreen(), SymbolizerContent.DEFAULT_BORDER_COLOR.getBlue());
            this.borderEnabled.setSelection(false);
        }
        this.borderColour.setColorValue(colour);
        this.markerType.setItems(this.getStyleBuilder().getWellKnownMarkNames());
        if (wellKnownName == null) {
            wellKnownName = "circle";
        }
        if ((index = this.markerType.indexOf(wellKnownName)) == -1) {
            this.markerType.add(wellKnownName);
            this.markerType.select(0);
        } else {
            this.markerType.select(index);
        }
        double opacity = SLDs.pointBorderOpacity((PointSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.borderOpacity.setSelection((int)(opacity * (double)this.opacityMaxValue));
        opacity = SLDs.pointOpacity((PointSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.markerOpacity.setSelection((int)(opacity * (double)this.opacityMaxValue));
    }

    private void apply() {
        PointSymbolizer symbolizer = (PointSymbolizer)this.getContent();
        StyleBuilder styleBuilder = this.getStyleBuilder();
        Graphic g = symbolizer.getGraphic();
        Mark[] mark = new Mark[]{styleBuilder.createMark(this.markerType.getText())};
        RGB colour = this.markerColour.getColorValue();
        if (this.markerEnabled.getSelection()) {
            mark[0].setFill((Fill)styleBuilder.createFill(new Color(colour.red, colour.green, colour.blue)));
            mark[0].getFill().setOpacity(styleBuilder.literalExpression((double)this.markerOpacity.getSelection() / this.opacityMaxValueFloat));
        } else {
            mark[0].setFill(null);
        }
        colour = this.borderColour.getColorValue();
        g.setSize(styleBuilder.literalExpression(new Integer(this.markerWidth.getSelection()).doubleValue()));
        colour = this.borderColour.getColorValue();
        if (this.borderEnabled.getSelection()) {
            mark[0].setStroke((Stroke)styleBuilder.createStroke(new Color(colour.red, colour.green, colour.blue), new Integer(this.borderWidth.getSelection()).doubleValue()));
            mark[0].getStroke().setOpacity(styleBuilder.literalExpression((double)this.borderOpacity.getSelection() / this.opacityMaxValueFloat));
        } else {
            mark[0].setStroke(null);
        }
        g.setMarks(mark);
    }

    private Composite subpart(Composite parent, String tag, int width) {
        Composite subpart = new Composite(parent, 0);
        RowLayout across = new RowLayout();
        across.type = 256;
        across.wrap = true;
        across.pack = true;
        across.fill = true;
        across.marginBottom = 1;
        across.marginRight = 2;
        subpart.setLayout((Layout)across);
        Label label = new Label(subpart, 0);
        label.setText(tag);
        label.setAlignment(131072);
        RowData data = new RowData();
        data.width = 40;
        data.height = 10;
        label.setLayoutData((Object)data);
        return subpart;
    }

    @Override
    protected Control createPartControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.borderPart(parent);
        this.fillPart(parent);
        this.markerPart(parent);
        return parent;
    }

    private void markerPart(Composite parent) {
        Composite marker = this.subpart(parent, Messages.SLDMarkerEditorPart_label_marker, 2);
        this.markerType = new Combo(marker, 8);
        this.markerType.addSelectionListener((SelectionListener)this);
        this.markerWidth = new Spinner(marker, 0);
        this.markerWidth.setMinimum(1);
        this.markerWidth.setMaximum(30);
        this.markerWidth.setPageIncrement(5);
        this.markerWidth.addSelectionListener((SelectionListener)this);
        this.markerWidth.setToolTipText(Messages.SLDMarkerEditorPart_width_tooltip);
    }

    private void borderPart(Composite parent) {
        Composite border = this.subpart(parent, Messages.SLDMarkerEditorPart_label_border, 4);
        this.borderEnabled = new Button(border, 32);
        this.borderEnabled.addSelectionListener((SelectionListener)this);
        this.borderEnabled.setToolTipText(Messages.SLDMarkerEditorPart_border_enabled_tooltip);
        this.borderColour = new StolenColorEditor(border, this);
        this.borderWidth = new Spinner(border, 0);
        this.borderWidth.setMinimum(1);
        this.borderWidth.setMaximum(30);
        this.borderWidth.setPageIncrement(5);
        this.borderWidth.addSelectionListener((SelectionListener)this);
        this.borderWidth.setToolTipText(Messages.SLDMarkerEditorPart_border_width_tooltip);
        this.borderOpacity = new Spinner(border, 0);
        this.borderOpacity.setMinimum(0);
        this.borderOpacity.setMaximum(this.opacityMaxValue);
        this.borderOpacity.setPageIncrement(10);
        this.borderOpacity.setToolTipText(Messages.SLDMarkerEditorPart_border_opacity_tooltip);
    }

    private void fillPart(Composite parent) {
        Composite fill = this.subpart(parent, Messages.SLDMarkerEditorPart_label_fill, 3);
        this.markerEnabled = new Button(fill, 32);
        this.markerEnabled.addSelectionListener((SelectionListener)this);
        this.markerEnabled.setToolTipText(Messages.SLDMarkerEditorPart_marker_enabled_tooltip);
        this.markerColour = new StolenColorEditor(fill, this);
        this.markerOpacity = new Spinner(fill, 0);
        this.markerOpacity.setMinimum(0);
        this.markerOpacity.setMaximum(this.opacityMaxValue);
        this.markerOpacity.setPageIncrement(10);
        this.markerOpacity.setToolTipText(Messages.SLDMarkerEditorPart_fill_opacity_tooltip);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.apply();
    }
}

