/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.internal;

import java.awt.Color;
import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.internal.StolenColorEditor;
import net.refractions.udig.style.sld.internal.SymbolizerContent;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;

public class SLDLineEditorPart
extends SLDEditorPart
implements SelectionListener {
    private StolenColorEditor lineColourEditor;
    Spinner lineWidth;
    Spinner lineOpacity;
    Combo linejoinCombo;
    Combo linecapCombo;
    int opacityMaxValue = 100;
    double opacityMaxValueFloat = 100.0;

    @Override
    public Class<?> getContentType() {
        return LineSymbolizer.class;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.setStylingElements((LineSymbolizer)this.getContent());
    }

    private void setStylingElements(LineSymbolizer symbolizer) {
        int lcindex;
        int index;
        Color colour = null;
        int width = -1;
        Stroke stroke = symbolizer.getStroke();
        if (stroke != null) {
            colour = SLDs.lineColor((LineSymbolizer)symbolizer);
            width = SLDs.lineWidth((LineSymbolizer)symbolizer);
        }
        if (colour == null) {
            colour = SymbolizerContent.DEFAULT_LINE_COLOR;
        }
        this.lineColourEditor.setColorValue(new RGB(colour.getRed(), colour.getGreen(), colour.getBlue()));
        if (width == -1) {
            width = 1;
        }
        this.lineWidth.setSelection(width);
        double opacity = SLDs.lineOpacity((LineSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.lineOpacity.setSelection((int)(opacity * (double)this.opacityMaxValue));
        String linejoin = SLDs.lineLinejoin((LineSymbolizer)symbolizer);
        String[] options = new String[]{"mitre", "round", "bevel"};
        this.linejoinCombo.setItems(options);
        if (linejoin == null) {
            linejoin = "mitre";
        }
        if ((index = this.linejoinCombo.indexOf(linejoin)) == -1) {
            this.linejoinCombo.add(linejoin);
            this.linejoinCombo.select(0);
        } else {
            this.linejoinCombo.select(index);
        }
        String linecap = SLDs.lineLinecap((LineSymbolizer)symbolizer);
        String[] lcoptions = new String[]{"butt", "round", "square"};
        this.linecapCombo.setItems(lcoptions);
        if (linecap == null) {
            linecap = "butt";
        }
        if ((lcindex = this.linecapCombo.indexOf(linecap)) == -1) {
            this.linecapCombo.add(linecap);
            this.linecapCombo.select(0);
        } else {
            this.linecapCombo.select(lcindex);
        }
    }

    private Composite subpart(Composite parent, String tag, int width) {
        Composite subpart = new Composite(parent, 0);
        RowLayout across = new RowLayout();
        across.type = 256;
        across.wrap = true;
        across.pack = true;
        across.fill = true;
        across.marginBottom = 1;
        across.marginRight = 2;
        subpart.setLayout((Layout)across);
        Label label = new Label(subpart, 0);
        label.setText(tag);
        label.setAlignment(131072);
        RowData data = new RowData();
        data.width = 40;
        data.height = 10;
        label.setLayoutData((Object)data);
        return subpart;
    }

    private void strokePart(Composite parent) {
        Composite stroke = this.subpart(parent, Messages.SLDLineEditorPart_label_stroke, 2);
        this.linejoinCombo = new Combo(stroke, 8);
        this.linejoinCombo.addSelectionListener((SelectionListener)this);
        this.linecapCombo = new Combo(stroke, 8);
        this.linecapCombo.addSelectionListener((SelectionListener)this);
    }

    private void borderPart(Composite parent) {
        Composite border = this.subpart(parent, Messages.SLDLineEditorPart_label_border, 4);
        Button borderEnabled = new Button(border, 32);
        borderEnabled.setEnabled(false);
        borderEnabled.setSelection(true);
        this.lineColourEditor = new StolenColorEditor(border, this);
        this.lineWidth = new Spinner(border, 256);
        this.lineWidth.setMinimum(1);
        this.lineWidth.setMaximum(30);
        this.lineWidth.setPageIncrement(5);
        this.lineWidth.addSelectionListener((SelectionListener)this);
        this.lineWidth.setToolTipText(Messages.SLDLineEditorPart_border_width_tooltip);
        this.lineOpacity = new Spinner(border, 256);
        this.lineOpacity.setMinimum(0);
        this.lineOpacity.setMaximum(this.opacityMaxValue);
        this.lineOpacity.setPageIncrement(10);
        this.lineOpacity.addSelectionListener((SelectionListener)this);
        this.lineOpacity.setToolTipText(Messages.SLDLineEditorPart_border_opacity_tooltip);
    }

    @Override
    protected Control createPartControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.borderPart(parent);
        this.strokePart(parent);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.apply();
    }

    public void apply() {
        LineSymbolizer symbolizer = (LineSymbolizer)this.getContent();
        StyleBuilder styleBuilder = this.getStyleBuilder();
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            stroke = this.getStyleBuilder().createStroke();
            symbolizer.setStroke((org.opengis.style.Stroke)stroke);
        }
        Color c = this.lineColourEditor.getColor();
        stroke.setWidth(styleBuilder.literalExpression(this.lineWidth.getSelection()));
        stroke.setColor(styleBuilder.colorExpression(c));
        stroke.setOpacity(styleBuilder.literalExpression((double)this.lineOpacity.getSelection() / this.opacityMaxValueFloat));
        stroke.setLineJoin(styleBuilder.literalExpression(this.linejoinCombo.getText()));
        stroke.setLineCap(styleBuilder.literalExpression(this.linecapCombo.getText()));
    }
}

