/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.text.DecimalFormat;
import org.opengis.coverage.SampleDimensionType;

public class ValueFormatter {
    private DataType rawType = DataType.DOUBLE;
    private DataType dataType;
    private DecimalFormat numberFormat;

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataType getRawDataType() {
        return this.rawType;
    }

    public DecimalFormat getFormat() {
        return this.numberFormat;
    }

    public void setRawDataType(SampleDimensionType type) {
        this.rawType = ValueFormatter.getDefaultDataType(type);
    }

    public void setNumberFormatter(DecimalFormat formatter) {
        this.numberFormat = formatter;
    }

    public String formatNumber(double value) {
        if (this.numberFormat == null) {
            DataType formattype = this.dataType;
            if (formattype == null) {
                formattype = this.rawType;
            }
            if (formattype == DataType.INTEGER) {
                return String.valueOf((int)value);
            }
            if (formattype == DataType.DOUBLE) {
                return String.valueOf(value);
            }
        } else {
            return this.numberFormat.format(value);
        }
        return String.valueOf(value);
    }

    private static DataType getDefaultDataType(SampleDimensionType type) {
        if (type == SampleDimensionType.REAL_32BITS || type == SampleDimensionType.REAL_64BITS) {
            return DataType.DOUBLE;
        }
        if (type == SampleDimensionType.SIGNED_8BITS || type == SampleDimensionType.SIGNED_16BITS || type == SampleDimensionType.SIGNED_32BITS) {
            return DataType.INTEGER;
        }
        if (type == SampleDimensionType.UNSIGNED_1BIT || type == SampleDimensionType.UNSIGNED_2BITS || type == SampleDimensionType.UNSIGNED_4BITS || type == SampleDimensionType.UNSIGNED_8BITS || type == SampleDimensionType.UNSIGNED_16BITS || type == SampleDimensionType.UNSIGNED_32BITS) {
            return DataType.INTEGER;
        }
        return DataType.DOUBLE;
    }

    public static enum DataType {
        INTEGER,
        DOUBLE;

    }
}

