/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ClassificationEngine;
import net.refractions.udig.style.sld.editor.raster.ColorEntry;
import net.refractions.udig.style.sld.editor.raster.IColorMapTypePanel;
import net.refractions.udig.style.sld.editor.raster.UniqueValuesPanel;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.opengis.coverage.grid.GridCoverageReader;

public class UniqueValuesDialog
extends TitleAreaDialog {
    private static final String COMPUTE_LABEL = Messages.UniqueValuesDialog_ComputingLabel;
    private Long sampleSize = ClassificationEngine.WARN_VALUE;
    private Text txtSampleSize;
    private Button chSampleSize;
    private GridCoverageReader layer;
    private ListViewer lstViewer;
    private List<Number> uniqueValues = null;
    private Button btnRecompute;
    Job computeJob = new Job(Messages.UniqueValuesDialog_JobName){

        protected IStatus run(IProgressMonitor monitor) {
            Long thisSampleSize = UniqueValuesDialog.this.sampleSize;
            Set<Double> values = null;
            ClassificationEngine engine = new ClassificationEngine();
            try {
                UniqueValuesDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UniqueValuesDialog.this.btnRecompute.setEnabled(false);
                        UniqueValuesDialog.this.uniqueValues.clear();
                        UniqueValuesDialog.this.lstViewer.setInput((Object)new String[]{COMPUTE_LABEL});
                        UniqueValuesDialog.this.lstViewer.refresh();
                    }
                });
                try {
                    values = engine.computeUniqueValues(UniqueValuesDialog.this.layer, thisSampleSize, monitor);
                }
                catch (Exception e) {
                    SLDPlugin.log(e.getMessage(), e);
                }
                UniqueValuesDialog.this.uniqueValues.addAll(values);
                UniqueValuesDialog.this.sort();
            }
            catch (Throwable throwable) {
                if (UniqueValuesDialog.this.getShell() == null) {
                    return Status.CANCEL_STATUS;
                }
                UniqueValuesDialog.this.getShell().getDisplay().syncExec(new Runnable(engine){
                    private final /* synthetic */ ClassificationEngine val$engine;
                    {
                        this.val$engine = classificationEngine;
                    }

                    @Override
                    public void run() {
                        if (UniqueValuesDialog.this.btnRecompute.isDisposed()) {
                            return;
                        }
                        UniqueValuesDialog.this.setErrorMessage(this.val$engine.getLastErrorMessage());
                        UniqueValuesDialog.this.btnRecompute.setEnabled(true);
                        UniqueValuesDialog.this.lstViewer.setInput((Object)UniqueValuesDialog.this.uniqueValues);
                        UniqueValuesDialog.this.lstViewer.refresh();
                    }
                });
                throw throwable;
            }
            if (UniqueValuesDialog.this.getShell() == null) {
                return Status.CANCEL_STATUS;
            }
            UniqueValuesDialog.this.getShell().getDisplay().syncExec(new /* invalid duplicate definition of identical inner class */);
            return Status.OK_STATUS;
        }
    };

    protected UniqueValuesDialog(Shell parentShell, GridCoverageReader layer) {
        super(parentShell);
        this.layer = layer;
        this.uniqueValues = new ArrayList<Number>();
    }

    public boolean close() {
        this.computeJob.cancel();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 20;
        gl.marginWidth = 20;
        main.setLayout((Layout)gl);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite sampleSizeComp = new Composite(main, 0);
        sampleSizeComp.setLayout((Layout)new GridLayout(3, false));
        sampleSizeComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lbls = new Label(sampleSizeComp, 0);
        lbls.setText(Messages.UniqueValuesDialog_LimitLabel);
        lbls.setToolTipText(Messages.UniqueValuesDialog_LimitTooltip);
        this.chSampleSize = new Button(sampleSizeComp, 32);
        this.chSampleSize.setSelection(false);
        this.chSampleSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UniqueValuesDialog.this.txtSampleSize.setEnabled(UniqueValuesDialog.this.chSampleSize.getSelection());
            }
        });
        this.txtSampleSize = new Text(sampleSizeComp, 2048);
        this.txtSampleSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtSampleSize.setText("100000");
        this.txtSampleSize.setEnabled(false);
        this.btnRecompute = new Button(sampleSizeComp, 0);
        this.btnRecompute.setText(Messages.UniqueValuesDialog_ReCalcButtonName);
        this.btnRecompute.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 3, 1));
        this.btnRecompute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UniqueValuesDialog.this.computeValues();
            }
        });
        Label lblSep = new Label(main, 258);
        lblSep.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite lowerPanel = new Composite(main, 0);
        lowerPanel.setLayout((Layout)new GridLayout(2, false));
        lowerPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblValues = new Label(lowerPanel, 0);
        lblValues.setText(Messages.UniqueValuesDialog_ValuesToAddLabel);
        lblValues.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        this.lstViewer = new ListViewer(lowerPanel);
        this.lstViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lstViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.lstViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.lstViewer.getControl().getLayoutData()).widthHint = 150;
        ((GridData)this.lstViewer.getControl().getLayoutData()).heightHint = 200;
        Composite buttons = new Composite(lowerPanel, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(4, 128, false, false));
        Button btnAdd = new Button(buttons, 8);
        btnAdd.setLayoutData((Object)new GridData(4, 4, true, false));
        btnAdd.setText(Messages.UniqueValuesDialog_AddButton);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(UniqueValuesDialog.this.getParentShell(), Messages.UniqueValuesDialog_AddValueDialogTitle, Messages.UniqueValuesDialog_AddValueDialogMessage, "0", new IInputValidator(){

                    public String isValid(String newText) {
                        try {
                            Double.parseDouble(newText);
                            return null;
                        }
                        catch (Exception exception) {
                            return Messages.UniqueValuesDialog_InvalidNumberText;
                        }
                    }
                });
                if (id.open() == 0) {
                    Double d = Double.valueOf(id.getValue());
                    UniqueValuesDialog.this.uniqueValues.add(d);
                    UniqueValuesDialog.this.lstViewer.refresh();
                }
            }
        });
        Button btnRemove = new Button(buttons, 8);
        btnRemove.setText(Messages.UniqueValuesDialog_RemoveButton);
        btnRemove.setLayoutData((Object)new GridData(4, 4, true, false));
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object x : (IStructuredSelection)UniqueValuesDialog.this.lstViewer.getSelection()) {
                    UniqueValuesDialog.this.uniqueValues.remove(x);
                }
                UniqueValuesDialog.this.lstViewer.refresh();
            }
        });
        super.setTitle(Messages.UniqueValuesDialog_DialogTitle);
        super.setMessage(Messages.UniqueValuesDialog_DialogMessage);
        super.getShell().setText(Messages.UniqueValuesDialog_ShellTitle);
        return main;
    }

    public void updatePanel(IColorMapTypePanel panel) {
        if (!(panel instanceof UniqueValuesPanel)) {
            return;
        }
        ArrayList<ColorEntry> entries = new ArrayList<ColorEntry>();
        for (Number n : this.uniqueValues) {
            ColorEntry ce = new ColorEntry(Color.BLACK, 1.0, n.doubleValue(), "");
            entries.add(ce);
        }
        ((UniqueValuesPanel)panel).setBreaks(entries);
    }

    private void sort() {
        Collections.sort(this.uniqueValues, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                if (o1.doubleValue() < o2.doubleValue()) {
                    return -1;
                }
                if (o1.doubleValue() > o2.doubleValue()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void computeValues() {
        this.sampleSize = null;
        if (this.chSampleSize.getSelection()) {
            this.sampleSize = Long.valueOf(this.txtSampleSize.getText());
        }
        this.computeJob.cancel();
        this.computeJob.schedule();
    }

    protected boolean isResizable() {
        return true;
    }
}

