/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ClassificationEngine;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.geotools.filter.expression.ExpressionBuilder;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.filter.expression.Expression;
import org.osgi.framework.Bundle;

public class PredefinedColorRules {
    public static final String[][] rainbow = new String[][]{{"255", "255", "0"}, {"0", "255", "0"}, {"0", "255", "255"}, {"0", "0", "255"}, {"255", "0", "255"}, {"255", "0", "0"}};
    private List<PredefinedColorRule> colorRules = new ArrayList<PredefinedColorRule>();
    private Double dataMin = null;
    private Double dataMax = null;
    private GridCoverageReader reader = null;
    private double[] noDataValues = null;
    Job minMaxJob = new Job("ComputeMinMax"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                double[] minmax;
                double[] noData = PredefinedColorRules.this.noDataValues;
                if (noData == null) {
                    noData = new double[]{-9999.0};
                }
                if ((minmax = new ClassificationEngine().computeMinMax(noData, PredefinedColorRules.this.reader, ClassificationEngine.WARN_VALUE / 2L)) != null) {
                    PredefinedColorRules.this.setDataMinMax(minmax[0], minmax[1]);
                }
            }
            catch (Exception e) {
                SLDPlugin.log(e.getMessage(), e);
            }
            return Status.OK_STATUS;
        }
    };

    public PredefinedColorRules(GridCoverageReader reader, double[] noData) {
        this.reader = reader;
        this.noDataValues = noData;
    }

    public void dispose() {
        this.colorRules.clear();
        try {
            this.reader.dispose();
        }
        catch (IOException e) {
            SLDPlugin.log(e.getMessage(), e);
        }
    }

    private void setDataMinMax(Double min, Double max) {
        this.dataMax = max;
        this.dataMin = min;
        this.colorRules.clear();
    }

    public List<PredefinedColorRule> getPredefinedSets() {
        if (this.colorRules == null || this.colorRules.size() == 0) {
            this.readColorRules();
        }
        return this.colorRules;
    }

    public void clear() {
        this.colorRules.clear();
    }

    public PredefinedColorRule getPredefinedRule(String name) {
        for (PredefinedColorRule r : this.getPredefinedSets()) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    private void readColorRules() {
        this.colorRules.clear();
        try {
            int n;
            this.colorRules.add(new PredefinedColorRule("rainbow", rainbow));
            File colorTablesFolder = null;
            Bundle bundle = Platform.getBundle((String)"eu.udig.style.advanced");
            if (bundle != null) {
                URL queriesUrl = bundle.getResource("colortables");
                String colorTablesFolderPath = FileLocator.toFileURL((URL)queriesUrl).getPath();
                colorTablesFolder = new File(colorTablesFolderPath);
            } else {
                File[] listFiles;
                File baseFolder = new File("..");
                File[] fileArray = listFiles = baseFolder.listFiles();
                int n2 = listFiles.length;
                n = 0;
                while (n < n2) {
                    File folder = fileArray[n];
                    String name = folder.getName().toLowerCase();
                    if (name.startsWith("eu.hydrologis.jgrass.libs") && !name.contains("external") && !name.contains("scripting")) {
                        colorTablesFolder = new File(folder, "colortables");
                    }
                    ++n;
                }
            }
            if (colorTablesFolder != null && colorTablesFolder.exists()) {
                File[] files;
                File[] fileArray = files = colorTablesFolder.listFiles();
                n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    String name = file.getName();
                    if (name.toLowerCase().endsWith(".clr")) {
                        BufferedReader bR = new BufferedReader(new FileReader(file));
                        ArrayList<String[]> lines = new ArrayList<String[]>();
                        String line = null;
                        int cols = 0;
                        while ((line = bR.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            String[] lineSplit = line.trim().split("\\s+");
                            cols = lineSplit.length;
                            lines.add(lineSplit);
                        }
                        bR.close();
                        String[][] linesArray = (String[][])lines.toArray((T[])new String[lines.size()][cols]);
                        String ruleName = FilenameUtils.getBaseName((String)file.getName());
                        ruleName = ruleName.replaceAll("\\_", " ");
                        this.colorRules.add(new PredefinedColorRule(ruleName, linesArray));
                    }
                    ++n3;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ColorMap parseRulesValuesList(String[][] colorRules) throws IOException {
        ColorMapImpl cm = new ColorMapImpl();
        ExpressionBuilder builder = new ExpressionBuilder();
        if (colorRules[0].length == 3) {
            if (this.dataMin == null && this.dataMax == null) {
                this.minMaxJob.schedule();
                try {
                    this.minMaxJob.join();
                }
                catch (InterruptedException e) {
                    SLDPlugin.log(e.getMessage(), e);
                    return null;
                }
            }
            if (this.dataMin == null) {
                this.dataMin = -100.0;
            }
            if (this.dataMax == null) {
                this.dataMax = 5000.0;
            }
            float rinc = (float)(this.dataMax - this.dataMin) / (float)(colorRules.length - 1);
            int i = 0;
            while (i < colorRules.length - 1) {
                try {
                    double to = this.dataMax + (double)((float)(i + 1) * rinc);
                    Color toColor = new Color(Integer.parseInt(colorRules[i + 1][0]), Integer.parseInt(colorRules[i + 1][1]), Integer.parseInt(colorRules[i + 1][2]));
                    if (i == 0) {
                        double from = this.dataMin + (double)((float)i * rinc);
                        Color fromColor = new Color(Integer.parseInt(colorRules[i][0]), Integer.parseInt(colorRules[i][1]), Integer.parseInt(colorRules[i][2]));
                        ColorMapEntryImpl cme = new ColorMapEntryImpl();
                        cme.setColor((Expression)builder.literal((Object)fromColor).build());
                        cme.setQuantity((Expression)builder.literal((Object)from).build());
                        cm.addColorMapEntry((ColorMapEntry)cme);
                    }
                    ColorMapEntryImpl cme = new ColorMapEntryImpl();
                    cme.setColor((Expression)builder.literal((Object)toColor).build());
                    cme.setQuantity((Expression)builder.literal((Object)to).build());
                    cm.addColorMapEntry((ColorMapEntry)cme);
                }
                catch (NumberFormatException e) {
                    SLDPlugin.log(e.getMessage(), e);
                }
                ++i;
            }
        } else {
            if (colorRules[0].length != 8) {
                throw new IOException("The colortable can have records of 3 or 8 columns. Check your colortables.");
            }
            int i = 0;
            while (i < colorRules.length) {
                try {
                    double to = Double.parseDouble(colorRules[i][4]);
                    Color toColor = new Color(Integer.parseInt(colorRules[i][5]), Integer.parseInt(colorRules[i][6]), Integer.parseInt(colorRules[i][7]));
                    if (i == 0) {
                        double from = Double.parseDouble(colorRules[i][0]);
                        Color fromColor = new Color(Integer.parseInt(colorRules[i][1]), Integer.parseInt(colorRules[i][2]), Integer.parseInt(colorRules[i][3]));
                        ColorMapEntryImpl cme = new ColorMapEntryImpl();
                        cme.setColor((Expression)builder.literal((Object)fromColor).build());
                        cme.setQuantity((Expression)builder.literal((Object)from).build());
                        cm.addColorMapEntry((ColorMapEntry)cme);
                    }
                    ColorMapEntryImpl cme = new ColorMapEntryImpl();
                    cme.setColor((Expression)builder.literal((Object)toColor).build());
                    cme.setQuantity((Expression)builder.literal((Object)to).build());
                    cm.addColorMapEntry((ColorMapEntry)cme);
                }
                catch (NumberFormatException e) {
                    SLDPlugin.log(e.getMessage(), e);
                }
                ++i;
            }
        }
        return cm;
    }

    class PredefinedColorRule {
        String name;
        ColorMap colorMap;
        String[][] rules;

        public PredefinedColorRule(String name, String[][] rules) {
            this.name = name;
            this.rules = rules;
        }

        public String getName() {
            return this.name;
        }

        public ColorMap getColorMap() {
            if (this.colorMap == null) {
                try {
                    this.colorMap = PredefinedColorRules.this.parseRulesValuesList(this.rules);
                }
                catch (Exception ex) {
                    SLDPlugin.log(ex.getMessage(), ex);
                }
            }
            return this.colorMap;
        }
    }
}

