/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ClassificationEngine;
import net.refractions.udig.style.sld.editor.raster.ColorEntry;
import net.refractions.udig.style.sld.editor.raster.IColorMapTypePanel;
import net.refractions.udig.style.sld.editor.raster.IntervalValuesPanel;
import net.refractions.udig.style.sld.editor.raster.RampValuesPanel;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.opengis.coverage.grid.GridCoverageReader;

public class ClassifyDialog
extends TitleAreaDialog {
    private static final String GENERATE_LABEL = Messages.ClassifyDialog_GenerateBreaksButtonText;
    private ComboViewer cmbClass;
    private ListViewer cmbRanges;
    private Text txtIgnore;
    private Text txtSampleSize;
    private Label lblOp;
    private Text txtOp;
    private Button btnCompute;
    private Button chSampleSize;
    private List<Double> breaks;
    private GridCoverageReader layer;
    private ClassifyFunction currentSelection = null;
    private Number currentOption = null;
    private String currentIgnore = null;
    private Long currentSampleSize = null;
    private double[] defaultNoData = null;
    private Job computeValuesJob = new Job(Messages.ClassifyDialog_ComputeBreaksJobName){

        protected IStatus run(IProgressMonitor monitor) {
            List<Double> newBreaks;
            ClassificationEngine engine;
            block16: {
                int i;
                ClassifyFunction function = ClassifyDialog.this.currentSelection;
                Number op = ClassifyDialog.this.currentOption;
                Long sampleSize = ClassifyDialog.this.currentSampleSize;
                String ignore = ClassifyDialog.this.currentIgnore;
                ArrayList<Double> toIgnore = new ArrayList<Double>();
                if (ignore.trim().length() > 0) {
                    String[] str = ignore.split(",");
                    i = 0;
                    while (i < str.length) {
                        try {
                            Double d = Double.parseDouble(str[i]);
                            toIgnore.add(d);
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                double[] valuesToIgnore = new double[toIgnore.size()];
                i = 0;
                while (i < toIgnore.size()) {
                    valuesToIgnore[i] = (Double)toIgnore.get(i);
                    ++i;
                }
                ClassifyDialog.this.breaks.clear();
                engine = new ClassificationEngine();
                if (function == null || op == null) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ClassifyDialog.this.cmbRanges.refresh();
                        ClassifyDialog.this.btnCompute.setEnabled(false);
                    }
                });
                newBreaks = null;
                if (function == ClassifyFunction.EQUAL_INTERNAL) {
                    newBreaks = engine.computeEqualInterval((Integer)op, valuesToIgnore, ClassifyDialog.this.layer, sampleSize);
                } else if (function == ClassifyFunction.DEFINED_INTERVAL) {
                    newBreaks = engine.computeDefinedInterval((Double)op, valuesToIgnore, ClassifyDialog.this.layer, sampleSize);
                } else if (function == ClassifyFunction.QUANTILE) {
                    newBreaks = engine.computeQuantile((Integer)op, valuesToIgnore, ClassifyDialog.this.layer, sampleSize, monitor);
                }
                if (newBreaks != null && !monitor.isCanceled()) break block16;
                IStatus iStatus = Status.CANCEL_STATUS;
                Display.getDefault().syncExec(new Runnable(engine){
                    private final /* synthetic */ ClassificationEngine val$engine;
                    {
                        this.val$engine = classificationEngine;
                    }

                    @Override
                    public void run() {
                        if (!ClassifyDialog.this.cmbRanges.getControl().isDisposed()) {
                            ClassifyDialog.this.setErrorMessage(this.val$engine.getLastErrorMessage());
                            ClassifyDialog.this.cmbRanges.refresh();
                            ClassifyDialog.this.btnCompute.setEnabled(true);
                        }
                    }
                });
                return iStatus;
            }
            try {
                try {
                    ClassifyDialog.this.breaks.clear();
                    ClassifyDialog.this.breaks.addAll(newBreaks);
                }
                catch (Exception ex) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)ClassifyDialog.this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle5, (String)MessageFormat.format(Messages.ClassifyDialog_ErrorComputingValues, ex.getLocalizedMessage()));
                        }
                    });
                    SLDPlugin.log("Error classifying values", ex);
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            return Status.OK_STATUS;
        }
    };

    public ClassifyDialog(Shell parentShell, GridCoverageReader layer, double[] noDataValues) {
        super(parentShell);
        this.layer = layer;
        this.defaultNoData = noDataValues;
    }

    public boolean close() {
        this.computeValuesJob.cancel();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.breaks = new ArrayList<Double>();
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        main.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 20;
        gl.marginWidth = 20;
        main.setLayout((Layout)gl);
        Label lbl = new Label(main, 0);
        lbl.setText(Messages.ClassifyDialog_ClassificationFunctionLabel);
        this.cmbClass = new ComboViewer(main, 2060);
        this.cmbClass.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.cmbClass.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cmbClass.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object x) {
                if (x instanceof ClassifyFunction) {
                    return ((ClassifyFunction)((Object)x)).guiName;
                }
                return super.getText(x);
            }
        });
        this.cmbClass.setInput((Object)ClassifyFunction.values());
        this.cmbClass.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassifyDialog.this.lblOp.setText(((ClassifyDialog)ClassifyDialog.this).getCurrentSelection().opName);
                ClassifyDialog.this.lblOp.getParent().layout();
            }
        });
        this.lblOp = new Label(main, 0);
        this.lblOp.setText(ClassifyFunction.EQUAL_INTERNAL.opName);
        this.txtOp = new Text(main, 2048);
        this.txtOp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtOp.setText("10");
        Label lbl4 = new Label(main, 0);
        lbl4.setText(String.valueOf(Messages.ClassifyDialog_ValuesToIgnoreLabel) + "*");
        this.txtIgnore = new Text(main, 2048);
        this.txtIgnore.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.defaultNoData == null) {
            this.txtIgnore.setText(String.valueOf(IColorMapTypePanel.DEFAULT_NO_DATA));
        } else {
            StringBuilder sb = new StringBuilder();
            double[] dArray = this.defaultNoData;
            int n = this.defaultNoData.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                sb.append(d);
                sb.append(",");
                ++n2;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.txtIgnore.setText(sb.toString());
        }
        Label lbls = new Label(main, 0);
        lbls.setText(Messages.ClassifyDialog_LimitSizeLabel);
        lbls.setToolTipText(Messages.ClassifyDialog_LimitSizeTooltip);
        Composite compSample = new Composite(main, 0);
        GridLayout gla = new GridLayout(2, false);
        gla.marginWidth = 0;
        gla.marginHeight = 0;
        compSample.setLayout((Layout)gla);
        compSample.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chSampleSize = new Button(compSample, 32);
        this.chSampleSize.setSelection(false);
        this.chSampleSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassifyDialog.this.txtSampleSize.setEnabled(ClassifyDialog.this.chSampleSize.getSelection());
            }
        });
        this.txtSampleSize = new Text(compSample, 2048);
        this.txtSampleSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtSampleSize.setText("100000");
        this.txtSampleSize.setEnabled(false);
        this.btnCompute = new Button(main, 8);
        this.btnCompute.setText(GENERATE_LABEL);
        this.btnCompute.setLayoutData((Object)new GridData(0x1000000, 4, true, false, 2, 1));
        this.btnCompute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassifyDialog.this.computeValues();
            }
        });
        Label lblSep = new Label(main, 258);
        lblSep.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label lblRange = new Label(main, 0);
        lblRange.setText(Messages.ClassifyDialog_BreaksLabel);
        lblRange.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.cmbRanges = new ListViewer(main, 2816);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = 150;
        gd.heightHint = 200;
        this.cmbRanges.getControl().setLayoutData((Object)gd);
        this.cmbRanges.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cmbRanges.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cmbRanges.setInput(this.breaks);
        Label lbl3 = new Label(main, 64);
        lbl3.setText("*" + Messages.ClassifyDialog_IgnoreValuesInfo);
        lbl3.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.cmbClass.setSelection((ISelection)new StructuredSelection((Object)ClassifyFunction.EQUAL_INTERNAL));
        this.setMessage(Messages.ClassifyDialog_DialogMessage);
        this.setTitle(Messages.ClassifyDialog_DialogTitle);
        this.getShell().setText(Messages.ClassifyDialog_ShellTitle);
        return main;
    }

    private ClassifyFunction getCurrentSelection() {
        return (ClassifyFunction)((Object)((IStructuredSelection)this.cmbClass.getSelection()).getFirstElement());
    }

    private void computeValues() {
        this.computeValuesJob.cancel();
        this.currentIgnore = this.txtIgnore.getText();
        this.currentSelection = this.getCurrentSelection();
        this.currentSampleSize = null;
        if (this.chSampleSize.getSelection()) {
            try {
                this.currentSampleSize = Long.parseLong(this.txtSampleSize.getText());
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle, (String)Messages.ClassifyDialog_ErrorMessage);
                return;
            }
        }
        if (this.currentSelection == ClassifyFunction.EQUAL_INTERNAL || this.currentSelection == ClassifyFunction.QUANTILE) {
            try {
                this.currentOption = Integer.parseInt(this.txtOp.getText());
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle, (String)MessageFormat.format(Messages.ClassifyDialog_InvalidValueOption, this.currentSelection.opName));
                return;
            }
            if (this.currentOption.intValue() >= 256) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle, (String)MessageFormat.format(Messages.ClassifyDialog_MaxValueError, 255));
                return;
            }
        } else if (this.currentSelection == ClassifyFunction.DEFINED_INTERVAL) {
            try {
                this.currentOption = Double.parseDouble(this.txtOp.getText());
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle3, (String)MessageFormat.format(Messages.ClassifyDialog_InvalidValueOption2, this.currentSelection.opName));
            }
        }
        if (this.currentOption.doubleValue() <= 0.0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ClassifyDialog_ErrorDialogTitle3, (String)MessageFormat.format(Messages.ClassifyDialog_InvalidValue, this.currentSelection.opName));
        }
        this.computeValuesJob.schedule();
    }

    protected boolean isResizable() {
        return true;
    }

    public void updatePanel(IColorMapTypePanel panel) {
        if (panel instanceof IntervalValuesPanel || panel instanceof RampValuesPanel) {
            ArrayList<ColorEntry> entries = new ArrayList<ColorEntry>();
            for (Double d : this.breaks) {
                ColorEntry ce = new ColorEntry(Color.BLACK, 1.0, d, "");
                entries.add(ce);
            }
            if (panel instanceof IntervalValuesPanel) {
                ((IntervalValuesPanel)panel).setBreaks(entries);
            } else if (panel instanceof RampValuesPanel) {
                ((RampValuesPanel)panel).setBreaks(entries);
            }
        }
    }

    private static enum ClassifyFunction {
        EQUAL_INTERNAL(Messages.ClassifyDialog_EqualIntervalLabel, Messages.ClassifyDialog_NumberofIntervalsLabel),
        DEFINED_INTERVAL(Messages.ClassifyDialog_DefinedIntervalLabel, Messages.ClassifyDialog_IntervalSizeLabel),
        QUANTILE(Messages.ClassifyDialog_QuantileLabel, Messages.ClassifyDialog_NumberOfBinsLabel);

        String guiName;
        String opName;

        private ClassifyFunction(String guiName, String opName) {
            this.guiName = guiName;
            this.opName = opName;
        }
    }
}

