/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public class ClassificationEngine {
    private String errorMessage = null;
    public static final Long WARN_VALUE = 1000000L;

    public List<Double> computeDefinedInterval(double interval, double[] valuesToIgnore, GridCoverageReader layer, Long sampleSize) throws Exception {
        this.errorMessage = null;
        double[] minmax = this.computeMinMax(valuesToIgnore, layer, sampleSize);
        if (minmax == null) {
            return null;
        }
        double min = minmax[0];
        double max = minmax[1];
        ArrayList<Double> breaks = new ArrayList<Double>();
        double x = min;
        while (x <= max) {
            breaks.add(x);
            x += interval;
        }
        return breaks;
    }

    public List<Double> computeEqualInterval(int numIntervals, double[] valuesToIgnore, GridCoverageReader layer, Long sampleSize) throws Exception {
        this.errorMessage = null;
        double[] minmax = this.computeMinMax(valuesToIgnore, layer, sampleSize);
        if (minmax == null) {
            return null;
        }
        double min = minmax[0];
        double max = minmax[1];
        double interval = (max - min) / (double)numIntervals;
        ArrayList<Double> breaks = new ArrayList<Double>();
        if (interval == 0.0) {
            breaks.add(min);
        } else {
            double value = min;
            int i = 0;
            while (i < numIntervals) {
                breaks.add(value);
                value += interval;
                ++i;
            }
            breaks.add(max);
        }
        return breaks;
    }

    private boolean warnLargeSize() {
        final boolean[] ret = new boolean[]{true};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.ClassifyDialog_ConfirmDialogText, (String)MessageFormat.format(Messages.ClassifyDialog_RasterCellWaring, WARN_VALUE))) {
                    ret[0] = false;
                }
            }
        });
        return ret[0];
    }

    public double[] computeMinMax(double[] valuesToIgnore, GridCoverageReader layer, Long sampleSize) throws Exception {
        int height;
        Statistic[] stats = new Statistic[]{Statistic.MIN, Statistic.MAX};
        this.errorMessage = null;
        ArrayList<Range> ignore = new ArrayList<Range>();
        if (valuesToIgnore != null) {
            double[] dArray = valuesToIgnore;
            int n = valuesToIgnore.length;
            int n2 = 0;
            while (n2 < n) {
                Double no = dArray[n2];
                ignore.add(new Range((Number)no, new int[0]));
                ++n2;
            }
        }
        GridCoverage gcRaw = layer.read(null);
        if (sampleSize != null) {
            int rSize = (int)Math.ceil(Math.sqrt(sampleSize.doubleValue()));
            GridEnvelope2D gridRange = new GridEnvelope2D(new Rectangle(0, 0, rSize, rSize));
            GridGeometry2D world = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)new ReferencedEnvelope(gcRaw.getEnvelope()));
            DefaultParameterDescriptor gridGeometryDescriptor = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GridGeometry.class, null, (Object)world);
            ParameterGroup readParams = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup("Test", new GeneralParameterDescriptor[]{gridGeometryDescriptor}));
            List list = readParams.values();
            GeneralParameterValue[] values = list.toArray(new GeneralParameterValue[0]);
            gcRaw = layer.read(values);
        }
        GridCoordinates high = gcRaw.getGridGeometry().getGridRange().getHigh();
        GridCoordinates low = gcRaw.getGridGeometry().getGridRange().getLow();
        int width = high.getCoordinateValue(0) - low.getCoordinateValue(0);
        if ((long)(width * (height = high.getCoordinateValue(1) - low.getCoordinateValue(1))) > WARN_VALUE && !this.warnLargeSize()) {
            return null;
        }
        OperationJAI op = new OperationJAI("ZonalStats");
        ParameterValueGroup params = op.getParameters();
        params.parameter("dataImage").setValue((Object)gcRaw);
        params.parameter("stats").setValue((Object)stats);
        params.parameter("bands").setValue((Object)new Integer[]{0});
        if (ignore.size() > 0) {
            params.parameter("ranges").setValue(ignore);
            params.parameter("rangesType").setValue((Object)Range.Type.EXCLUDE);
            params.parameter("rangeLocalStats").setValue(false);
        }
        GridCoverage2D coverage = (GridCoverage2D)op.doOperation(params, null);
        ZonalStats zstats = (ZonalStats)coverage.getProperty("ZonalStatsProperty");
        double min = ((Result)zstats.statistic(Statistic.MIN).results().get(0)).getValue();
        double max = ((Result)zstats.statistic(Statistic.MAX).results().get(0)).getValue();
        return new double[]{min, max};
    }

    public List<Double> computeQuantile(int numBins, double[] valuesToIgnore, GridCoverageReader layer, Long sampleSize, IProgressMonitor monitor) throws Exception {
        int height;
        this.errorMessage = null;
        GridCoverage gcRaw = layer.read(null);
        if (sampleSize != null) {
            int rSize = (int)Math.ceil(Math.sqrt(sampleSize.doubleValue()));
            GridEnvelope2D gridRange = new GridEnvelope2D(new Rectangle(0, 0, rSize, rSize));
            GridGeometry2D world = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)new ReferencedEnvelope(gcRaw.getEnvelope()));
            DefaultParameterDescriptor gridGeometryDescriptor = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GridGeometry.class, null, (Object)world);
            ParameterGroup readParams = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup("Test", new GeneralParameterDescriptor[]{gridGeometryDescriptor}));
            List list = readParams.values();
            GeneralParameterValue[] values = list.toArray(new GeneralParameterValue[0]);
            gcRaw = layer.read(values);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        GridCoordinates high = gcRaw.getGridGeometry().getGridRange().getHigh();
        GridCoordinates low = gcRaw.getGridGeometry().getGridRange().getLow();
        int width = high.getCoordinateValue(0) - low.getCoordinateValue(0);
        if ((long)(width * (height = high.getCoordinateValue(1) - low.getCoordinateValue(1))) > WARN_VALUE && !this.warnLargeSize()) {
            return null;
        }
        int recSize = 1000;
        HashSet<Double> ignoreset = new HashSet<Double>();
        if (valuesToIgnore != null) {
            double[] dArray = valuesToIgnore;
            int n = valuesToIgnore.length;
            int n2 = 0;
            while (n2 < n) {
                Double d = dArray[n2];
                ignoreset.add(d);
                ++n2;
            }
        }
        ArrayList<Double> data = new ArrayList<Double>(width * height);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int w = recSize;
                int h = recSize;
                if (x + recSize > width) {
                    w = width - x;
                }
                if (y + recSize > height) {
                    h = height - y;
                }
                Rectangle r = new Rectangle(x, y, w, h);
                Raster rs = gcRaw.getRenderedImage().getData(r);
                DataBuffer df = rs.getDataBuffer();
                int i = 0;
                while (i < df.getSize()) {
                    Double v = df.getElemDouble(i);
                    if (!ignoreset.contains(v)) {
                        data.add(v);
                    }
                    ++i;
                }
                y += recSize;
            }
            if (monitor.isCanceled()) {
                return null;
            }
            x += recSize;
        }
        Collections.sort(data);
        if (numBins > data.size()) {
            numBins = data.size();
        }
        double[] min = new double[numBins];
        double[] max = new double[numBins];
        int i = 0;
        while (i < numBins) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        int binPop = new Double(Math.ceil((double)data.size() / (double)numBins)).intValue();
        int lastBigBin = data.size() % numBins;
        lastBigBin = lastBigBin == 0 ? numBins : --lastBigBin;
        int item = 0;
        int binIndex = 0;
        while (binIndex < numBins) {
            int binMember = 0;
            while (binMember < binPop) {
                int n = item++;
                double value = (Double)data.get(n);
                if (min[binIndex] > value) {
                    min[binIndex] = value;
                }
                if (max[binIndex] < value) {
                    max[binIndex] = value;
                }
                ++binMember;
            }
            if (lastBigBin == binIndex) {
                --binPop;
            }
            ++binIndex;
        }
        ArrayList<Double> results = new ArrayList<Double>(numBins + 1);
        int i2 = 0;
        while (i2 < numBins) {
            results.add(min[i2]);
            ++i2;
        }
        results.add(max[numBins - 1]);
        return results;
    }

    public Set<Double> computeUniqueValues(GridCoverageReader layer, Long sampleSize, IProgressMonitor monitor) throws IllegalArgumentException, IOException {
        int height;
        this.errorMessage = null;
        GridCoverage gcRaw = layer.read(null);
        if (sampleSize != null) {
            int rSize = (int)Math.ceil(Math.sqrt(sampleSize.doubleValue()));
            GridEnvelope2D gridRange = new GridEnvelope2D(new Rectangle(0, 0, rSize, rSize));
            GridGeometry2D world = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)new ReferencedEnvelope(gcRaw.getEnvelope()));
            DefaultParameterDescriptor gridGeometryDescriptor = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GridGeometry.class, null, (Object)world);
            ParameterGroup readParams = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup("Test", new GeneralParameterDescriptor[]{gridGeometryDescriptor}));
            List list = readParams.values();
            GeneralParameterValue[] values = list.toArray(new GeneralParameterValue[0]);
            gcRaw = layer.read(values);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        GridCoordinates high = gcRaw.getGridGeometry().getGridRange().getHigh();
        GridCoordinates low = gcRaw.getGridGeometry().getGridRange().getLow();
        int width = high.getCoordinateValue(0) - low.getCoordinateValue(0);
        if ((long)(width * (height = high.getCoordinateValue(1) - low.getCoordinateValue(1))) > WARN_VALUE && !this.warnLargeSize()) {
            return null;
        }
        int recSize = 1000;
        boolean maxReached = false;
        HashSet<Double> results = new HashSet<Double>();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int w = recSize;
                int h = recSize;
                if (x + recSize > width) {
                    w = width - x;
                }
                if (y + recSize > height) {
                    h = height - y;
                }
                Rectangle r = new Rectangle(x, y, w, h);
                Raster rs = gcRaw.getRenderedImage().getData(r);
                DataBuffer df = rs.getDataBuffer();
                int i = 0;
                while (i < df.getSize()) {
                    results.add(df.getElemDouble(i));
                    if (results.size() >= 256) {
                        this.errorMessage = MessageFormat.format(Messages.UniqueValuesDialog_MaxValueError, 256);
                        maxReached = true;
                        break;
                    }
                    ++i;
                }
                y += recSize;
            }
            if (maxReached) break;
            if (monitor.isCanceled()) {
                return null;
            }
            x += recSize;
        }
        return results;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }
}

