/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.internal;

import java.awt.Color;
import java.util.List;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.ui.graphics.Glyph;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.geotools.brewer.color.StyleGenerator;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;

public class StyleTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof Rule) {
            Rule rule = (Rule)element;
            String[] colors = SLDs.colors((Rule)rule);
            if (colors.length == 0) {
                return null;
            }
            if (colors.length > 1) {
                SLDPlugin.log("Multiple colours received unexpectedly, proceeding with first colour only.", null);
            }
            Color color = SLDs.toColor((String)colors[0]);
            return Glyph.swatch((Color)color).createImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Style) {
            Style style = (Style)element;
            return style.getTitle();
        }
        if (element instanceof Rule) {
            Rule rule = (Rule)element;
            if (rule.getName().startsWith("rule")) {
                return StyleGenerator.toStyleExpression((Filter)rule.getFilter());
            }
            return rule.getTitle();
        }
        return super.getText(element);
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof Rule) {
            Rule rule = (Rule)element;
            String[] colors = SLDs.colors((Rule)rule);
            if (colors.length == 0) {
                return null;
            }
            Color color = SLDs.toColor((String)colors[0]);
            List symbolizers = rule.symbolizers();
            for (Symbolizer symbolizer : symbolizers) {
                if (symbolizer instanceof PointSymbolizer) {
                    return Glyph.point((Rule)rule).createImage();
                }
                if (symbolizer instanceof LineSymbolizer) {
                    return Glyph.line((Rule)rule).createImage();
                }
                if (!(symbolizer instanceof PolygonSymbolizer)) continue;
                return Glyph.polygon((Rule)rule).createImage();
            }
            return Glyph.swatch((Color)color).createImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (columnIndex == 1) {
            if (element instanceof String) {
                SLDPlugin.log("already knew label", null);
                return (String)element;
            }
            if (element instanceof Rule) {
                Rule rule = (Rule)element;
                return rule.getTitle();
            }
        } else if (columnIndex == 2 && element instanceof Rule) {
            Rule rule = (Rule)element;
            if (rule.getName().startsWith("rule")) {
                return StyleGenerator.toStyleExpression((Filter)rule.getFilter());
            }
            return null;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }
}

