/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.refractions.udig.style.sld.IEditorPage;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import net.refractions.udig.style.sld.editor.internal.CapabilityFilter;
import net.refractions.udig.style.sld.editor.internal.EditorBoldLabelProvider;
import net.refractions.udig.style.sld.editor.internal.EditorDialog;
import net.refractions.udig.style.sld.editor.internal.EditorNodeFilter;
import net.refractions.udig.style.sld.editor.internal.EditorPageContentProvider;
import net.refractions.udig.style.sld.editor.internal.FilteredComboTree;
import net.refractions.udig.style.sld.editor.internal.IEditorNode;
import net.refractions.udig.style.sld.editor.internal.IWorkbenchEditorContainer;
import net.refractions.udig.style.sld.editor.internal.PageHistoryEntry;
import net.refractions.udig.style.sld.editor.internal.PageHistoryHolder;
import net.refractions.udig.style.sld.editor.internal.PatternItemFilter;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class FilteredEditorDialog
extends EditorDialog
implements IWorkbenchEditorContainer {
    protected FilteredComboTree filteredTree;
    private Object pageData;
    IWorkingCopyManager workingCopyManager;
    private Collection<Job> updateJobs = new ArrayList<Job>();
    PageHistoryHolder history = new PageHistoryHolder(this);

    public FilteredEditorDialog(Shell parentShell, EditorPageManager manager) {
        super(parentShell, manager);
    }

    @Override
    protected IEditorNode findNodeMatching(String nodeId) {
        IEditorNode node = super.findNodeMatching(nodeId);
        if (WorkbenchActivityHelper.filterItem((Object)node)) {
            return null;
        }
        return node;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        PatternItemFilter filter = new PatternItemFilter(true);
        int styleBits = 260;
        this.filteredTree = new FilteredComboTree(parent, styleBits, filter);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 7;
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        TreeViewer tree = this.filteredTree.getViewer();
        this.filteredTree.setInitialText(Messages.FilteredEditorDialog_type_filter_text_here);
        this.setContentAndLabelProviders(tree);
        tree.setSorter(new ViewerSorter());
        tree.setInput((Object)this.getEditorPageManager());
        if (this.hasAtMostOnePage(tree)) {
            this.filteredTree.getFilterCombo().setEnabled(false);
            this.filteredTree.getFilterCombo().setSelection(new Point(0, 0));
        }
        tree.addFilter((ViewerFilter)new CapabilityFilter());
        tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilteredEditorDialog.this.handleTreeSelectionChanged(event);
            }
        });
        super.addListeners(this.filteredTree.getViewer());
        return this.filteredTree.getViewer();
    }

    private boolean hasAtMostOnePage(TreeViewer tree) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)tree.getContentProvider();
        Object[] children = contentProvider.getElements(tree.getInput());
        if (children.length <= 1) {
            if (children.length == 0) {
                return true;
            }
            return !contentProvider.hasChildren(children[0]);
        }
        return false;
    }

    protected void setContentAndLabelProviders(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new EditorBoldLabelProvider(this.filteredTree));
        treeViewer.setContentProvider((IContentProvider)new EditorPageContentProvider());
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
    }

    @Override
    protected Control createTreeAreaContents(Composite parent) {
        Composite leftArea = new Composite(parent, 0);
        leftArea.setBackground(parent.getDisplay().getSystemColor(25));
        leftArea.setFont(parent.getFont());
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 1;
        leftLayout.marginHeight = 0;
        leftLayout.marginTop = 7;
        leftLayout.marginWidth = 0;
        leftLayout.marginLeft = 7;
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 0;
        leftArea.setLayout((Layout)leftLayout);
        TreeViewer viewer = this.createTreeViewer(leftArea);
        this.setTreeViewer(viewer);
        this.updateTreeFont(JFaceResources.getDialogFont());
        GridData viewerData = new GridData(1808);
        viewer.getControl().getParent().setLayoutData((Object)viewerData);
        this.layoutTreeAreaControl((Control)leftArea);
        return leftArea;
    }

    public void showOnly(String[] filteredIds) {
        this.filteredTree.addFilter(new EditorNodeFilter(filteredIds));
    }

    public void setPageData(Object pageData) {
        this.pageData = pageData;
    }

    @Override
    protected void createPage(IEditorNode node) {
        super.createPage(node);
        if (this.pageData == null) {
            return;
        }
        IEditorPage page = node.getPage();
        if (page instanceof IEditorPage) {
            page.applyData(this.pageData);
        }
    }

    @Override
    public IEditorPage getCurrentPage() {
        return super.getCurrentPage();
    }

    @Override
    public boolean openPage(String pageId, Object data) {
        this.setPageData(data);
        this.setCurrentPageId(pageId);
        IEditorPage page = this.getCurrentPage();
        if (page instanceof IEditorPage) {
            page.applyData(data);
        }
        return true;
    }

    public final void setCurrentPageId(String EditorPageId) {
        IEditorNode node = this.findNodeMatching(EditorPageId);
        if (node != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
            this.showPage(node);
        }
    }

    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            this.workingCopyManager = new WorkingCopyManager();
        }
        return this.workingCopyManager;
    }

    @Override
    protected void okPressed() {
        super.okPressed();
        if (this.workingCopyManager != null) {
            try {
                this.workingCopyManager.applyChanges();
            }
            catch (BackingStoreException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = Messages.FilteredEditorDialog_save_failed;
                }
                Status errorStatus = new Status(4, "net.refractions.udig.style", 4, msg, (Throwable)e);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.FilteredEditorDialog_very_informative_error, (String)Messages.FilteredEditorDialog_save_failed, (IStatus)errorStatus);
            }
        }
        Iterator<Job> updateIterator = this.updateJobs.iterator();
        while (updateIterator.hasNext()) {
            updateIterator.next().schedule();
        }
    }

    public void registerUpdateJob(Job job) {
        this.updateJobs.add(job);
    }

    Control getContainerToolBar(Composite composite) {
        ToolBar historyBar = new ToolBar(composite, 0x800100);
        ToolBarManager historyManager = new ToolBarManager(historyBar);
        this.history.createHistoryControls(historyBar, historyManager);
        historyManager.update(false);
        return historyBar;
    }

    @Override
    protected boolean showPage(IEditorNode node) {
        boolean success = super.showPage(node);
        if (success) {
            this.history.addHistoryEntry(new PageHistoryEntry(node.getId(), node.getLabelText(), null));
        }
        return success;
    }

    @Override
    public boolean close() {
        if (this.history != null) {
            this.history.dispose();
        }
        return super.close();
    }

    @Override
    protected Composite createTitleArea(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginHeight = 0;
        parentLayout.marginTop = 7;
        parent.setLayout((Layout)parentLayout);
        Composite titleComposite = super.createTitleArea(parent);
        Composite toolbarArea = new Composite(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.verticalSpacing = 0;
        toolbarArea.setLayout((Layout)toolbarLayout);
        toolbarArea.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        Control topBar = this.getContainerToolBar(toolbarArea);
        topBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        return titleComposite;
    }

    @Override
    protected void selectSavedItem() {
        this.getTreeViewer().setInput((Object)this.getEditorPageManager());
        super.selectSavedItem();
        if (this.getTreeViewer().getTree().getItemCount() > 1) {
            this.filteredTree.getFilterControl().setFocus();
        }
    }

    @Override
    protected void updateTreeFont(Font dialogFont) {
        FilteredEditorDialog.applyDialogFont((Control)this.filteredTree);
    }
}

