/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.internal;

import java.util.List;
import net.refractions.udig.style.sld.IEditorPage;
import net.refractions.udig.style.sld.IEditorPageContainer;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.EditorNode;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import net.refractions.udig.style.sld.editor.internal.EditorPageContentProvider;
import net.refractions.udig.style.sld.editor.internal.EditorPageLabelProvider;
import net.refractions.udig.style.sld.editor.internal.IEditorNode;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EditorDialog
extends Dialog
implements IEditorPageContainer,
IPageChangeProvider {
    private static String lastPageId = null;
    private static int lastTreeWidth = 150;
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String PREF_DLG_TITLE_IMG = "preference_dialog_title_image";
    private IEditorPage currentPage;
    private DialogMessageArea messageArea;
    private boolean isHelpAvailable = false;
    private Point lastShellSize;
    private IEditorNode lastSuccessfulNode;
    private Point minimumPageSize = new Point(400, 400);
    private Button okButton;
    private Composite pageContainer;
    private EditorPageManager editorPageManager;
    private boolean showingError = false;
    private Composite titleArea;
    private TreeViewer treeViewer;
    private ListenerList pageChangedListeners = new ListenerList(3);

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile(EditorDialog.class, (String)"images/pref_dialog_title.gif"));
    }

    public EditorDialog(Shell parentShell, EditorPageManager manager) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.editorPageManager = manager;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1: {
                this.cancelPressed();
                return;
            }
            case 17: {
                this.helpPressed();
                return;
            }
        }
    }

    protected void cancelPressed() {
        for (final IEditorNode node : this.editorPageManager.getElements(0)) {
            if (this.getPage(node) == null) continue;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (!EditorDialog.this.getPage(node).performCancel()) {
                        return;
                    }
                }
            });
        }
        this.setReturnCode(1);
        this.close();
    }

    void clearSelectedNode() {
        this.setSelectedNode(null);
    }

    public boolean close() {
        List<?> nodes = this.editorPageManager.getElements(0);
        int i = 0;
        while (i < nodes.size()) {
            IEditorNode node = (IEditorNode)nodes.get(i);
            node.disposeResources();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceResources.getString((String)"EditorDialog.title"));
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (EditorDialog.this.lastShellSize == null) {
                    EditorDialog.this.lastShellSize = EditorDialog.this.getShell().getSize();
                }
            }
        });
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.lastShellSize == null) {
            this.lastShellSize = this.getShell().getSize();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getShell().setDefaultButton(this.okButton);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.isHelpAvailable) {
            this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
    }

    protected Control createContents(final Composite parent) {
        final Control[] control = new Control[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                control[0] = EditorDialog.super.createContents(parent);
                EditorDialog.this.selectSavedItem();
            }
        });
        return control[0];
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout parentLayout = (GridLayout)composite.getLayout();
        parentLayout.numColumns = 4;
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        parentLayout.horizontalSpacing = 0;
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        Control treeControl = this.createTreeAreaContents(composite);
        this.createSash(composite, treeControl);
        Label versep = new Label(composite, 514);
        GridData verGd = new GridData(1040);
        versep.setLayoutData((Object)verGd);
        versep.setLayoutData((Object)new GridData(16384, 4, false, true));
        Composite pageAreaComposite = new Composite(composite, 0);
        pageAreaComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pageAreaComposite.setLayout((Layout)layout);
        Composite titleComposite = new Composite(pageAreaComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.horizontalIndent = 7;
        titleComposite.setLayoutData((Object)titleLayoutData);
        this.createTitleArea(titleComposite);
        Label separator = new Label(pageAreaComposite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.pageContainer = this.createPageContainer(pageAreaComposite);
        GridData pageContainerData = (GridData)this.pageContainer.getLayoutData();
        pageContainerData.horizontalIndent = 7;
        this.pageContainer.setLayoutData((Object)pageContainerData);
        Label bottomSeparator = new Label(parent, 258);
        bottomSeparator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Sash createSash(final Composite composite, final Control rightControl) {
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.setBackground(composite.getDisplay().getSystemColor(25));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)rightControl.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 20) {
                    return;
                }
                Point computedSize = EditorDialog.this.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = EditorDialog.this.getShell().getSize()));
                data.widthHint = newWidthHint;
                EditorDialog.this.setLastTreeWidth(newWidthHint);
                composite.layout(true);
                computedSize = EditorDialog.this.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
                EditorDialog.this.setShellSize(computedSize.x, computedSize.y);
                EditorDialog.this.lastShellSize = EditorDialog.this.getShell().getSize();
            }
        });
        return sash;
    }

    protected Composite createPageContainer(Composite parent) {
        Composite outer = new Composite(parent, 0);
        GridData outerData = new GridData(1808);
        outer.setLayout((Layout)new GridLayout());
        outer.setLayoutData((Object)outerData);
        Composite result = new Composite(outer, 0);
        GridData resultData = new GridData(1808);
        result.setLayout(this.getPageLayout());
        result.setLayoutData((Object)resultData);
        return result;
    }

    protected Layout getPageLayout() {
        return new PageLayout();
    }

    protected Composite createTitleArea(Composite parent) {
        int margins = 2;
        this.titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = margins;
        this.titleArea.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.verticalAlignment = 128;
        this.titleArea.setLayoutData((Object)layoutData);
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(this.titleArea);
        this.titleArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                EditorDialog.this.updateMessage();
            }
        });
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    EditorDialog.this.updateMessage();
                }
                if ("org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    EditorDialog.this.updateMessage();
                    Font dialogFont = JFaceResources.getDialogFont();
                    EditorDialog.this.updateTreeFont(dialogFont);
                    Control[] children = ((Composite)EditorDialog.this.buttonBar).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        children[i].setFont(dialogFont);
                        ++i;
                    }
                }
            }
        };
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        this.messageArea.setTitleLayoutData((Object)this.createMessageAreaData());
        this.messageArea.setMessageLayoutData((Object)this.createMessageAreaData());
        return this.titleArea;
    }

    private FormData createMessageAreaData() {
        FormData messageData = new FormData();
        messageData.top = new FormAttachment(0);
        messageData.bottom = new FormAttachment(100);
        messageData.right = new FormAttachment(100);
        messageData.left = new FormAttachment(0);
        return messageData;
    }

    protected Control createTreeAreaContents(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.setInput((Object)this.getEditorPageManager());
        this.updateTreeFont(JFaceResources.getDialogFont());
        this.layoutTreeAreaControl(this.treeViewer.getControl());
        return this.treeViewer.getControl();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 0);
        this.addListeners(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new EditorPageLabelProvider());
        viewer.setContentProvider((IContentProvider)new EditorPageContentProvider());
        return viewer;
    }

    protected void addListeners(final TreeViewer viewer) {
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            private void handleError() {
                try {
                    viewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
                    EditorDialog.this.showPageFlippingAbortDialog();
                    EditorDialog.this.selectCurrentPageAgain();
                    EditorDialog.this.clearSelectedNode();
                }
                finally {
                    viewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
                }
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IEditorNode selection = EditorDialog.this.getSingleSelection(event.getSelection());
                if (selection instanceof IEditorNode) {
                    if (!EditorDialog.this.isCurrentPageValid()) {
                        this.handleError();
                    } else if (!EditorDialog.this.showPage(selection)) {
                        this.handleError();
                    } else {
                        EditorDialog.this.lastSuccessfulNode = selection;
                    }
                }
            }
        });
        ((Tree)viewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                IEditorNode singleSelection;
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                boolean expanded = viewer.getExpandedState((Object)(singleSelection = EditorDialog.this.getSingleSelection(selection)));
                viewer.setExpandedState((Object)singleSelection, !expanded);
            }
        });
        viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (EditorDialog.this.currentPage != null) {
                    EditorDialog.this.currentPage.performHelp();
                }
            }
        });
    }

    protected IEditorNode findNodeMatching(String nodeId) {
        List<?> nodes = this.editorPageManager.getElements(1);
        for (IEditorNode node : nodes) {
            if (!node.getId().equalsIgnoreCase(nodeId)) continue;
            return node;
        }
        return null;
    }

    protected int getLastRightWidth() {
        return lastTreeWidth;
    }

    public EditorPageManager getEditorPageManager() {
        return this.editorPageManager;
    }

    protected String getSelectedNode() {
        return lastPageId;
    }

    protected IEditorNode getSingleSelection(ISelection selection) {
        IStructuredSelection structured;
        if (!selection.isEmpty() && (structured = (IStructuredSelection)selection).getFirstElement() instanceof IEditorNode) {
            return (IEditorNode)structured.getFirstElement();
        }
        return null;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected boolean isCurrentPageValid() {
        if (this.currentPage == null) {
            return true;
        }
        return this.currentPage.isValid();
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gd = new GridData(1040);
        gd.widthHint = this.getLastRightWidth();
        gd.verticalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public void handleException(Throwable e) {
                SLDPlugin.getDefault().getLog().log((IStatus)new Status(4, "net.refractions.udig.style.sld", 0, e.toString(), e));
                EditorDialog.this.clearSelectedNode();
                String message = JFaceResources.getString((String)"SafeRunnable.errorMessage");
                MessageDialog.openError((Shell)EditorDialog.this.getShell(), (String)JFaceResources.getString((String)"Error"), (String)message);
            }
        });
    }

    void selectCurrentPageAgain() {
        if (this.lastSuccessfulNode == null) {
            return;
        }
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.lastSuccessfulNode));
        this.currentPage.setVisible(true);
    }

    protected void selectSavedItem() {
        IEditorNode node = this.findNodeMatching(this.getSelectedNode());
        if (node == null) {
            EditorNode[] nodes = this.editorPageManager.getRootSubNodes();
            if (lastPageId != null) {
                node = this.findNodeMatching(lastPageId);
            }
            if (node == null && nodes.length > 0) {
                node = nodes[0];
            }
        }
        if (node != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
            this.getTreeViewer().getControl().setFocus();
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        if (newErrorMessage == null) {
            this.messageArea.clearErrorMessage();
        } else {
            this.messageArea.updateText(newErrorMessage, 3);
        }
    }

    private void setLastTreeWidth(int width) {
        lastTreeWidth = width;
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        this.messageArea.updateText(newMessage, newType);
    }

    public void setMinimumPageSize(int minWidth, int minHeight) {
        this.minimumPageSize.x = minWidth;
        this.minimumPageSize.y = minHeight;
    }

    public void setMinimumPageSize(Point size) {
        this.minimumPageSize.x = size.x;
        this.minimumPageSize.y = size.y;
    }

    private void setSelectedNode() {
        String storeValue = null;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection.size() == 1) {
            IEditorNode node = (IEditorNode)selection.getFirstElement();
            storeValue = node.getId();
        }
        this.setSelectedNode(storeValue);
    }

    public void setSelectedNode(String pageId) {
        lastPageId = pageId;
    }

    private void setShellSize(int width, int height) {
        Rectangle preferred = this.getShell().getBounds();
        preferred.width = width;
        preferred.height = height;
        this.getShell().setBounds(this.getConstrainedShellBounds(preferred));
    }

    protected boolean showPage(IEditorNode node) {
        if (node == null) {
            return false;
        }
        if (node.getPage() == null) {
            this.createPage(node);
        }
        if (node.getPage() == null) {
            return false;
        }
        IEditorPage newPage = this.getPage(node);
        if (newPage == this.currentPage) {
            return true;
        }
        if (this.currentPage != null && !this.currentPage.okToLeave()) {
            return false;
        }
        IEditorPage oldPage = this.currentPage;
        this.currentPage = newPage;
        this.currentPage.setContainer(this);
        if (this.currentPage.getControl() == null) {
            final boolean[] failed = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    failed[0] = true;
                }

                public void run() {
                    EditorDialog.this.createPageControl(EditorDialog.this.currentPage, EditorDialog.this.pageContainer);
                }
            });
            if (failed[0]) {
                return false;
            }
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        final Point[] size = new Point[1];
        final Point failed = new Point(-1, -1);
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                size[0] = failed;
            }

            public void run() {
                size[0] = EditorDialog.this.currentPage.computeSize();
            }
        });
        if (size[0].equals((Object)failed)) {
            return false;
        }
        Point contentSize = size[0];
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (oldPage != null) {
            Rectangle rect = this.pageContainer.getClientArea();
            Point containerSize = new Point(rect.width, rect.height);
            int hdiff = contentSize.x - containerSize.x;
            int vdiff = contentSize.y - containerSize.y;
            if ((hdiff > 0 || vdiff > 0) && shellSize.equals((Object)this.lastShellSize)) {
                hdiff = Math.max(0, hdiff);
                vdiff = Math.max(0, vdiff);
                this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
                this.lastShellSize = shell.getSize();
                if (this.currentPage.getControl().getSize().x == 0) {
                    this.currentPage.getControl().setSize(containerSize);
                }
            } else {
                this.currentPage.setSize(containerSize);
            }
        }
        Control[] children = this.pageContainer.getChildren();
        Control currentControl = this.currentPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
        return true;
    }

    protected void createPage(IEditorNode node) {
        node.createPage(this.getPageContainer(), this);
    }

    protected IEditorPage getPage(IEditorNode node) {
        return node.getPage();
    }

    void showPageFlippingAbortDialog() {
    }

    protected void update() {
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.setSelectedNode();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
    }

    @Override
    public void updateButtons() {
        this.okButton.setEnabled(this.isCurrentPageValid());
    }

    @Override
    public void updateMessage() {
        String message = null;
        String errorMessage = null;
        if (this.currentPage != null) {
            message = this.currentPage.getMessage();
            errorMessage = this.currentPage.getErrorMessage();
        }
        int messageType = 0;
        if (message != null && this.currentPage instanceof IMessageProvider) {
            messageType = ((IMessageProvider)this.currentPage).getMessageType();
        }
        if (errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
        } else {
            message = errorMessage;
            messageType = 3;
            if (!this.showingError) {
                this.showingError = true;
            }
        }
        this.messageArea.updateText(message, messageType);
    }

    @Override
    public void updateTitle() {
        if (this.currentPage == null) {
            return;
        }
        this.messageArea.showTitle(this.currentPage.getTitle(), this.currentPage.getImage());
    }

    protected void updateTreeFont(Font dialogFont) {
        this.getTreeViewer().getControl().setFont(dialogFont);
    }

    protected IEditorPage getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(IEditorPage currentPage) {
        this.currentPage = currentPage;
    }

    protected void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    protected Composite getPageContainer() {
        return this.pageContainer;
    }

    protected void setPageContainer(Composite pageContainer) {
        this.pageContainer = pageContainer;
    }

    protected void createPageControl(IEditorPage page, Composite parent) {
        page.createControl(parent);
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    static /* synthetic */ Button access$8(EditorDialog editorDialog, int n) {
        return editorDialog.getButton(n);
    }

    static /* synthetic */ EditorPageManager access$9(EditorDialog editorDialog) {
        return editorDialog.editorPageManager;
    }

    private class PageLayout
    extends Layout {
        private PageLayout() {
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((EditorDialog)EditorDialog.this).minimumPageSize.x;
            int y = ((EditorDialog)EditorDialog.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (EditorDialog.this.currentPage != null) {
                Point size = EditorDialog.this.currentPage.computeSize();
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }
    }
}

