/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.IEditorPageContainer;
import net.refractions.udig.style.sld.IStyleEditorPage;
import net.refractions.udig.style.sld.IStyleEditorPageContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;

public abstract class StyleEditorPage
extends DialogPage
implements IStyleEditorPage {
    protected static final String XPID = "net.refractions.udig.style.sld.StyleEditorPage";
    private IStyleEditorPageContainer container = null;
    private Label descriptionLabel;
    private Point size = null;

    @Override
    public void applyData(Object data) {
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        Dialog.applyDialogFont((Control)page);
        this.initializeDialogUnits((Control)page);
        this.setControl((Control)page);
        this.descriptionLabel = this.createDescriptionLabel(page);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        }
        this.createPageContent(page);
        parent.layout();
        this.container.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (StyleEditorPage.this.getEditorPage() == event.getSelectedPage()) {
                    StyleEditorPage.this.gotFocus();
                }
            }
        });
    }

    public abstract void createPageContent(Composite var1);

    public abstract String getLabel();

    public void init(IWorkbench bench) {
    }

    @Override
    public Point computeSize() {
        if (this.size != null) {
            return this.size;
        }
        Control control = this.getControl();
        if (control != null) {
            this.size = this.doComputeSize();
            return this.size;
        }
        return new Point(0, 0);
    }

    protected Point doComputeSize() {
        Control page = this.getControl();
        if (this.descriptionLabel != null && page != null) {
            Point bodySize = page.computeSize(-1, -1, true);
            GridData gd = (GridData)this.descriptionLabel.getLayoutData();
            gd.widthHint = bodySize.x;
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    @Override
    public abstract boolean performCancel();

    @Override
    public IStyleEditorPageContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(IEditorPageContainer container) {
        if (container instanceof IStyleEditorPageContainer) {
            this.container = (IStyleEditorPageContainer)container;
        }
    }

    @Override
    public void setSize(Point size) {
        this.size = size;
    }

    public void dispose() {
        this.descriptionLabel = null;
        this.container = null;
        this.size = null;
    }

    public abstract String getErrorMessage();

    protected Label createDescriptionLabel(Composite parent) {
        Label result = null;
        String description = this.getDescription();
        if (description != null) {
            result = new Label(parent, 64);
            result.setFont(parent.getFont());
            result.setText(description);
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public StyledLayerDescriptor getSLD() {
        return this.container.getSLD();
    }

    public Style getStyle() {
        return this.container.getStyle();
    }

    public void setStyle(Style style) {
        this.container.setStyle(style);
    }

    public StyleEditorPage getEditorPage() {
        return this;
    }

    public StyleLayer getSelectedLayer() {
        return this.container.getSelectedLayer();
    }

    public abstract void gotFocus();

    public abstract void styleChanged(Object var1);
}

