/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.io.File;
import java.text.MessageFormat;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.SetDefaultStyleProcessor;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.editor.ExportSLD;
import net.refractions.udig.style.sld.editor.ImportSLD;
import net.refractions.udig.style.sld.editor.StyleEditorDialog;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;

class StyleEditorButtonListener
implements Listener {
    private final StyleEditorDialog styleEditorDialog;

    StyleEditorButtonListener(StyleEditorDialog styleEditorDialog) {
        this.styleEditorDialog = styleEditorDialog;
    }

    public void handleEvent(Event event) {
        int buttonId = (Integer)event.widget.getData();
        switch (buttonId) {
            case 32: {
                this.doImport();
                break;
            }
            case 33: {
                this.doExport();
                break;
            }
            case 36: {
                this.doDefaults();
                break;
            }
            case 34: {
                this.doApply();
                break;
            }
            case 35: {
                this.doRevert();
                break;
            }
            case 37: {
                if (!this.doApply()) break;
                this.styleEditorDialog.close();
                break;
            }
            case 38: {
                this.styleEditorDialog.close();
                break;
            }
        }
    }

    private boolean doApply() {
        if (this.styleEditorDialog.getCurrentPage() == null) {
            return false;
        }
        if (this.styleEditorDialog.getCurrentPage().performApply()) {
            this.styleEditorDialog.setExitButtonState();
            this.styleEditorDialog.selectedLayer.apply();
            return true;
        }
        return false;
    }

    private void doDefaults() {
        StyleLayer layer = this.styleEditorDialog.selectedLayer;
        layer.getStyleBlackboard().clear();
        SetDefaultStyleProcessor p = new SetDefaultStyleProcessor(layer.getGeoResource(), (Layer)layer);
        p.run();
        Style style = (Style)layer.getStyleBlackboard().get("net.refractions.udig.style.sld");
        StyledLayerDescriptor oldSLD = null;
        if (style != null) {
            oldSLD = this.styleEditorDialog.getSLD();
        }
        this.styleEditorDialog.selectedLayer.apply();
        this.styleEditorDialog.selectedLayer.getMap().getRenderManager().refresh((ILayer)this.styleEditorDialog.selectedLayer, null);
        if (oldSLD != null) {
            this.styleEditorDialog.getSLD();
        }
        this.styleEditorDialog.setExitButtonState();
        this.styleEditorDialog.getCurrentPage().refresh();
    }

    private void doRevert() {
        this.styleEditorDialog.selectedLayer.revertAll();
        this.styleEditorDialog.selectedLayer.apply();
        this.styleEditorDialog.selectedLayer.getMap().getRenderManager().refresh((ILayer)this.styleEditorDialog.selectedLayer, null);
        this.styleEditorDialog.setExitButtonState();
        this.styleEditorDialog.getCurrentPage().refresh();
    }

    private void doImport() {
        ImportSLD importe = new ImportSLD();
        StyledLayerDescriptor sld = null;
        File file = importe.promptFile(Display.getDefault(), sld);
        if (file != null) {
            try {
                sld = (StyledLayerDescriptor)importe.importFrom(file, null);
            }
            catch (Exception e1) {
                MessageBox mb = new MessageBox(this.styleEditorDialog.getShell(), 33);
                mb.setMessage(MessageFormat.format(Messages.StyleEditor_import_failed, e1.getLocalizedMessage()));
                mb.open();
                throw (RuntimeException)new RuntimeException().initCause(e1);
            }
        }
        if (sld != null) {
            Style newStyle = SLDs.getDefaultStyle(sld);
            this.styleEditorDialog.setStyle(newStyle);
            this.styleEditorDialog.getCurrentPage().refresh();
        }
    }

    private void doExport() {
        StyledLayerDescriptor sld = this.styleEditorDialog.getSLD();
        ExportSLD export = new ExportSLD();
        File file = export.promptFile(Display.getDefault(), sld);
        if (file != null) {
            try {
                export.exportTo(sld, file, null);
            }
            catch (Exception e1) {
                throw (RuntimeException)new RuntimeException().initCause(e1);
            }
        }
    }
}

