/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.style.sld.internal.Messages;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SLDValidator {
    public static String getErrorMessage(InputStream xml, List<SAXParseException> errors) {
        return SLDValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    public static String getErrorMessage(Reader xml, List<SAXParseException> errors) {
        StringBuffer result;
        block22: {
            BufferedReader reader = null;
            result = new StringBuffer();
            result.append(Messages.StyleEditor_xml_validator_common);
            try {
                try {
                    SAXParseException sax;
                    reader = new BufferedReader(xml);
                    String line = reader.readLine();
                    int linenumber = 1;
                    int exceptionNum = 0;
                    if (errors.size() > 0 && (sax = errors.get(0)).getLineNumber() < 0) {
                        result.append("   INVALID XML: " + sax.getLocalizedMessage() + "\n");
                        result.append(" \n");
                        exceptionNum = 1;
                    }
                    while (line != null) {
                        line = line.replace('\n', ' ');
                        line = line.replace('\r', ' ');
                        String header = String.valueOf(linenumber) + ": ";
                        result.append(String.valueOf(header) + line + "\n");
                        boolean keep_going = true;
                        while (keep_going) {
                            if (exceptionNum < errors.size()) {
                                SAXParseException sax2 = errors.get(exceptionNum);
                                if (sax2.getLineNumber() <= linenumber) {
                                    String head = "---------------------".substring(0, header.length() - 1);
                                    String body = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                                    int colNum = sax2.getColumnNumber();
                                    if (colNum < 1) {
                                        colNum = 1;
                                    }
                                    if (colNum > body.length() && colNum > (body = String.valueOf(body) + body + body + body + body + body).length()) {
                                        colNum = body.length();
                                    }
                                    result.append(String.valueOf(head) + body.substring(0, colNum - 1) + "^\n");
                                    result.append("       (line " + sax2.getLineNumber() + ", column " + sax2.getColumnNumber() + ")" + sax2.getLocalizedMessage() + "\n");
                                    ++exceptionNum;
                                    continue;
                                }
                                keep_going = false;
                                continue;
                            }
                            keep_going = false;
                        }
                        line = reader.readLine();
                        ++linenumber;
                    }
                    int t = exceptionNum;
                    while (t < errors.size()) {
                        SAXParseException sax3 = errors.get(t);
                        result.append("       (line " + sax3.getLineNumber() + ", column " + sax3.getColumnNumber() + ")" + sax3.getLocalizedMessage() + "\n");
                        ++t;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public List<SAXParseException> validateSLD(InputStream xml, String SchemaUrl) {
        return this.validateSLD(new InputSource(xml), SchemaUrl);
    }

    public List<SAXParseException> validateSLD(InputSource xml, String SchemaUrl) {
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)SchemaUrl);
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.opengis.net/sld " + SchemaUrl));
            Validator handler = new Validator();
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(xml);
            return handler.errors;
        }
        catch (IOException ioe) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(ioe.getLocalizedMessage(), null));
            return al;
        }
        catch (SAXException e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private class Validator
    extends DefaultHandler {
        public ArrayList<SAXParseException> errors = new ArrayList();

        private Validator() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

